package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAbacPolicy invokes the dms_enterprise.DeleteAbacPolicy API synchronously
func (client *Client) DeleteAbacPolicy(request *DeleteAbacPolicyRequest) (response *DeleteAbacPolicyResponse, err error) {
	response = CreateDeleteAbacPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAbacPolicyWithChan invokes the dms_enterprise.DeleteAbacPolicy API asynchronously
func (client *Client) DeleteAbacPolicyWithChan(request *DeleteAbacPolicyRequest) (<-chan *DeleteAbacPolicyResponse, <-chan error) {
	responseChan := make(chan *DeleteAbacPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAbacPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAbacPolicyWithCallback invokes the dms_enterprise.DeleteAbacPolicy API asynchronously
func (client *Client) DeleteAbacPolicyWithCallback(request *DeleteAbacPolicyRequest, callback func(response *DeleteAbacPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAbacPolicyResponse
		var err error
		defer close(result)
		response, err = client.DeleteAbacPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAbacPolicyRequest is the request struct for api DeleteAbacPolicy
type DeleteAbacPolicyRequest struct {
	*requests.RpcRequest
	Tid          requests.Integer `position:"Query" name:"Tid"`
	AbacPolicyId requests.Integer `position:"Query" name:"AbacPolicyId"`
}

// DeleteAbacPolicyResponse is the response struct for api DeleteAbacPolicy
type DeleteAbacPolicyResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	ErrorMessage       string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success            bool   `json:"Success" xml:"Success"`
	ErrorCode          string `json:"ErrorCode" xml:"ErrorCode"`
	DeletePolicyResult bool   `json:"DeletePolicyResult" xml:"DeletePolicyResult"`
}

// CreateDeleteAbacPolicyRequest creates a request to invoke DeleteAbacPolicy API
func CreateDeleteAbacPolicyRequest() (request *DeleteAbacPolicyRequest) {
	request = &DeleteAbacPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "DeleteAbacPolicy", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAbacPolicyResponse creates a response to parse from DeleteAbacPolicy response
func CreateDeleteAbacPolicyResponse() (response *DeleteAbacPolicyResponse) {
	response = &DeleteAbacPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
