package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterLineageRelation invokes the dataworks_public.RegisterLineageRelation API synchronously
func (client *Client) RegisterLineageRelation(request *RegisterLineageRelationRequest) (response *RegisterLineageRelationResponse, err error) {
	response = CreateRegisterLineageRelationResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterLineageRelationWithChan invokes the dataworks_public.RegisterLineageRelation API asynchronously
func (client *Client) RegisterLineageRelationWithChan(request *RegisterLineageRelationRequest) (<-chan *RegisterLineageRelationResponse, <-chan error) {
	responseChan := make(chan *RegisterLineageRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterLineageRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterLineageRelationWithCallback invokes the dataworks_public.RegisterLineageRelation API asynchronously
func (client *Client) RegisterLineageRelationWithCallback(request *RegisterLineageRelationRequest, callback func(response *RegisterLineageRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterLineageRelationResponse
		var err error
		defer close(result)
		response, err = client.RegisterLineageRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterLineageRelationRequest is the request struct for api RegisterLineageRelation
type RegisterLineageRelationRequest struct {
	*requests.RpcRequest
	LineageRelationRegisterVO RegisterLineageRelationLineageRelationRegisterVO `position:"Body" name:"LineageRelationRegisterVO"  type:"Struct"`
}

// RegisterLineageRelationLineageRelationRegisterVO is a repeated param struct in RegisterLineageRelationRequest
type RegisterLineageRelationLineageRelationRegisterVO struct {
	DestEntity      RegisterLineageRelationLineageRelationRegisterVODestEntity   `name:"DestEntity" type:"Struct"`
	CreateTimestamp string                                                       `name:"CreateTimestamp"`
	Relationship    RegisterLineageRelationLineageRelationRegisterVORelationship `name:"Relationship" type:"Struct"`
	SrcEntity       RegisterLineageRelationLineageRelationRegisterVOSrcEntity    `name:"SrcEntity" type:"Struct"`
}

// RegisterLineageRelationLineageRelationRegisterVODestEntity is a repeated param struct in RegisterLineageRelationRequest
type RegisterLineageRelationLineageRelationRegisterVODestEntity struct {
	Owner         string            `name:"Owner"`
	ParentName    string            `name:"ParentName"`
	EntityType    string            `name:"EntityType"`
	QualifiedName string            `name:"QualifiedName"`
	Name          string            `name:"Name"`
	Attributes    map[string]string `name:"Attributes" type:"Map"`
	DetailUrl     string            `name:"DetailUrl"`
}

// RegisterLineageRelationLineageRelationRegisterVORelationship is a repeated param struct in RegisterLineageRelationRequest
type RegisterLineageRelationLineageRelationRegisterVORelationship struct {
	RelationshipType string            `name:"RelationshipType"`
	Attributes       map[string]string `name:"Attributes" type:"Map"`
	RelationshipGuid string            `name:"RelationshipGuid"`
}

// RegisterLineageRelationLineageRelationRegisterVOSrcEntity is a repeated param struct in RegisterLineageRelationRequest
type RegisterLineageRelationLineageRelationRegisterVOSrcEntity struct {
	Owner         string            `name:"Owner"`
	ParentName    string            `name:"ParentName"`
	EntityType    string            `name:"EntityType"`
	QualifiedName string            `name:"QualifiedName"`
	Name          string            `name:"Name"`
	Attributes    map[string]string `name:"Attributes" type:"Map"`
	DetailUrl     string            `name:"DetailUrl"`
}

// RegisterLineageRelationResponse is the response struct for api RegisterLineageRelation
type RegisterLineageRelationResponse struct {
	*responses.BaseResponse
	HttpStatusCode  int             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage    string          `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	Success         bool            `json:"Success" xml:"Success"`
	ErrorCode       string          `json:"ErrorCode" xml:"ErrorCode"`
	LineageRelation LineageRelation `json:"LineageRelation" xml:"LineageRelation"`
}

// CreateRegisterLineageRelationRequest creates a request to invoke RegisterLineageRelation API
func CreateRegisterLineageRelationRequest() (request *RegisterLineageRelationRequest) {
	request = &RegisterLineageRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "RegisterLineageRelation", "", "")
	request.Method = requests.POST
	return
}

// CreateRegisterLineageRelationResponse creates a response to parse from RegisterLineageRelation response
func CreateRegisterLineageRelationResponse() (response *RegisterLineageRelationResponse) {
	response = &RegisterLineageRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
