package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataSourceMeta invokes the dataworks_public.GetDataSourceMeta API synchronously
func (client *Client) GetDataSourceMeta(request *GetDataSourceMetaRequest) (response *GetDataSourceMetaResponse, err error) {
	response = CreateGetDataSourceMetaResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataSourceMetaWithChan invokes the dataworks_public.GetDataSourceMeta API asynchronously
func (client *Client) GetDataSourceMetaWithChan(request *GetDataSourceMetaRequest) (<-chan *GetDataSourceMetaResponse, <-chan error) {
	responseChan := make(chan *GetDataSourceMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataSourceMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataSourceMetaWithCallback invokes the dataworks_public.GetDataSourceMeta API asynchronously
func (client *Client) GetDataSourceMetaWithCallback(request *GetDataSourceMetaRequest, callback func(response *GetDataSourceMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataSourceMetaResponse
		var err error
		defer close(result)
		response, err = client.GetDataSourceMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataSourceMetaRequest is the request struct for api GetDataSourceMeta
type GetDataSourceMetaRequest struct {
	*requests.RpcRequest
	DatasourceName string           `position:"Query" name:"DatasourceName"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	EnvType        string           `position:"Query" name:"EnvType"`
	ProjectId      requests.Integer `position:"Query" name:"ProjectId"`
}

// GetDataSourceMetaResponse is the response struct for api GetDataSourceMeta
type GetDataSourceMetaResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetDataSourceMetaRequest creates a request to invoke GetDataSourceMeta API
func CreateGetDataSourceMetaRequest() (request *GetDataSourceMetaRequest) {
	request = &GetDataSourceMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetDataSourceMeta", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDataSourceMetaResponse creates a response to parse from GetDataSourceMeta response
func CreateGetDataSourceMetaResponse() (response *GetDataSourceMetaResponse) {
	response = &GetDataSourceMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
