package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIdpConfigs invokes the csas.ListIdpConfigs API synchronously
func (client *Client) ListIdpConfigs(request *ListIdpConfigsRequest) (response *ListIdpConfigsResponse, err error) {
	response = CreateListIdpConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// ListIdpConfigsWithChan invokes the csas.ListIdpConfigs API asynchronously
func (client *Client) ListIdpConfigsWithChan(request *ListIdpConfigsRequest) (<-chan *ListIdpConfigsResponse, <-chan error) {
	responseChan := make(chan *ListIdpConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIdpConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIdpConfigsWithCallback invokes the csas.ListIdpConfigs API asynchronously
func (client *Client) ListIdpConfigsWithCallback(request *ListIdpConfigsRequest, callback func(response *ListIdpConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIdpConfigsResponse
		var err error
		defer close(result)
		response, err = client.ListIdpConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIdpConfigsRequest is the request struct for api ListIdpConfigs
type ListIdpConfigsRequest struct {
	*requests.RpcRequest
	Include     string           `position:"Query" name:"Include"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListIdpConfigsResponse is the response struct for api ListIdpConfigs
type ListIdpConfigsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListIdpConfigsRequest creates a request to invoke ListIdpConfigs API
func CreateListIdpConfigsRequest() (request *ListIdpConfigsRequest) {
	request = &ListIdpConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListIdpConfigs", "", "")
	request.Method = requests.GET
	return
}

// CreateListIdpConfigsResponse creates a response to parse from ListIdpConfigs response
func CreateListIdpConfigsResponse() (response *ListIdpConfigsResponse) {
	response = &ListIdpConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
