package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWmEmbedTask invokes the csas.GetWmEmbedTask API synchronously
func (client *Client) GetWmEmbedTask(request *GetWmEmbedTaskRequest) (response *GetWmEmbedTaskResponse, err error) {
	response = CreateGetWmEmbedTaskResponse()
	err = client.DoAction(request, response)
	return
}

// GetWmEmbedTaskWithChan invokes the csas.GetWmEmbedTask API asynchronously
func (client *Client) GetWmEmbedTaskWithChan(request *GetWmEmbedTaskRequest) (<-chan *GetWmEmbedTaskResponse, <-chan error) {
	responseChan := make(chan *GetWmEmbedTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWmEmbedTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWmEmbedTaskWithCallback invokes the csas.GetWmEmbedTask API asynchronously
func (client *Client) GetWmEmbedTaskWithCallback(request *GetWmEmbedTaskRequest, callback func(response *GetWmEmbedTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWmEmbedTaskResponse
		var err error
		defer close(result)
		response, err = client.GetWmEmbedTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWmEmbedTaskRequest is the request struct for api GetWmEmbedTask
type GetWmEmbedTaskRequest struct {
	*requests.RpcRequest
	ApiType  string `position:"Query" name:"ApiType"`
	SourceIp string `position:"Query" name:"SourceIp"`
	TaskId   string `position:"Query" name:"TaskId"`
}

// GetWmEmbedTaskResponse is the response struct for api GetWmEmbedTask
type GetWmEmbedTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetWmEmbedTaskRequest creates a request to invoke GetWmEmbedTask API
func CreateGetWmEmbedTaskRequest() (request *GetWmEmbedTaskRequest) {
	request = &GetWmEmbedTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetWmEmbedTask", "", "")
	request.Method = requests.GET
	return
}

// CreateGetWmEmbedTaskResponse creates a response to parse from GetWmEmbedTask response
func CreateGetWmEmbedTaskResponse() (response *GetWmEmbedTaskResponse) {
	response = &GetWmEmbedTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
