package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRealTimeLogDelivery invokes the cdn.CreateRealTimeLogDelivery API synchronously
func (client *Client) CreateRealTimeLogDelivery(request *CreateRealTimeLogDeliveryRequest) (response *CreateRealTimeLogDeliveryResponse, err error) {
	response = CreateCreateRealTimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRealTimeLogDeliveryWithChan invokes the cdn.CreateRealTimeLogDelivery API asynchronously
func (client *Client) CreateRealTimeLogDeliveryWithChan(request *CreateRealTimeLogDeliveryRequest) (<-chan *CreateRealTimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *CreateRealTimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRealTimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRealTimeLogDeliveryWithCallback invokes the cdn.CreateRealTimeLogDelivery API asynchronously
func (client *Client) CreateRealTimeLogDeliveryWithCallback(request *CreateRealTimeLogDeliveryRequest, callback func(response *CreateRealTimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRealTimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.CreateRealTimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRealTimeLogDeliveryRequest is the request struct for api CreateRealTimeLogDelivery
type CreateRealTimeLogDeliveryRequest struct {
	*requests.RpcRequest
	Domain   string `position:"Query" name:"Domain"`
	Project  string `position:"Query" name:"Project"`
	Region   string `position:"Query" name:"Region"`
	Logstore string `position:"Query" name:"Logstore"`
}

// CreateRealTimeLogDeliveryResponse is the response struct for api CreateRealTimeLogDelivery
type CreateRealTimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateRealTimeLogDeliveryRequest creates a request to invoke CreateRealTimeLogDelivery API
func CreateCreateRealTimeLogDeliveryRequest() (request *CreateRealTimeLogDeliveryRequest) {
	request = &CreateRealTimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "CreateRealTimeLogDelivery", "", "")
	request.Method = requests.GET
	return
}

// CreateCreateRealTimeLogDeliveryResponse creates a response to parse from CreateRealTimeLogDelivery response
func CreateCreateRealTimeLogDeliveryResponse() (response *CreateRealTimeLogDeliveryResponse) {
	response = &CreateRealTimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
