// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package veiapi

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListDeviceCommon = "ListDevice"

// ListDeviceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDeviceCommon operation. The "output" return
// value will be populated with the ListDeviceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDeviceCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDeviceCommon Send returns without error.
//
// See ListDeviceCommon for more information on using the ListDeviceCommon
// API call, and error handling.
//
//    // Example sending a request using the ListDeviceCommonRequest method.
//    req, resp := client.ListDeviceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEIAPI) ListDeviceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListDeviceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDeviceCommon API operation for VEI_API.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEI_API's
// API operation ListDeviceCommon for usage and error information.
func (c *VEIAPI) ListDeviceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListDeviceCommonRequest(input)
	return out, req.Send()
}

// ListDeviceCommonWithContext is the same as ListDeviceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEIAPI) ListDeviceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListDeviceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDevice = "ListDevice"

// ListDeviceRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDevice operation. The "output" return
// value will be populated with the ListDeviceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDeviceCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDeviceCommon Send returns without error.
//
// See ListDevice for more information on using the ListDevice
// API call, and error handling.
//
//    // Example sending a request using the ListDeviceRequest method.
//    req, resp := client.ListDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEIAPI) ListDeviceRequest(input *ListDeviceInput) (req *request.Request, output *ListDeviceOutput) {
	op := &request.Operation{
		Name:       opListDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDeviceInput{}
	}

	output = &ListDeviceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDevice API operation for VEI_API.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEI_API's
// API operation ListDevice for usage and error information.
func (c *VEIAPI) ListDevice(input *ListDeviceInput) (*ListDeviceOutput, error) {
	req, out := c.ListDeviceRequest(input)
	return out, req.Send()
}

// ListDeviceWithContext is the same as ListDevice with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEIAPI) ListDeviceWithContext(ctx volcengine.Context, input *ListDeviceInput, opts ...request.Option) (*ListDeviceOutput, error) {
	req, out := c.ListDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ItemForListDeviceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:"description,omitempty"`

	Device_id *string `type:"string" json:"device_id,omitempty"`

	Device_name *string `type:"string" json:"device_name,omitempty"`

	Driver_template_alias *string `type:"string" json:"driver_template_alias,omitempty"`

	Driver_template_name *string `type:"string" json:"driver_template_name,omitempty"`

	Node_alias *string `type:"string" json:"node_alias,omitempty"`

	Node_name *string `type:"string" json:"node_name,omitempty"`

	Profile_category *int32 `type:"int32" json:"profile_category,omitempty"`

	Profile_id *string `type:"string" json:"profile_id,omitempty"`

	Profile_name *string `type:"string" json:"profile_name,omitempty"`

	Project_id *string `type:"string" json:"project_id,omitempty"`

	Project_name *string `type:"string" json:"project_name,omitempty"`

	Status *int32 `type:"int32" json:"status,omitempty"`
}

// String returns the string representation
func (s ItemForListDeviceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListDeviceOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ItemForListDeviceOutput) SetDescription(v string) *ItemForListDeviceOutput {
	s.Description = &v
	return s
}

// SetDevice_id sets the Device_id field's value.
func (s *ItemForListDeviceOutput) SetDevice_id(v string) *ItemForListDeviceOutput {
	s.Device_id = &v
	return s
}

// SetDevice_name sets the Device_name field's value.
func (s *ItemForListDeviceOutput) SetDevice_name(v string) *ItemForListDeviceOutput {
	s.Device_name = &v
	return s
}

// SetDriver_template_alias sets the Driver_template_alias field's value.
func (s *ItemForListDeviceOutput) SetDriver_template_alias(v string) *ItemForListDeviceOutput {
	s.Driver_template_alias = &v
	return s
}

// SetDriver_template_name sets the Driver_template_name field's value.
func (s *ItemForListDeviceOutput) SetDriver_template_name(v string) *ItemForListDeviceOutput {
	s.Driver_template_name = &v
	return s
}

// SetNode_alias sets the Node_alias field's value.
func (s *ItemForListDeviceOutput) SetNode_alias(v string) *ItemForListDeviceOutput {
	s.Node_alias = &v
	return s
}

// SetNode_name sets the Node_name field's value.
func (s *ItemForListDeviceOutput) SetNode_name(v string) *ItemForListDeviceOutput {
	s.Node_name = &v
	return s
}

// SetProfile_category sets the Profile_category field's value.
func (s *ItemForListDeviceOutput) SetProfile_category(v int32) *ItemForListDeviceOutput {
	s.Profile_category = &v
	return s
}

// SetProfile_id sets the Profile_id field's value.
func (s *ItemForListDeviceOutput) SetProfile_id(v string) *ItemForListDeviceOutput {
	s.Profile_id = &v
	return s
}

// SetProfile_name sets the Profile_name field's value.
func (s *ItemForListDeviceOutput) SetProfile_name(v string) *ItemForListDeviceOutput {
	s.Profile_name = &v
	return s
}

// SetProject_id sets the Project_id field's value.
func (s *ItemForListDeviceOutput) SetProject_id(v string) *ItemForListDeviceOutput {
	s.Project_id = &v
	return s
}

// SetProject_name sets the Project_name field's value.
func (s *ItemForListDeviceOutput) SetProject_name(v string) *ItemForListDeviceOutput {
	s.Project_name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListDeviceOutput) SetStatus(v int32) *ItemForListDeviceOutput {
	s.Status = &v
	return s
}

type ListDeviceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Created_orderby *int32 `type:"int32" json:"created_orderby,omitempty"`

	Driver_template_name []*string `type:"list" json:"driver_template_name,omitempty"`

	Node_name []*string `type:"list" json:"node_name,omitempty"`

	// Page_index is a required field
	Page_index *int32 `type:"int32" json:"page_index,omitempty" required:"true"`

	// Page_size is a required field
	Page_size *int32 `type:"int32" json:"page_size,omitempty" required:"true"`

	Profile_category []*string `type:"list" json:"profile_category,omitempty"`

	Project_id []*string `type:"list" json:"project_id,omitempty"`

	Status []*int32 `type:"list" json:"status,omitempty"`

	Tags []*TagForListDeviceInput `type:"list" json:"tags,omitempty"`

	Updated_orderby *int32 `type:"int32" json:"updated_orderby,omitempty"`

	Vague_device_name *string `type:"string" json:"vague_device_name,omitempty"`
}

// String returns the string representation
func (s ListDeviceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeviceInput"}
	if s.Page_index == nil {
		invalidParams.Add(request.NewErrParamRequired("Page_index"))
	}
	if s.Page_size == nil {
		invalidParams.Add(request.NewErrParamRequired("Page_size"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreated_orderby sets the Created_orderby field's value.
func (s *ListDeviceInput) SetCreated_orderby(v int32) *ListDeviceInput {
	s.Created_orderby = &v
	return s
}

// SetDriver_template_name sets the Driver_template_name field's value.
func (s *ListDeviceInput) SetDriver_template_name(v []*string) *ListDeviceInput {
	s.Driver_template_name = v
	return s
}

// SetNode_name sets the Node_name field's value.
func (s *ListDeviceInput) SetNode_name(v []*string) *ListDeviceInput {
	s.Node_name = v
	return s
}

// SetPage_index sets the Page_index field's value.
func (s *ListDeviceInput) SetPage_index(v int32) *ListDeviceInput {
	s.Page_index = &v
	return s
}

// SetPage_size sets the Page_size field's value.
func (s *ListDeviceInput) SetPage_size(v int32) *ListDeviceInput {
	s.Page_size = &v
	return s
}

// SetProfile_category sets the Profile_category field's value.
func (s *ListDeviceInput) SetProfile_category(v []*string) *ListDeviceInput {
	s.Profile_category = v
	return s
}

// SetProject_id sets the Project_id field's value.
func (s *ListDeviceInput) SetProject_id(v []*string) *ListDeviceInput {
	s.Project_id = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListDeviceInput) SetStatus(v []*int32) *ListDeviceInput {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListDeviceInput) SetTags(v []*TagForListDeviceInput) *ListDeviceInput {
	s.Tags = v
	return s
}

// SetUpdated_orderby sets the Updated_orderby field's value.
func (s *ListDeviceInput) SetUpdated_orderby(v int32) *ListDeviceInput {
	s.Updated_orderby = &v
	return s
}

// SetVague_device_name sets the Vague_device_name field's value.
func (s *ListDeviceInput) SetVague_device_name(v string) *ListDeviceInput {
	s.Vague_device_name = &v
	return s
}

type ListDeviceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListDeviceOutput `type:"list" json:"items,omitempty"`

	Overview *OverviewForListDeviceOutput `type:"structure" json:"overview,omitempty"`

	Pageinator *PageinatorForListDeviceOutput `type:"structure" json:"pageinator,omitempty"`
}

// String returns the string representation
func (s ListDeviceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListDeviceOutput) SetItems(v []*ItemForListDeviceOutput) *ListDeviceOutput {
	s.Items = v
	return s
}

// SetOverview sets the Overview field's value.
func (s *ListDeviceOutput) SetOverview(v *OverviewForListDeviceOutput) *ListDeviceOutput {
	s.Overview = v
	return s
}

// SetPageinator sets the Pageinator field's value.
func (s *ListDeviceOutput) SetPageinator(v *PageinatorForListDeviceOutput) *ListDeviceOutput {
	s.Pageinator = v
	return s
}

type OverviewForListDeviceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Activated *int32 `type:"int32" json:"activated,omitempty"`

	Offline *int32 `type:"int32" json:"offline,omitempty"`

	Online *int32 `type:"int32" json:"online,omitempty"`

	Total *int32 `type:"int32" json:"total,omitempty"`

	Unactivated *int32 `type:"int32" json:"unactivated,omitempty"`
}

// String returns the string representation
func (s OverviewForListDeviceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OverviewForListDeviceOutput) GoString() string {
	return s.String()
}

// SetActivated sets the Activated field's value.
func (s *OverviewForListDeviceOutput) SetActivated(v int32) *OverviewForListDeviceOutput {
	s.Activated = &v
	return s
}

// SetOffline sets the Offline field's value.
func (s *OverviewForListDeviceOutput) SetOffline(v int32) *OverviewForListDeviceOutput {
	s.Offline = &v
	return s
}

// SetOnline sets the Online field's value.
func (s *OverviewForListDeviceOutput) SetOnline(v int32) *OverviewForListDeviceOutput {
	s.Online = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *OverviewForListDeviceOutput) SetTotal(v int32) *OverviewForListDeviceOutput {
	s.Total = &v
	return s
}

// SetUnactivated sets the Unactivated field's value.
func (s *OverviewForListDeviceOutput) SetUnactivated(v int32) *OverviewForListDeviceOutput {
	s.Unactivated = &v
	return s
}

type PageinatorForListDeviceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Index *int32 `type:"int32" json:"index,omitempty"`

	Size *int32 `type:"int32" json:"size,omitempty"`

	Total_items *int32 `type:"int32" json:"total_items,omitempty"`

	Total_pages *int32 `type:"int32" json:"total_pages,omitempty"`
}

// String returns the string representation
func (s PageinatorForListDeviceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageinatorForListDeviceOutput) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *PageinatorForListDeviceOutput) SetIndex(v int32) *PageinatorForListDeviceOutput {
	s.Index = &v
	return s
}

// SetSize sets the Size field's value.
func (s *PageinatorForListDeviceOutput) SetSize(v int32) *PageinatorForListDeviceOutput {
	s.Size = &v
	return s
}

// SetTotal_items sets the Total_items field's value.
func (s *PageinatorForListDeviceOutput) SetTotal_items(v int32) *PageinatorForListDeviceOutput {
	s.Total_items = &v
	return s
}

// SetTotal_pages sets the Total_pages field's value.
func (s *PageinatorForListDeviceOutput) SetTotal_pages(v int32) *PageinatorForListDeviceOutput {
	s.Total_pages = &v
	return s
}

type TagForListDeviceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:"key,omitempty"`

	Tag_id *string `type:"string" json:"tag_id,omitempty"`

	Value *string `type:"string" json:"value,omitempty"`
}

// String returns the string representation
func (s TagForListDeviceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForListDeviceInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForListDeviceInput) SetKey(v string) *TagForListDeviceInput {
	s.Key = &v
	return s
}

// SetTag_id sets the Tag_id field's value.
func (s *TagForListDeviceInput) SetTag_id(v string) *TagForListDeviceInput {
	s.Tag_id = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForListDeviceInput) SetValue(v string) *TagForListDeviceInput {
	s.Value = &v
	return s
}
