// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package sqs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opReceiveMessageCommon = "ReceiveMessage"

// ReceiveMessageCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ReceiveMessageCommon operation. The "output" return
// value will be populated with the ReceiveMessageCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ReceiveMessageCommon Request to send the API call to the service.
// the "output" return value is not valid until after ReceiveMessageCommon Send returns without error.
//
// See ReceiveMessageCommon for more information on using the ReceiveMessageCommon
// API call, and error handling.
//
//    // Example sending a request using the ReceiveMessageCommonRequest method.
//    req, resp := client.ReceiveMessageCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SQS) ReceiveMessageCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opReceiveMessageCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ReceiveMessageCommon API operation for SQS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SQS's
// API operation ReceiveMessageCommon for usage and error information.
func (c *SQS) ReceiveMessageCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ReceiveMessageCommonRequest(input)
	return out, req.Send()
}

// ReceiveMessageCommonWithContext is the same as ReceiveMessageCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ReceiveMessageCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SQS) ReceiveMessageCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ReceiveMessageCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReceiveMessage = "ReceiveMessage"

// ReceiveMessageRequest generates a "volcengine/request.Request" representing the
// client's request for the ReceiveMessage operation. The "output" return
// value will be populated with the ReceiveMessageCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ReceiveMessageCommon Request to send the API call to the service.
// the "output" return value is not valid until after ReceiveMessageCommon Send returns without error.
//
// See ReceiveMessage for more information on using the ReceiveMessage
// API call, and error handling.
//
//    // Example sending a request using the ReceiveMessageRequest method.
//    req, resp := client.ReceiveMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SQS) ReceiveMessageRequest(input *ReceiveMessageInput) (req *request.Request, output *ReceiveMessageOutput) {
	op := &request.Operation{
		Name:       opReceiveMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReceiveMessageInput{}
	}

	output = &ReceiveMessageOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ReceiveMessage API operation for SQS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SQS's
// API operation ReceiveMessage for usage and error information.
func (c *SQS) ReceiveMessage(input *ReceiveMessageInput) (*ReceiveMessageOutput, error) {
	req, out := c.ReceiveMessageRequest(input)
	return out, req.Send()
}

// ReceiveMessageWithContext is the same as ReceiveMessage with the addition of
// the ability to pass a context and additional request options.
//
// See ReceiveMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SQS) ReceiveMessageWithContext(ctx volcengine.Context, input *ReceiveMessageInput, opts ...request.Option) (*ReceiveMessageOutput, error) {
	req, out := c.ReceiveMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type MessageForReceiveMessageOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MessageBody *string `type:"string" json:",omitempty"`

	MessageId *string `type:"string" json:",omitempty"`

	ReceiptHandle *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MessageForReceiveMessageOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageForReceiveMessageOutput) GoString() string {
	return s.String()
}

// SetMessageBody sets the MessageBody field's value.
func (s *MessageForReceiveMessageOutput) SetMessageBody(v string) *MessageForReceiveMessageOutput {
	s.MessageBody = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *MessageForReceiveMessageOutput) SetMessageId(v string) *MessageForReceiveMessageOutput {
	s.MessageId = &v
	return s
}

// SetReceiptHandle sets the ReceiptHandle field's value.
func (s *MessageForReceiveMessageOutput) SetReceiptHandle(v string) *MessageForReceiveMessageOutput {
	s.ReceiptHandle = &v
	return s
}

type ReceiveMessageInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MaxNumberOfMessages *int32 `min:"1" max:"10" type:"int32" json:",omitempty"`

	// QueueTrn is a required field
	QueueTrn *string `type:"string" json:",omitempty" required:"true"`

	WaitTimeSeconds *int32 `max:"20" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ReceiveMessageInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiveMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiveMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReceiveMessageInput"}
	if s.MaxNumberOfMessages != nil && *s.MaxNumberOfMessages < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxNumberOfMessages", 1))
	}
	if s.MaxNumberOfMessages != nil && *s.MaxNumberOfMessages > 10 {
		invalidParams.Add(request.NewErrParamMaxValue("MaxNumberOfMessages", 10))
	}
	if s.QueueTrn == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueTrn"))
	}
	if s.WaitTimeSeconds != nil && *s.WaitTimeSeconds > 20 {
		invalidParams.Add(request.NewErrParamMaxValue("WaitTimeSeconds", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxNumberOfMessages sets the MaxNumberOfMessages field's value.
func (s *ReceiveMessageInput) SetMaxNumberOfMessages(v int32) *ReceiveMessageInput {
	s.MaxNumberOfMessages = &v
	return s
}

// SetQueueTrn sets the QueueTrn field's value.
func (s *ReceiveMessageInput) SetQueueTrn(v string) *ReceiveMessageInput {
	s.QueueTrn = &v
	return s
}

// SetWaitTimeSeconds sets the WaitTimeSeconds field's value.
func (s *ReceiveMessageInput) SetWaitTimeSeconds(v int32) *ReceiveMessageInput {
	s.WaitTimeSeconds = &v
	return s
}

type ReceiveMessageOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Messages []*MessageForReceiveMessageOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ReceiveMessageOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiveMessageOutput) GoString() string {
	return s.String()
}

// SetMessages sets the Messages field's value.
func (s *ReceiveMessageOutput) SetMessages(v []*MessageForReceiveMessageOutput) *ReceiveMessageOutput {
	s.Messages = v
	return s
}
