// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package organization

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opInviteAccountCommon = "InviteAccount"

// InviteAccountCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the InviteAccountCommon operation. The "output" return
// value will be populated with the InviteAccountCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned InviteAccountCommon Request to send the API call to the service.
// the "output" return value is not valid until after InviteAccountCommon Send returns without error.
//
// See InviteAccountCommon for more information on using the InviteAccountCommon
// API call, and error handling.
//
//    // Example sending a request using the InviteAccountCommonRequest method.
//    req, resp := client.InviteAccountCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ORGANIZATION) InviteAccountCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opInviteAccountCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// InviteAccountCommon API operation for ORGANIZATION.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ORGANIZATION's
// API operation InviteAccountCommon for usage and error information.
func (c *ORGANIZATION) InviteAccountCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.InviteAccountCommonRequest(input)
	return out, req.Send()
}

// InviteAccountCommonWithContext is the same as InviteAccountCommon with the addition of
// the ability to pass a context and additional request options.
//
// See InviteAccountCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ORGANIZATION) InviteAccountCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.InviteAccountCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteAccount = "InviteAccount"

// InviteAccountRequest generates a "volcengine/request.Request" representing the
// client's request for the InviteAccount operation. The "output" return
// value will be populated with the InviteAccountCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned InviteAccountCommon Request to send the API call to the service.
// the "output" return value is not valid until after InviteAccountCommon Send returns without error.
//
// See InviteAccount for more information on using the InviteAccount
// API call, and error handling.
//
//    // Example sending a request using the InviteAccountRequest method.
//    req, resp := client.InviteAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ORGANIZATION) InviteAccountRequest(input *InviteAccountInput) (req *request.Request, output *InviteAccountOutput) {
	op := &request.Operation{
		Name:       opInviteAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InviteAccountInput{}
	}

	output = &InviteAccountOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// InviteAccount API operation for ORGANIZATION.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ORGANIZATION's
// API operation InviteAccount for usage and error information.
func (c *ORGANIZATION) InviteAccount(input *InviteAccountInput) (*InviteAccountOutput, error) {
	req, out := c.InviteAccountRequest(input)
	return out, req.Send()
}

// InviteAccountWithContext is the same as InviteAccount with the addition of
// the ability to pass a context and additional request options.
//
// See InviteAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ORGANIZATION) InviteAccountWithContext(ctx volcengine.Context, input *InviteAccountInput, opts ...request.Option) (*InviteAccountOutput, error) {
	req, out := c.InviteAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type InviteAccountInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// AccountId is a required field
	AccountId *string `type:"string" json:",omitempty" required:"true"`

	// AllowExit is a required field
	AllowExit *int32 `type:"int32" json:",omitempty" required:"true"`

	Description *string `type:"string" json:",omitempty"`

	OrgUnitId *string `type:"string" json:",omitempty"`

	// ShowName is a required field
	ShowName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s InviteAccountInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InviteAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InviteAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AllowExit == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowExit"))
	}
	if s.ShowName == nil {
		invalidParams.Add(request.NewErrParamRequired("ShowName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *InviteAccountInput) SetAccountId(v string) *InviteAccountInput {
	s.AccountId = &v
	return s
}

// SetAllowExit sets the AllowExit field's value.
func (s *InviteAccountInput) SetAllowExit(v int32) *InviteAccountInput {
	s.AllowExit = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *InviteAccountInput) SetDescription(v string) *InviteAccountInput {
	s.Description = &v
	return s
}

// SetOrgUnitId sets the OrgUnitId field's value.
func (s *InviteAccountInput) SetOrgUnitId(v string) *InviteAccountInput {
	s.OrgUnitId = &v
	return s
}

// SetShowName sets the ShowName field's value.
func (s *InviteAccountInput) SetShowName(v string) *InviteAccountInput {
	s.ShowName = &v
	return s
}

type InviteAccountOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InviteId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InviteAccountOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteAccountOutput) GoString() string {
	return s.String()
}

// SetInviteId sets the InviteId field's value.
func (s *InviteAccountOutput) SetInviteId(v string) *InviteAccountOutput {
	s.InviteId = &v
	return s
}
