// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDeploymentCommon = "CreateDeployment"

// CreateDeploymentCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDeploymentCommon operation. The "output" return
// value will be populated with the CreateDeploymentCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDeploymentCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDeploymentCommon Send returns without error.
//
// See CreateDeploymentCommon for more information on using the CreateDeploymentCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDeploymentCommonRequest method.
//    req, resp := client.CreateDeploymentCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) CreateDeploymentCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDeploymentCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDeploymentCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation CreateDeploymentCommon for usage and error information.
func (c *MLPLATFORM20240701) CreateDeploymentCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDeploymentCommonRequest(input)
	return out, req.Send()
}

// CreateDeploymentCommonWithContext is the same as CreateDeploymentCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeploymentCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) CreateDeploymentCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDeploymentCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDeployment operation. The "output" return
// value will be populated with the CreateDeploymentCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDeploymentCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDeploymentCommon Send returns without error.
//
// See CreateDeployment for more information on using the CreateDeployment
// API call, and error handling.
//
//    // Example sending a request using the CreateDeploymentRequest method.
//    req, resp := client.CreateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	output = &CreateDeploymentOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDeployment API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation CreateDeployment for usage and error information.
func (c *MLPLATFORM20240701) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	return out, req.Send()
}

// CreateDeploymentWithContext is the same as CreateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) CreateDeploymentWithContext(ctx volcengine.Context, input *CreateDeploymentInput, opts ...request.Option) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ApigConfigForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InstanceID *string `type:"string" json:",omitempty"`

	UpstreamConfig *UpstreamConfigForCreateDeploymentInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ApigConfigForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ApigConfigForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetInstanceID sets the InstanceID field's value.
func (s *ApigConfigForCreateDeploymentInput) SetInstanceID(v string) *ApigConfigForCreateDeploymentInput {
	s.InstanceID = &v
	return s
}

// SetUpstreamConfig sets the UpstreamConfig field's value.
func (s *ApigConfigForCreateDeploymentInput) SetUpstreamConfig(v *UpstreamConfigForCreateDeploymentInput) *ApigConfigForCreateDeploymentInput {
	s.UpstreamConfig = v
	return s
}

type CLBConfigForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InstanceId *string `type:"string" json:",omitempty"`

	Scheduler *string `type:"string" json:",omitempty" enum:"EnumOfSchedulerForCreateDeploymentInput"`
}

// String returns the string representation
func (s CLBConfigForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CLBConfigForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *CLBConfigForCreateDeploymentInput) SetInstanceId(v string) *CLBConfigForCreateDeploymentInput {
	s.InstanceId = &v
	return s
}

// SetScheduler sets the Scheduler field's value.
func (s *CLBConfigForCreateDeploymentInput) SetScheduler(v string) *CLBConfigForCreateDeploymentInput {
	s.Scheduler = &v
	return s
}

type CfsForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	NamespaceId *string `type:"string" json:",omitempty"`

	Options *OptionsForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Tos *TosForCreateDeploymentInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CfsForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CfsForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *CfsForCreateDeploymentInput) SetFileSystemName(v string) *CfsForCreateDeploymentInput {
	s.FileSystemName = &v
	return s
}

// SetNamespaceId sets the NamespaceId field's value.
func (s *CfsForCreateDeploymentInput) SetNamespaceId(v string) *CfsForCreateDeploymentInput {
	s.NamespaceId = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *CfsForCreateDeploymentInput) SetOptions(v *OptionsForCreateDeploymentInput) *CfsForCreateDeploymentInput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *CfsForCreateDeploymentInput) SetTos(v *TosForCreateDeploymentInput) *CfsForCreateDeploymentInput {
	s.Tos = v
	return s
}

type ConfigForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cfs *CfsForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Nas *NasForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Sfcs *SfcsForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Tos *TosForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Vepfs *VepfsForCreateDeploymentInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ConfigForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetCfs sets the Cfs field's value.
func (s *ConfigForCreateDeploymentInput) SetCfs(v *CfsForCreateDeploymentInput) *ConfigForCreateDeploymentInput {
	s.Cfs = v
	return s
}

// SetNas sets the Nas field's value.
func (s *ConfigForCreateDeploymentInput) SetNas(v *NasForCreateDeploymentInput) *ConfigForCreateDeploymentInput {
	s.Nas = v
	return s
}

// SetSfcs sets the Sfcs field's value.
func (s *ConfigForCreateDeploymentInput) SetSfcs(v *SfcsForCreateDeploymentInput) *ConfigForCreateDeploymentInput {
	s.Sfcs = v
	return s
}

// SetTos sets the Tos field's value.
func (s *ConfigForCreateDeploymentInput) SetTos(v *TosForCreateDeploymentInput) *ConfigForCreateDeploymentInput {
	s.Tos = v
	return s
}

// SetVepfs sets the Vepfs field's value.
func (s *ConfigForCreateDeploymentInput) SetVepfs(v *VepfsForCreateDeploymentInput) *ConfigForCreateDeploymentInput {
	s.Vepfs = v
	return s
}

type ConsistentHashConfigForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HashKeyType *string `type:"string" json:",omitempty" enum:"EnumOfHashKeyTypeForCreateDeploymentInput"`

	HttpHeaderName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConsistentHashConfigForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConsistentHashConfigForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetHashKeyType sets the HashKeyType field's value.
func (s *ConsistentHashConfigForCreateDeploymentInput) SetHashKeyType(v string) *ConsistentHashConfigForCreateDeploymentInput {
	s.HashKeyType = &v
	return s
}

// SetHttpHeaderName sets the HttpHeaderName field's value.
func (s *ConsistentHashConfigForCreateDeploymentInput) SetHttpHeaderName(v string) *ConsistentHashConfigForCreateDeploymentInput {
	s.HttpHeaderName = &v
	return s
}

type ConvertCredentialForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RegistryToken *string `type:"string" json:",omitempty"`

	RegistryUsername *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertCredentialForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertCredentialForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetRegistryToken sets the RegistryToken field's value.
func (s *ConvertCredentialForCreateDeploymentInput) SetRegistryToken(v string) *ConvertCredentialForCreateDeploymentInput {
	s.RegistryToken = &v
	return s
}

// SetRegistryUsername sets the RegistryUsername field's value.
func (s *ConvertCredentialForCreateDeploymentInput) SetRegistryUsername(v string) *ConvertCredentialForCreateDeploymentInput {
	s.RegistryUsername = &v
	return s
}

type ConvertOptionsForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ConvertOptionsForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOptionsForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *ConvertOptionsForCreateDeploymentInput) SetInternalSync(v int64) *ConvertOptionsForCreateDeploymentInput {
	s.InternalSync = &v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *ConvertOptionsForCreateDeploymentInput) SetReplicas(v int64) *ConvertOptionsForCreateDeploymentInput {
	s.Replicas = &v
	return s
}

type CreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AcceptServiceTraffic *bool `type:"boolean" json:",omitempty"`

	ApigConfig *ApigConfigForCreateDeploymentInput `type:"structure" json:",omitempty"`

	CLBConfig *CLBConfigForCreateDeploymentInput `type:"structure" json:",omitempty"`

	// DeploymentName is a required field
	DeploymentName *string `type:"string" json:",omitempty" required:"true"`

	Description *string `type:"string" json:",omitempty"`

	DryRun *bool `type:"boolean" json:",omitempty"`

	Priority *int32 `type:"int32" json:",omitempty"`

	// ResourceQueueId is a required field
	ResourceQueueId *string `type:"string" json:",omitempty" required:"true"`

	Roles []*RoleForCreateDeploymentInput `type:"list" json:",omitempty"`

	// ServiceId is a required field
	ServiceId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentInput"}
	if s.DeploymentName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentName"))
	}
	if s.ResourceQueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceQueueId"))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptServiceTraffic sets the AcceptServiceTraffic field's value.
func (s *CreateDeploymentInput) SetAcceptServiceTraffic(v bool) *CreateDeploymentInput {
	s.AcceptServiceTraffic = &v
	return s
}

// SetApigConfig sets the ApigConfig field's value.
func (s *CreateDeploymentInput) SetApigConfig(v *ApigConfigForCreateDeploymentInput) *CreateDeploymentInput {
	s.ApigConfig = v
	return s
}

// SetCLBConfig sets the CLBConfig field's value.
func (s *CreateDeploymentInput) SetCLBConfig(v *CLBConfigForCreateDeploymentInput) *CreateDeploymentInput {
	s.CLBConfig = v
	return s
}

// SetDeploymentName sets the DeploymentName field's value.
func (s *CreateDeploymentInput) SetDeploymentName(v string) *CreateDeploymentInput {
	s.DeploymentName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDeploymentInput) SetDescription(v string) *CreateDeploymentInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateDeploymentInput) SetDryRun(v bool) *CreateDeploymentInput {
	s.DryRun = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateDeploymentInput) SetPriority(v int32) *CreateDeploymentInput {
	s.Priority = &v
	return s
}

// SetResourceQueueId sets the ResourceQueueId field's value.
func (s *CreateDeploymentInput) SetResourceQueueId(v string) *CreateDeploymentInput {
	s.ResourceQueueId = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *CreateDeploymentInput) SetRoles(v []*RoleForCreateDeploymentInput) *CreateDeploymentInput {
	s.Roles = v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *CreateDeploymentInput) SetServiceId(v string) *CreateDeploymentInput {
	s.ServiceId = &v
	return s
}

type CreateDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	DeploymentId *string `type:"string" json:",omitempty"`

	DeploymentVersionId *string `type:"string" json:",omitempty"`

	ServiceId *string `type:"string" json:",omitempty"`

	Status *StatusForCreateDeploymentOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateDeploymentOutput) SetDeploymentId(v string) *CreateDeploymentOutput {
	s.DeploymentId = &v
	return s
}

// SetDeploymentVersionId sets the DeploymentVersionId field's value.
func (s *CreateDeploymentOutput) SetDeploymentVersionId(v string) *CreateDeploymentOutput {
	s.DeploymentVersionId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *CreateDeploymentOutput) SetServiceId(v string) *CreateDeploymentOutput {
	s.ServiceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDeploymentOutput) SetStatus(v *StatusForCreateDeploymentOutput) *CreateDeploymentOutput {
	s.Status = v
	return s
}

type CredentialForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `type:"string" json:",omitempty"`

	SecretAccessKey *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CredentialForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CredentialForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *CredentialForCreateDeploymentInput) SetAccessKey(v string) *CredentialForCreateDeploymentInput {
	s.AccessKey = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *CredentialForCreateDeploymentInput) SetSecretAccessKey(v string) *CredentialForCreateDeploymentInput {
	s.SecretAccessKey = &v
	return s
}

type EnvForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s EnvForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EnvForCreateDeploymentInput) SetName(v string) *EnvForCreateDeploymentInput {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvForCreateDeploymentInput) SetValue(v string) *EnvForCreateDeploymentInput {
	s.Value = &v
	return s
}

type ExecForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Command *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ExecForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *ExecForCreateDeploymentInput) SetCommand(v string) *ExecForCreateDeploymentInput {
	s.Command = &v
	return s
}

type FlexibleResourceClaimForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	Family *string `type:"string" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	RdmaEniCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s FlexibleResourceClaimForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FlexibleResourceClaimForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *FlexibleResourceClaimForCreateDeploymentInput) SetCpu(v float64) *FlexibleResourceClaimForCreateDeploymentInput {
	s.Cpu = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *FlexibleResourceClaimForCreateDeploymentInput) SetFamily(v string) *FlexibleResourceClaimForCreateDeploymentInput {
	s.Family = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *FlexibleResourceClaimForCreateDeploymentInput) SetGpuCount(v float64) *FlexibleResourceClaimForCreateDeploymentInput {
	s.GpuCount = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *FlexibleResourceClaimForCreateDeploymentInput) SetGpuType(v string) *FlexibleResourceClaimForCreateDeploymentInput {
	s.GpuType = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *FlexibleResourceClaimForCreateDeploymentInput) SetMemoryGiB(v float64) *FlexibleResourceClaimForCreateDeploymentInput {
	s.MemoryGiB = &v
	return s
}

// SetRdmaEniCount sets the RdmaEniCount field's value.
func (s *FlexibleResourceClaimForCreateDeploymentInput) SetRdmaEniCount(v int32) *FlexibleResourceClaimForCreateDeploymentInput {
	s.RdmaEniCount = &v
	return s
}

type HTTPGetForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HTTPHeaders []*HTTPHeaderForCreateDeploymentInput `type:"list" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Scheme *string `type:"string" json:",omitempty" enum:"EnumOfSchemeForCreateDeploymentInput"`
}

// String returns the string representation
func (s HTTPGetForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPGetForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetHTTPHeaders sets the HTTPHeaders field's value.
func (s *HTTPGetForCreateDeploymentInput) SetHTTPHeaders(v []*HTTPHeaderForCreateDeploymentInput) *HTTPGetForCreateDeploymentInput {
	s.HTTPHeaders = v
	return s
}

// SetPath sets the Path field's value.
func (s *HTTPGetForCreateDeploymentInput) SetPath(v string) *HTTPGetForCreateDeploymentInput {
	s.Path = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HTTPGetForCreateDeploymentInput) SetPort(v int32) *HTTPGetForCreateDeploymentInput {
	s.Port = &v
	return s
}

// SetScheme sets the Scheme field's value.
func (s *HTTPGetForCreateDeploymentInput) SetScheme(v string) *HTTPGetForCreateDeploymentInput {
	s.Scheme = &v
	return s
}

type HTTPHeaderForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HTTPHeaderForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPHeaderForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *HTTPHeaderForCreateDeploymentInput) SetName(v string) *HTTPHeaderForCreateDeploymentInput {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HTTPHeaderForCreateDeploymentInput) SetValue(v string) *HTTPHeaderForCreateDeploymentInput {
	s.Value = &v
	return s
}

type ImageForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Credential *ConvertCredentialForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ImageForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetCredential sets the Credential field's value.
func (s *ImageForCreateDeploymentInput) SetCredential(v *ConvertCredentialForCreateDeploymentInput) *ImageForCreateDeploymentInput {
	s.Credential = v
	return s
}

// SetType sets the Type field's value.
func (s *ImageForCreateDeploymentInput) SetType(v string) *ImageForCreateDeploymentInput {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ImageForCreateDeploymentInput) SetUrl(v string) *ImageForCreateDeploymentInput {
	s.Url = &v
	return s
}

type LivenessProbeForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Exec *ExecForCreateDeploymentInput `type:"structure" json:",omitempty"`

	FailureThreshold *int32 `type:"int32" json:",omitempty"`

	HTTPGet *HTTPGetForCreateDeploymentInput `type:"structure" json:",omitempty"`

	InitialDelaySeconds *int32 `type:"int32" json:",omitempty"`

	PeriodSeconds *int32 `type:"int32" json:",omitempty"`

	SuccessThreshold *int32 `type:"int32" json:",omitempty"`

	TCPSocket *TCPSocketForCreateDeploymentInput `type:"structure" json:",omitempty"`

	TimeoutSeconds *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s LivenessProbeForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LivenessProbeForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *LivenessProbeForCreateDeploymentInput) SetEnabled(v bool) *LivenessProbeForCreateDeploymentInput {
	s.Enabled = &v
	return s
}

// SetExec sets the Exec field's value.
func (s *LivenessProbeForCreateDeploymentInput) SetExec(v *ExecForCreateDeploymentInput) *LivenessProbeForCreateDeploymentInput {
	s.Exec = v
	return s
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *LivenessProbeForCreateDeploymentInput) SetFailureThreshold(v int32) *LivenessProbeForCreateDeploymentInput {
	s.FailureThreshold = &v
	return s
}

// SetHTTPGet sets the HTTPGet field's value.
func (s *LivenessProbeForCreateDeploymentInput) SetHTTPGet(v *HTTPGetForCreateDeploymentInput) *LivenessProbeForCreateDeploymentInput {
	s.HTTPGet = v
	return s
}

// SetInitialDelaySeconds sets the InitialDelaySeconds field's value.
func (s *LivenessProbeForCreateDeploymentInput) SetInitialDelaySeconds(v int32) *LivenessProbeForCreateDeploymentInput {
	s.InitialDelaySeconds = &v
	return s
}

// SetPeriodSeconds sets the PeriodSeconds field's value.
func (s *LivenessProbeForCreateDeploymentInput) SetPeriodSeconds(v int32) *LivenessProbeForCreateDeploymentInput {
	s.PeriodSeconds = &v
	return s
}

// SetSuccessThreshold sets the SuccessThreshold field's value.
func (s *LivenessProbeForCreateDeploymentInput) SetSuccessThreshold(v int32) *LivenessProbeForCreateDeploymentInput {
	s.SuccessThreshold = &v
	return s
}

// SetTCPSocket sets the TCPSocket field's value.
func (s *LivenessProbeForCreateDeploymentInput) SetTCPSocket(v *TCPSocketForCreateDeploymentInput) *LivenessProbeForCreateDeploymentInput {
	s.TCPSocket = v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *LivenessProbeForCreateDeploymentInput) SetTimeoutSeconds(v int32) *LivenessProbeForCreateDeploymentInput {
	s.TimeoutSeconds = &v
	return s
}

type ModelForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ModelID *string `type:"string" json:",omitempty"`

	ModelVersionID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ModelForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetModelID sets the ModelID field's value.
func (s *ModelForCreateDeploymentInput) SetModelID(v string) *ModelForCreateDeploymentInput {
	s.ModelID = &v
	return s
}

// SetModelVersionID sets the ModelVersionID field's value.
func (s *ModelForCreateDeploymentInput) SetModelVersionID(v string) *ModelForCreateDeploymentInput {
	s.ModelVersionID = &v
	return s
}

type NasForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Addr *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	NasType *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NasForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NasForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetAddr sets the Addr field's value.
func (s *NasForCreateDeploymentInput) SetAddr(v string) *NasForCreateDeploymentInput {
	s.Addr = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *NasForCreateDeploymentInput) SetFileSystemName(v string) *NasForCreateDeploymentInput {
	s.FileSystemName = &v
	return s
}

// SetId sets the Id field's value.
func (s *NasForCreateDeploymentInput) SetId(v string) *NasForCreateDeploymentInput {
	s.Id = &v
	return s
}

// SetNasType sets the NasType field's value.
func (s *NasForCreateDeploymentInput) SetNasType(v string) *NasForCreateDeploymentInput {
	s.NasType = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *NasForCreateDeploymentInput) SetSubPath(v string) *NasForCreateDeploymentInput {
	s.SubPath = &v
	return s
}

type NodeAffinitySpecForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GPUCPUNodePreference *string `type:"string" json:",omitempty" enum:"EnumOfGPUCPUNodePreferenceForCreateDeploymentInput"`

	StrategyType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeAffinitySpecForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeAffinitySpecForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetGPUCPUNodePreference sets the GPUCPUNodePreference field's value.
func (s *NodeAffinitySpecForCreateDeploymentInput) SetGPUCPUNodePreference(v string) *NodeAffinitySpecForCreateDeploymentInput {
	s.GPUCPUNodePreference = &v
	return s
}

// SetStrategyType sets the StrategyType field's value.
func (s *NodeAffinitySpecForCreateDeploymentInput) SetStrategyType(v string) *NodeAffinitySpecForCreateDeploymentInput {
	s.StrategyType = &v
	return s
}

type OptionsForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	MetaCacheCapacity *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMinutes *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMsec *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s OptionsForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionsForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *OptionsForCreateDeploymentInput) SetInternalSync(v int64) *OptionsForCreateDeploymentInput {
	s.InternalSync = &v
	return s
}

// SetMetaCacheCapacity sets the MetaCacheCapacity field's value.
func (s *OptionsForCreateDeploymentInput) SetMetaCacheCapacity(v int64) *OptionsForCreateDeploymentInput {
	s.MetaCacheCapacity = &v
	return s
}

// SetMetaCacheExpiryMinutes sets the MetaCacheExpiryMinutes field's value.
func (s *OptionsForCreateDeploymentInput) SetMetaCacheExpiryMinutes(v int64) *OptionsForCreateDeploymentInput {
	s.MetaCacheExpiryMinutes = &v
	return s
}

// SetMetaCacheExpiryMsec sets the MetaCacheExpiryMsec field's value.
func (s *OptionsForCreateDeploymentInput) SetMetaCacheExpiryMsec(v int64) *OptionsForCreateDeploymentInput {
	s.MetaCacheExpiryMsec = &v
	return s
}

type PortForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ExposePort *string `type:"string" json:",omitempty"`

	ListenPort *string `type:"string" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForCreateDeploymentInput"`
}

// String returns the string representation
func (s PortForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PortForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetExposePort sets the ExposePort field's value.
func (s *PortForCreateDeploymentInput) SetExposePort(v string) *PortForCreateDeploymentInput {
	s.ExposePort = &v
	return s
}

// SetListenPort sets the ListenPort field's value.
func (s *PortForCreateDeploymentInput) SetListenPort(v string) *PortForCreateDeploymentInput {
	s.ListenPort = &v
	return s
}

// SetPath sets the Path field's value.
func (s *PortForCreateDeploymentInput) SetPath(v string) *PortForCreateDeploymentInput {
	s.Path = &v
	return s
}

// SetType sets the Type field's value.
func (s *PortForCreateDeploymentInput) SetType(v string) *PortForCreateDeploymentInput {
	s.Type = &v
	return s
}

type ReadinessProbeForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Exec *ExecForCreateDeploymentInput `type:"structure" json:",omitempty"`

	FailureThreshold *int32 `type:"int32" json:",omitempty"`

	HTTPGet *HTTPGetForCreateDeploymentInput `type:"structure" json:",omitempty"`

	InitialDelaySeconds *int32 `type:"int32" json:",omitempty"`

	PeriodSeconds *int32 `type:"int32" json:",omitempty"`

	SuccessThreshold *int32 `type:"int32" json:",omitempty"`

	TCPSocket *TCPSocketForCreateDeploymentInput `type:"structure" json:",omitempty"`

	TimeoutSeconds *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ReadinessProbeForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReadinessProbeForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *ReadinessProbeForCreateDeploymentInput) SetEnabled(v bool) *ReadinessProbeForCreateDeploymentInput {
	s.Enabled = &v
	return s
}

// SetExec sets the Exec field's value.
func (s *ReadinessProbeForCreateDeploymentInput) SetExec(v *ExecForCreateDeploymentInput) *ReadinessProbeForCreateDeploymentInput {
	s.Exec = v
	return s
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *ReadinessProbeForCreateDeploymentInput) SetFailureThreshold(v int32) *ReadinessProbeForCreateDeploymentInput {
	s.FailureThreshold = &v
	return s
}

// SetHTTPGet sets the HTTPGet field's value.
func (s *ReadinessProbeForCreateDeploymentInput) SetHTTPGet(v *HTTPGetForCreateDeploymentInput) *ReadinessProbeForCreateDeploymentInput {
	s.HTTPGet = v
	return s
}

// SetInitialDelaySeconds sets the InitialDelaySeconds field's value.
func (s *ReadinessProbeForCreateDeploymentInput) SetInitialDelaySeconds(v int32) *ReadinessProbeForCreateDeploymentInput {
	s.InitialDelaySeconds = &v
	return s
}

// SetPeriodSeconds sets the PeriodSeconds field's value.
func (s *ReadinessProbeForCreateDeploymentInput) SetPeriodSeconds(v int32) *ReadinessProbeForCreateDeploymentInput {
	s.PeriodSeconds = &v
	return s
}

// SetSuccessThreshold sets the SuccessThreshold field's value.
func (s *ReadinessProbeForCreateDeploymentInput) SetSuccessThreshold(v int32) *ReadinessProbeForCreateDeploymentInput {
	s.SuccessThreshold = &v
	return s
}

// SetTCPSocket sets the TCPSocket field's value.
func (s *ReadinessProbeForCreateDeploymentInput) SetTCPSocket(v *TCPSocketForCreateDeploymentInput) *ReadinessProbeForCreateDeploymentInput {
	s.TCPSocket = v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *ReadinessProbeForCreateDeploymentInput) SetTimeoutSeconds(v int32) *ReadinessProbeForCreateDeploymentInput {
	s.TimeoutSeconds = &v
	return s
}

type ResourceForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FlexibleResourceClaim *FlexibleResourceClaimForCreateDeploymentInput `type:"structure" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetFlexibleResourceClaim sets the FlexibleResourceClaim field's value.
func (s *ResourceForCreateDeploymentInput) SetFlexibleResourceClaim(v *FlexibleResourceClaimForCreateDeploymentInput) *ResourceForCreateDeploymentInput {
	s.FlexibleResourceClaim = v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ResourceForCreateDeploymentInput) SetInstanceTypeId(v string) *ResourceForCreateDeploymentInput {
	s.InstanceTypeId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceForCreateDeploymentInput) SetType(v string) *ResourceForCreateDeploymentInput {
	s.Type = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ResourceForCreateDeploymentInput) SetZoneId(v string) *ResourceForCreateDeploymentInput {
	s.ZoneId = &v
	return s
}

type RoleForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Command *string `type:"string" json:",omitempty"`

	Credential *CredentialForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Envs []*EnvForCreateDeploymentInput `type:"list" json:",omitempty"`

	Expose *bool `type:"boolean" json:",omitempty"`

	GracefulShutdownPeriod *int32 `type:"int32" json:",omitempty"`

	Image *ImageForCreateDeploymentInput `type:"structure" json:",omitempty"`

	LivenessProbe *LivenessProbeForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Model *ModelForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NodeAffinitySpec *NodeAffinitySpecForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Ports []*PortForCreateDeploymentInput `type:"list" json:",omitempty"`

	ReadinessProbe *ReadinessProbeForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Replicas *int32 `type:"int32" json:",omitempty"`

	Resource *ResourceForCreateDeploymentInput `type:"structure" json:",omitempty"`

	RollingUpdateStrategy *RollingUpdateStrategyForCreateDeploymentInput `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	ShardNum *int32 `type:"int32" json:",omitempty"`

	StartupProbe *StartupProbeForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Storages []*StorageForCreateDeploymentInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s RoleForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RoleForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *RoleForCreateDeploymentInput) SetCommand(v string) *RoleForCreateDeploymentInput {
	s.Command = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *RoleForCreateDeploymentInput) SetCredential(v *CredentialForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.Credential = v
	return s
}

// SetEnvs sets the Envs field's value.
func (s *RoleForCreateDeploymentInput) SetEnvs(v []*EnvForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.Envs = v
	return s
}

// SetExpose sets the Expose field's value.
func (s *RoleForCreateDeploymentInput) SetExpose(v bool) *RoleForCreateDeploymentInput {
	s.Expose = &v
	return s
}

// SetGracefulShutdownPeriod sets the GracefulShutdownPeriod field's value.
func (s *RoleForCreateDeploymentInput) SetGracefulShutdownPeriod(v int32) *RoleForCreateDeploymentInput {
	s.GracefulShutdownPeriod = &v
	return s
}

// SetImage sets the Image field's value.
func (s *RoleForCreateDeploymentInput) SetImage(v *ImageForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.Image = v
	return s
}

// SetLivenessProbe sets the LivenessProbe field's value.
func (s *RoleForCreateDeploymentInput) SetLivenessProbe(v *LivenessProbeForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.LivenessProbe = v
	return s
}

// SetModel sets the Model field's value.
func (s *RoleForCreateDeploymentInput) SetModel(v *ModelForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.Model = v
	return s
}

// SetName sets the Name field's value.
func (s *RoleForCreateDeploymentInput) SetName(v string) *RoleForCreateDeploymentInput {
	s.Name = &v
	return s
}

// SetNodeAffinitySpec sets the NodeAffinitySpec field's value.
func (s *RoleForCreateDeploymentInput) SetNodeAffinitySpec(v *NodeAffinitySpecForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.NodeAffinitySpec = v
	return s
}

// SetPorts sets the Ports field's value.
func (s *RoleForCreateDeploymentInput) SetPorts(v []*PortForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.Ports = v
	return s
}

// SetReadinessProbe sets the ReadinessProbe field's value.
func (s *RoleForCreateDeploymentInput) SetReadinessProbe(v *ReadinessProbeForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.ReadinessProbe = v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *RoleForCreateDeploymentInput) SetReplicas(v int32) *RoleForCreateDeploymentInput {
	s.Replicas = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *RoleForCreateDeploymentInput) SetResource(v *ResourceForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.Resource = v
	return s
}

// SetRollingUpdateStrategy sets the RollingUpdateStrategy field's value.
func (s *RoleForCreateDeploymentInput) SetRollingUpdateStrategy(v *RollingUpdateStrategyForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.RollingUpdateStrategy = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *RoleForCreateDeploymentInput) SetSecurityGroupIds(v []*string) *RoleForCreateDeploymentInput {
	s.SecurityGroupIds = v
	return s
}

// SetShardNum sets the ShardNum field's value.
func (s *RoleForCreateDeploymentInput) SetShardNum(v int32) *RoleForCreateDeploymentInput {
	s.ShardNum = &v
	return s
}

// SetStartupProbe sets the StartupProbe field's value.
func (s *RoleForCreateDeploymentInput) SetStartupProbe(v *StartupProbeForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.StartupProbe = v
	return s
}

// SetStorages sets the Storages field's value.
func (s *RoleForCreateDeploymentInput) SetStorages(v []*StorageForCreateDeploymentInput) *RoleForCreateDeploymentInput {
	s.Storages = v
	return s
}

type RollingUpdateStrategyForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MaxSurge *int32 `type:"int32" json:",omitempty"`

	MaxUnavailable *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s RollingUpdateStrategyForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RollingUpdateStrategyForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetMaxSurge sets the MaxSurge field's value.
func (s *RollingUpdateStrategyForCreateDeploymentInput) SetMaxSurge(v int32) *RollingUpdateStrategyForCreateDeploymentInput {
	s.MaxSurge = &v
	return s
}

// SetMaxUnavailable sets the MaxUnavailable field's value.
func (s *RollingUpdateStrategyForCreateDeploymentInput) SetMaxUnavailable(v int32) *RollingUpdateStrategyForCreateDeploymentInput {
	s.MaxUnavailable = &v
	return s
}

type SfcsForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CachePolicyId *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Options *ConvertOptionsForCreateDeploymentInput `type:"structure" json:",omitempty"`

	Tos *TosForCreateDeploymentInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SfcsForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SfcsForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetCachePolicyId sets the CachePolicyId field's value.
func (s *SfcsForCreateDeploymentInput) SetCachePolicyId(v string) *SfcsForCreateDeploymentInput {
	s.CachePolicyId = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *SfcsForCreateDeploymentInput) SetFileSystemName(v string) *SfcsForCreateDeploymentInput {
	s.FileSystemName = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *SfcsForCreateDeploymentInput) SetOptions(v *ConvertOptionsForCreateDeploymentInput) *SfcsForCreateDeploymentInput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *SfcsForCreateDeploymentInput) SetTos(v *TosForCreateDeploymentInput) *SfcsForCreateDeploymentInput {
	s.Tos = v
	return s
}

type StartupProbeForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Exec *ExecForCreateDeploymentInput `type:"structure" json:",omitempty"`

	FailureThreshold *int32 `type:"int32" json:",omitempty"`

	HTTPGet *HTTPGetForCreateDeploymentInput `type:"structure" json:",omitempty"`

	InitialDelaySeconds *int32 `type:"int32" json:",omitempty"`

	PeriodSeconds *int32 `type:"int32" json:",omitempty"`

	SuccessThreshold *int32 `type:"int32" json:",omitempty"`

	TCPSocket *TCPSocketForCreateDeploymentInput `type:"structure" json:",omitempty"`

	TimeoutSeconds *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s StartupProbeForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartupProbeForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *StartupProbeForCreateDeploymentInput) SetEnabled(v bool) *StartupProbeForCreateDeploymentInput {
	s.Enabled = &v
	return s
}

// SetExec sets the Exec field's value.
func (s *StartupProbeForCreateDeploymentInput) SetExec(v *ExecForCreateDeploymentInput) *StartupProbeForCreateDeploymentInput {
	s.Exec = v
	return s
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *StartupProbeForCreateDeploymentInput) SetFailureThreshold(v int32) *StartupProbeForCreateDeploymentInput {
	s.FailureThreshold = &v
	return s
}

// SetHTTPGet sets the HTTPGet field's value.
func (s *StartupProbeForCreateDeploymentInput) SetHTTPGet(v *HTTPGetForCreateDeploymentInput) *StartupProbeForCreateDeploymentInput {
	s.HTTPGet = v
	return s
}

// SetInitialDelaySeconds sets the InitialDelaySeconds field's value.
func (s *StartupProbeForCreateDeploymentInput) SetInitialDelaySeconds(v int32) *StartupProbeForCreateDeploymentInput {
	s.InitialDelaySeconds = &v
	return s
}

// SetPeriodSeconds sets the PeriodSeconds field's value.
func (s *StartupProbeForCreateDeploymentInput) SetPeriodSeconds(v int32) *StartupProbeForCreateDeploymentInput {
	s.PeriodSeconds = &v
	return s
}

// SetSuccessThreshold sets the SuccessThreshold field's value.
func (s *StartupProbeForCreateDeploymentInput) SetSuccessThreshold(v int32) *StartupProbeForCreateDeploymentInput {
	s.SuccessThreshold = &v
	return s
}

// SetTCPSocket sets the TCPSocket field's value.
func (s *StartupProbeForCreateDeploymentInput) SetTCPSocket(v *TCPSocketForCreateDeploymentInput) *StartupProbeForCreateDeploymentInput {
	s.TCPSocket = v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *StartupProbeForCreateDeploymentInput) SetTimeoutSeconds(v int32) *StartupProbeForCreateDeploymentInput {
	s.TimeoutSeconds = &v
	return s
}

type StatusForCreateDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	SecondaryState *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StatusForCreateDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForCreateDeploymentOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *StatusForCreateDeploymentOutput) SetMessage(v string) *StatusForCreateDeploymentOutput {
	s.Message = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *StatusForCreateDeploymentOutput) SetSecondaryState(v string) *StatusForCreateDeploymentOutput {
	s.SecondaryState = &v
	return s
}

// SetState sets the State field's value.
func (s *StatusForCreateDeploymentOutput) SetState(v string) *StatusForCreateDeploymentOutput {
	s.State = &v
	return s
}

type StorageForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Config *ConfigForCreateDeploymentInput `type:"structure" json:",omitempty"`

	MountPath *string `type:"string" json:",omitempty"`

	ReadOnly *bool `type:"boolean" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StorageForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *StorageForCreateDeploymentInput) SetConfig(v *ConfigForCreateDeploymentInput) *StorageForCreateDeploymentInput {
	s.Config = v
	return s
}

// SetMountPath sets the MountPath field's value.
func (s *StorageForCreateDeploymentInput) SetMountPath(v string) *StorageForCreateDeploymentInput {
	s.MountPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *StorageForCreateDeploymentInput) SetReadOnly(v bool) *StorageForCreateDeploymentInput {
	s.ReadOnly = &v
	return s
}

// SetType sets the Type field's value.
func (s *StorageForCreateDeploymentInput) SetType(v string) *StorageForCreateDeploymentInput {
	s.Type = &v
	return s
}

type TCPSocketForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s TCPSocketForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TCPSocketForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *TCPSocketForCreateDeploymentInput) SetPort(v int32) *TCPSocketForCreateDeploymentInput {
	s.Port = &v
	return s
}

type TosForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bucket *string `type:"string" json:",omitempty"`

	Prefix *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TosForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *TosForCreateDeploymentInput) SetBucket(v string) *TosForCreateDeploymentInput {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *TosForCreateDeploymentInput) SetPrefix(v string) *TosForCreateDeploymentInput {
	s.Prefix = &v
	return s
}

type UpstreamConfigForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConsistentHashConfig *ConsistentHashConfigForCreateDeploymentInput `type:"structure" json:",omitempty"`

	LoadBalancePolicy *string `type:"string" json:",omitempty" enum:"EnumOfLoadBalancePolicyForCreateDeploymentInput"`
}

// String returns the string representation
func (s UpstreamConfigForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpstreamConfigForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetConsistentHashConfig sets the ConsistentHashConfig field's value.
func (s *UpstreamConfigForCreateDeploymentInput) SetConsistentHashConfig(v *ConsistentHashConfigForCreateDeploymentInput) *UpstreamConfigForCreateDeploymentInput {
	s.ConsistentHashConfig = v
	return s
}

// SetLoadBalancePolicy sets the LoadBalancePolicy field's value.
func (s *UpstreamConfigForCreateDeploymentInput) SetLoadBalancePolicy(v string) *UpstreamConfigForCreateDeploymentInput {
	s.LoadBalancePolicy = &v
	return s
}

type VepfsForCreateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	HostPath *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VepfsForCreateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VepfsForCreateDeploymentInput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *VepfsForCreateDeploymentInput) SetFileSystemName(v string) *VepfsForCreateDeploymentInput {
	s.FileSystemName = &v
	return s
}

// SetHostPath sets the HostPath field's value.
func (s *VepfsForCreateDeploymentInput) SetHostPath(v string) *VepfsForCreateDeploymentInput {
	s.HostPath = &v
	return s
}

// SetId sets the Id field's value.
func (s *VepfsForCreateDeploymentInput) SetId(v string) *VepfsForCreateDeploymentInput {
	s.Id = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *VepfsForCreateDeploymentInput) SetSubPath(v string) *VepfsForCreateDeploymentInput {
	s.SubPath = &v
	return s
}

const (
	// EnumOfGPUCPUNodePreferenceForCreateDeploymentInputGpurequired is a EnumOfGPUCPUNodePreferenceForCreateDeploymentInput enum value
	EnumOfGPUCPUNodePreferenceForCreateDeploymentInputGpurequired = "GPURequired"

	// EnumOfGPUCPUNodePreferenceForCreateDeploymentInputGpupreferred is a EnumOfGPUCPUNodePreferenceForCreateDeploymentInput enum value
	EnumOfGPUCPUNodePreferenceForCreateDeploymentInputGpupreferred = "GPUPreferred"

	// EnumOfGPUCPUNodePreferenceForCreateDeploymentInputCpurequired is a EnumOfGPUCPUNodePreferenceForCreateDeploymentInput enum value
	EnumOfGPUCPUNodePreferenceForCreateDeploymentInputCpurequired = "CPURequired"

	// EnumOfGPUCPUNodePreferenceForCreateDeploymentInputCpupreferred is a EnumOfGPUCPUNodePreferenceForCreateDeploymentInput enum value
	EnumOfGPUCPUNodePreferenceForCreateDeploymentInputCpupreferred = "CPUPreferred"
)

const (
	// EnumOfHashKeyTypeForCreateDeploymentInputHttpHeaderName is a EnumOfHashKeyTypeForCreateDeploymentInput enum value
	EnumOfHashKeyTypeForCreateDeploymentInputHttpHeaderName = "HttpHeaderName"
)

const (
	// EnumOfLoadBalancePolicyForCreateDeploymentInputRoundRobin is a EnumOfLoadBalancePolicyForCreateDeploymentInput enum value
	EnumOfLoadBalancePolicyForCreateDeploymentInputRoundRobin = "ROUND_ROBIN"

	// EnumOfLoadBalancePolicyForCreateDeploymentInputLeastConn is a EnumOfLoadBalancePolicyForCreateDeploymentInput enum value
	EnumOfLoadBalancePolicyForCreateDeploymentInputLeastConn = "LEAST_CONN"

	// EnumOfLoadBalancePolicyForCreateDeploymentInputRandom is a EnumOfLoadBalancePolicyForCreateDeploymentInput enum value
	EnumOfLoadBalancePolicyForCreateDeploymentInputRandom = "RANDOM"

	// EnumOfLoadBalancePolicyForCreateDeploymentInputConsistentHash is a EnumOfLoadBalancePolicyForCreateDeploymentInput enum value
	EnumOfLoadBalancePolicyForCreateDeploymentInputConsistentHash = "CONSISTENT_HASH"
)

const (
	// EnumOfSchedulerForCreateDeploymentInputWrr is a EnumOfSchedulerForCreateDeploymentInput enum value
	EnumOfSchedulerForCreateDeploymentInputWrr = "wrr"

	// EnumOfSchedulerForCreateDeploymentInputWlc is a EnumOfSchedulerForCreateDeploymentInput enum value
	EnumOfSchedulerForCreateDeploymentInputWlc = "wlc"

	// EnumOfSchedulerForCreateDeploymentInputSh is a EnumOfSchedulerForCreateDeploymentInput enum value
	EnumOfSchedulerForCreateDeploymentInputSh = "sh"
)

const (
	// EnumOfSchemeForCreateDeploymentInputHttp is a EnumOfSchemeForCreateDeploymentInput enum value
	EnumOfSchemeForCreateDeploymentInputHttp = "HTTP"

	// EnumOfSchemeForCreateDeploymentInputHttps is a EnumOfSchemeForCreateDeploymentInput enum value
	EnumOfSchemeForCreateDeploymentInputHttps = "HTTPS"
)

const (
	// EnumOfTypeForCreateDeploymentInputHttp11 is a EnumOfTypeForCreateDeploymentInput enum value
	EnumOfTypeForCreateDeploymentInputHttp11 = "HTTP/1.1"

	// EnumOfTypeForCreateDeploymentInputHttp2 is a EnumOfTypeForCreateDeploymentInput enum value
	EnumOfTypeForCreateDeploymentInputHttp2 = "HTTP2"

	// EnumOfTypeForCreateDeploymentInputGrpc is a EnumOfTypeForCreateDeploymentInput enum value
	EnumOfTypeForCreateDeploymentInputGrpc = "GRPC"

	// EnumOfTypeForCreateDeploymentInputMetrics is a EnumOfTypeForCreateDeploymentInput enum value
	EnumOfTypeForCreateDeploymentInputMetrics = "Metrics"

	// EnumOfTypeForCreateDeploymentInputOther is a EnumOfTypeForCreateDeploymentInput enum value
	EnumOfTypeForCreateDeploymentInputOther = "Other"
)
