// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opConnectCustomKeyStoreCommon = "ConnectCustomKeyStore"

// ConnectCustomKeyStoreCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ConnectCustomKeyStoreCommon operation. The "output" return
// value will be populated with the ConnectCustomKeyStoreCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ConnectCustomKeyStoreCommon Request to send the API call to the service.
// the "output" return value is not valid until after ConnectCustomKeyStoreCommon Send returns without error.
//
// See ConnectCustomKeyStoreCommon for more information on using the ConnectCustomKeyStoreCommon
// API call, and error handling.
//
//    // Example sending a request using the ConnectCustomKeyStoreCommonRequest method.
//    req, resp := client.ConnectCustomKeyStoreCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ConnectCustomKeyStoreCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opConnectCustomKeyStoreCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ConnectCustomKeyStoreCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ConnectCustomKeyStoreCommon for usage and error information.
func (c *KMS) ConnectCustomKeyStoreCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ConnectCustomKeyStoreCommonRequest(input)
	return out, req.Send()
}

// ConnectCustomKeyStoreCommonWithContext is the same as ConnectCustomKeyStoreCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ConnectCustomKeyStoreCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ConnectCustomKeyStoreCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ConnectCustomKeyStoreCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConnectCustomKeyStore = "ConnectCustomKeyStore"

// ConnectCustomKeyStoreRequest generates a "volcengine/request.Request" representing the
// client's request for the ConnectCustomKeyStore operation. The "output" return
// value will be populated with the ConnectCustomKeyStoreCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ConnectCustomKeyStoreCommon Request to send the API call to the service.
// the "output" return value is not valid until after ConnectCustomKeyStoreCommon Send returns without error.
//
// See ConnectCustomKeyStore for more information on using the ConnectCustomKeyStore
// API call, and error handling.
//
//    // Example sending a request using the ConnectCustomKeyStoreRequest method.
//    req, resp := client.ConnectCustomKeyStoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ConnectCustomKeyStoreRequest(input *ConnectCustomKeyStoreInput) (req *request.Request, output *ConnectCustomKeyStoreOutput) {
	op := &request.Operation{
		Name:       opConnectCustomKeyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConnectCustomKeyStoreInput{}
	}

	output = &ConnectCustomKeyStoreOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ConnectCustomKeyStore API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ConnectCustomKeyStore for usage and error information.
func (c *KMS) ConnectCustomKeyStore(input *ConnectCustomKeyStoreInput) (*ConnectCustomKeyStoreOutput, error) {
	req, out := c.ConnectCustomKeyStoreRequest(input)
	return out, req.Send()
}

// ConnectCustomKeyStoreWithContext is the same as ConnectCustomKeyStore with the addition of
// the ability to pass a context and additional request options.
//
// See ConnectCustomKeyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ConnectCustomKeyStoreWithContext(ctx volcengine.Context, input *ConnectCustomKeyStoreInput, opts ...request.Option) (*ConnectCustomKeyStoreOutput, error) {
	req, out := c.ConnectCustomKeyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ConnectCustomKeyStoreInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// CustomKeyStoreID is a required field
	CustomKeyStoreID *string `min:"36" max:"36" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ConnectCustomKeyStoreInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectCustomKeyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectCustomKeyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectCustomKeyStoreInput"}
	if s.CustomKeyStoreID == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomKeyStoreID"))
	}
	if s.CustomKeyStoreID != nil && len(*s.CustomKeyStoreID) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreID", 36))
	}
	if s.CustomKeyStoreID != nil && len(*s.CustomKeyStoreID) > 36 {
		invalidParams.Add(request.NewErrParamMaxLen("CustomKeyStoreID", 36, *s.CustomKeyStoreID))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomKeyStoreID sets the CustomKeyStoreID field's value.
func (s *ConnectCustomKeyStoreInput) SetCustomKeyStoreID(v string) *ConnectCustomKeyStoreInput {
	s.CustomKeyStoreID = &v
	return s
}

type ConnectCustomKeyStoreOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s ConnectCustomKeyStoreOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectCustomKeyStoreOutput) GoString() string {
	return s.String()
}
