// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opQueryDataMigrateTaskCommon = "QueryDataMigrateTask"

// QueryDataMigrateTaskCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the QueryDataMigrateTaskCommon operation. The "output" return
// value will be populated with the QueryDataMigrateTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned QueryDataMigrateTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after QueryDataMigrateTaskCommon Send returns without error.
//
// See QueryDataMigrateTaskCommon for more information on using the QueryDataMigrateTaskCommon
// API call, and error handling.
//
//    // Example sending a request using the QueryDataMigrateTaskCommonRequest method.
//    req, resp := client.QueryDataMigrateTaskCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DMS) QueryDataMigrateTaskCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opQueryDataMigrateTaskCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// QueryDataMigrateTaskCommon API operation for DMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DMS's
// API operation QueryDataMigrateTaskCommon for usage and error information.
func (c *DMS) QueryDataMigrateTaskCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.QueryDataMigrateTaskCommonRequest(input)
	return out, req.Send()
}

// QueryDataMigrateTaskCommonWithContext is the same as QueryDataMigrateTaskCommon with the addition of
// the ability to pass a context and additional request options.
//
// See QueryDataMigrateTaskCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DMS) QueryDataMigrateTaskCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.QueryDataMigrateTaskCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opQueryDataMigrateTask = "QueryDataMigrateTask"

// QueryDataMigrateTaskRequest generates a "volcengine/request.Request" representing the
// client's request for the QueryDataMigrateTask operation. The "output" return
// value will be populated with the QueryDataMigrateTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned QueryDataMigrateTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after QueryDataMigrateTaskCommon Send returns without error.
//
// See QueryDataMigrateTask for more information on using the QueryDataMigrateTask
// API call, and error handling.
//
//    // Example sending a request using the QueryDataMigrateTaskRequest method.
//    req, resp := client.QueryDataMigrateTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DMS) QueryDataMigrateTaskRequest(input *QueryDataMigrateTaskInput) (req *request.Request, output *QueryDataMigrateTaskOutput) {
	op := &request.Operation{
		Name:       opQueryDataMigrateTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &QueryDataMigrateTaskInput{}
	}

	output = &QueryDataMigrateTaskOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// QueryDataMigrateTask API operation for DMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DMS's
// API operation QueryDataMigrateTask for usage and error information.
func (c *DMS) QueryDataMigrateTask(input *QueryDataMigrateTaskInput) (*QueryDataMigrateTaskOutput, error) {
	req, out := c.QueryDataMigrateTaskRequest(input)
	return out, req.Send()
}

// QueryDataMigrateTaskWithContext is the same as QueryDataMigrateTask with the addition of
// the ability to pass a context and additional request options.
//
// See QueryDataMigrateTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DMS) QueryDataMigrateTaskWithContext(ctx volcengine.Context, input *QueryDataMigrateTaskInput, opts ...request.Option) (*QueryDataMigrateTaskOutput, error) {
	req, out := c.QueryDataMigrateTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AdvanceConfigForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IncreaseSetting *IncreaseSettingForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	PrivateLink *PrivateLinkForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	RenameSetting *RenameSettingForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	TimeBandwidthSetting []*TimeBandwidthSettingForQueryDataMigrateTaskOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s AdvanceConfigForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AdvanceConfigForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetIncreaseSetting sets the IncreaseSetting field's value.
func (s *AdvanceConfigForQueryDataMigrateTaskOutput) SetIncreaseSetting(v *IncreaseSettingForQueryDataMigrateTaskOutput) *AdvanceConfigForQueryDataMigrateTaskOutput {
	s.IncreaseSetting = v
	return s
}

// SetPrivateLink sets the PrivateLink field's value.
func (s *AdvanceConfigForQueryDataMigrateTaskOutput) SetPrivateLink(v *PrivateLinkForQueryDataMigrateTaskOutput) *AdvanceConfigForQueryDataMigrateTaskOutput {
	s.PrivateLink = v
	return s
}

// SetRenameSetting sets the RenameSetting field's value.
func (s *AdvanceConfigForQueryDataMigrateTaskOutput) SetRenameSetting(v *RenameSettingForQueryDataMigrateTaskOutput) *AdvanceConfigForQueryDataMigrateTaskOutput {
	s.RenameSetting = v
	return s
}

// SetTimeBandwidthSetting sets the TimeBandwidthSetting field's value.
func (s *AdvanceConfigForQueryDataMigrateTaskOutput) SetTimeBandwidthSetting(v []*TimeBandwidthSettingForQueryDataMigrateTaskOutput) *AdvanceConfigForQueryDataMigrateTaskOutput {
	s.TimeBandwidthSetting = v
	return s
}

type BasicConfigForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bandwidth *int32 `min:"1" max:"1.073741824e+09" type:"int32" json:",omitempty"`

	EnableRangeCheck *bool `type:"boolean" json:",omitempty"`

	FailedNumToAbort *int32 `type:"int32" json:",omitempty"`

	ObjectMigrationPolicy *ObjectMigrationPolicyForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	OfflineMigrationPolicy *OfflineMigrationPolicyForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	OverwritePolicy *string `type:"string" json:",omitempty" enum:"EnumOfOverwritePolicyForQueryDataMigrateTaskOutput"`

	SourceType *string `type:"string" json:",omitempty" enum:"EnumOfSourceTypeForQueryDataMigrateTaskOutput"`

	StorageClass *string `type:"string" json:",omitempty" enum:"EnumOfStorageClassForQueryDataMigrateTaskOutput"`

	TaskName *string `min:"3" max:"32" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BasicConfigForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BasicConfigForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *BasicConfigForQueryDataMigrateTaskOutput) SetBandwidth(v int32) *BasicConfigForQueryDataMigrateTaskOutput {
	s.Bandwidth = &v
	return s
}

// SetEnableRangeCheck sets the EnableRangeCheck field's value.
func (s *BasicConfigForQueryDataMigrateTaskOutput) SetEnableRangeCheck(v bool) *BasicConfigForQueryDataMigrateTaskOutput {
	s.EnableRangeCheck = &v
	return s
}

// SetFailedNumToAbort sets the FailedNumToAbort field's value.
func (s *BasicConfigForQueryDataMigrateTaskOutput) SetFailedNumToAbort(v int32) *BasicConfigForQueryDataMigrateTaskOutput {
	s.FailedNumToAbort = &v
	return s
}

// SetObjectMigrationPolicy sets the ObjectMigrationPolicy field's value.
func (s *BasicConfigForQueryDataMigrateTaskOutput) SetObjectMigrationPolicy(v *ObjectMigrationPolicyForQueryDataMigrateTaskOutput) *BasicConfigForQueryDataMigrateTaskOutput {
	s.ObjectMigrationPolicy = v
	return s
}

// SetOfflineMigrationPolicy sets the OfflineMigrationPolicy field's value.
func (s *BasicConfigForQueryDataMigrateTaskOutput) SetOfflineMigrationPolicy(v *OfflineMigrationPolicyForQueryDataMigrateTaskOutput) *BasicConfigForQueryDataMigrateTaskOutput {
	s.OfflineMigrationPolicy = v
	return s
}

// SetOverwritePolicy sets the OverwritePolicy field's value.
func (s *BasicConfigForQueryDataMigrateTaskOutput) SetOverwritePolicy(v string) *BasicConfigForQueryDataMigrateTaskOutput {
	s.OverwritePolicy = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *BasicConfigForQueryDataMigrateTaskOutput) SetSourceType(v string) *BasicConfigForQueryDataMigrateTaskOutput {
	s.SourceType = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *BasicConfigForQueryDataMigrateTaskOutput) SetStorageClass(v string) *BasicConfigForQueryDataMigrateTaskOutput {
	s.StorageClass = &v
	return s
}

// SetTaskName sets the TaskName field's value.
func (s *BasicConfigForQueryDataMigrateTaskOutput) SetTaskName(v string) *BasicConfigForQueryDataMigrateTaskOutput {
	s.TaskName = &v
	return s
}

type BucketAccessConfigForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AK *string `type:"string" json:",omitempty"`

	BucketName *string `type:"string" json:",omitempty"`

	Endpoint *string `type:"string" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	RoleTrn *string `type:"string" json:",omitempty"`

	SK *string `type:"string" json:",omitempty"`

	Vendor *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BucketAccessConfigForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketAccessConfigForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetAK sets the AK field's value.
func (s *BucketAccessConfigForQueryDataMigrateTaskOutput) SetAK(v string) *BucketAccessConfigForQueryDataMigrateTaskOutput {
	s.AK = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *BucketAccessConfigForQueryDataMigrateTaskOutput) SetBucketName(v string) *BucketAccessConfigForQueryDataMigrateTaskOutput {
	s.BucketName = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *BucketAccessConfigForQueryDataMigrateTaskOutput) SetEndpoint(v string) *BucketAccessConfigForQueryDataMigrateTaskOutput {
	s.Endpoint = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *BucketAccessConfigForQueryDataMigrateTaskOutput) SetRegion(v string) *BucketAccessConfigForQueryDataMigrateTaskOutput {
	s.Region = &v
	return s
}

// SetRoleTrn sets the RoleTrn field's value.
func (s *BucketAccessConfigForQueryDataMigrateTaskOutput) SetRoleTrn(v string) *BucketAccessConfigForQueryDataMigrateTaskOutput {
	s.RoleTrn = &v
	return s
}

// SetSK sets the SK field's value.
func (s *BucketAccessConfigForQueryDataMigrateTaskOutput) SetSK(v string) *BucketAccessConfigForQueryDataMigrateTaskOutput {
	s.SK = &v
	return s
}

// SetVendor sets the Vendor field's value.
func (s *BucketAccessConfigForQueryDataMigrateTaskOutput) SetVendor(v string) *BucketAccessConfigForQueryDataMigrateTaskOutput {
	s.Vendor = &v
	return s
}

type IncreaseSettingForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Interval *int32 `min:"3600" max:"86400" type:"int32" json:",omitempty"`

	Times *int32 `min:"1" max:"30" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s IncreaseSettingForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IncreaseSettingForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetInterval sets the Interval field's value.
func (s *IncreaseSettingForQueryDataMigrateTaskOutput) SetInterval(v int32) *IncreaseSettingForQueryDataMigrateTaskOutput {
	s.Interval = &v
	return s
}

// SetTimes sets the Times field's value.
func (s *IncreaseSettingForQueryDataMigrateTaskOutput) SetTimes(v int32) *IncreaseSettingForQueryDataMigrateTaskOutput {
	s.Times = &v
	return s
}

type ObjectMigrationPolicyForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SyncAcl *bool `type:"boolean" json:",omitempty"`

	SyncSymlink *bool `type:"boolean" json:",omitempty"`

	SyncTag *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s ObjectMigrationPolicyForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectMigrationPolicyForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetSyncAcl sets the SyncAcl field's value.
func (s *ObjectMigrationPolicyForQueryDataMigrateTaskOutput) SetSyncAcl(v bool) *ObjectMigrationPolicyForQueryDataMigrateTaskOutput {
	s.SyncAcl = &v
	return s
}

// SetSyncSymlink sets the SyncSymlink field's value.
func (s *ObjectMigrationPolicyForQueryDataMigrateTaskOutput) SetSyncSymlink(v bool) *ObjectMigrationPolicyForQueryDataMigrateTaskOutput {
	s.SyncSymlink = &v
	return s
}

// SetSyncTag sets the SyncTag field's value.
func (s *ObjectMigrationPolicyForQueryDataMigrateTaskOutput) SetSyncTag(v bool) *ObjectMigrationPolicyForQueryDataMigrateTaskOutput {
	s.SyncTag = &v
	return s
}

type ObjectSourceConfigForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BucketAccessConfig *BucketAccessConfigForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	IsExcluded *bool `type:"boolean" json:",omitempty"`

	KeyListFile *string `type:"string" json:",omitempty"`

	PrefixList []*string `type:"list" json:",omitempty"`

	PrefixListFile *string `type:"string" json:",omitempty"`

	ScanWithDelimiter *bool `type:"boolean" json:",omitempty"`

	StartTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ObjectSourceConfigForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectSourceConfigForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetBucketAccessConfig sets the BucketAccessConfig field's value.
func (s *ObjectSourceConfigForQueryDataMigrateTaskOutput) SetBucketAccessConfig(v *BucketAccessConfigForQueryDataMigrateTaskOutput) *ObjectSourceConfigForQueryDataMigrateTaskOutput {
	s.BucketAccessConfig = v
	return s
}

// SetIsExcluded sets the IsExcluded field's value.
func (s *ObjectSourceConfigForQueryDataMigrateTaskOutput) SetIsExcluded(v bool) *ObjectSourceConfigForQueryDataMigrateTaskOutput {
	s.IsExcluded = &v
	return s
}

// SetKeyListFile sets the KeyListFile field's value.
func (s *ObjectSourceConfigForQueryDataMigrateTaskOutput) SetKeyListFile(v string) *ObjectSourceConfigForQueryDataMigrateTaskOutput {
	s.KeyListFile = &v
	return s
}

// SetPrefixList sets the PrefixList field's value.
func (s *ObjectSourceConfigForQueryDataMigrateTaskOutput) SetPrefixList(v []*string) *ObjectSourceConfigForQueryDataMigrateTaskOutput {
	s.PrefixList = v
	return s
}

// SetPrefixListFile sets the PrefixListFile field's value.
func (s *ObjectSourceConfigForQueryDataMigrateTaskOutput) SetPrefixListFile(v string) *ObjectSourceConfigForQueryDataMigrateTaskOutput {
	s.PrefixListFile = &v
	return s
}

// SetScanWithDelimiter sets the ScanWithDelimiter field's value.
func (s *ObjectSourceConfigForQueryDataMigrateTaskOutput) SetScanWithDelimiter(v bool) *ObjectSourceConfigForQueryDataMigrateTaskOutput {
	s.ScanWithDelimiter = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ObjectSourceConfigForQueryDataMigrateTaskOutput) SetStartTime(v string) *ObjectSourceConfigForQueryDataMigrateTaskOutput {
	s.StartTime = &v
	return s
}

type OfflineMigrationPolicyForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Source *string `type:"string" json:",omitempty"`

	Target *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OfflineMigrationPolicyForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OfflineMigrationPolicyForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *OfflineMigrationPolicyForQueryDataMigrateTaskOutput) SetSource(v string) *OfflineMigrationPolicyForQueryDataMigrateTaskOutput {
	s.Source = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *OfflineMigrationPolicyForQueryDataMigrateTaskOutput) SetTarget(v string) *OfflineMigrationPolicyForQueryDataMigrateTaskOutput {
	s.Target = &v
	return s
}

type PrivateLinkForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ENIRole *string `type:"string" json:",omitempty"`

	IdcIP *string `type:"string" json:",omitempty"`

	IdcPort *int32 `type:"int32" json:",omitempty"`

	SecurityGroupIDs []*string `type:"list" json:",omitempty"`

	SubnetID *string `type:"string" json:",omitempty"`

	VpcID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PrivateLinkForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PrivateLinkForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetENIRole sets the ENIRole field's value.
func (s *PrivateLinkForQueryDataMigrateTaskOutput) SetENIRole(v string) *PrivateLinkForQueryDataMigrateTaskOutput {
	s.ENIRole = &v
	return s
}

// SetIdcIP sets the IdcIP field's value.
func (s *PrivateLinkForQueryDataMigrateTaskOutput) SetIdcIP(v string) *PrivateLinkForQueryDataMigrateTaskOutput {
	s.IdcIP = &v
	return s
}

// SetIdcPort sets the IdcPort field's value.
func (s *PrivateLinkForQueryDataMigrateTaskOutput) SetIdcPort(v int32) *PrivateLinkForQueryDataMigrateTaskOutput {
	s.IdcPort = &v
	return s
}

// SetSecurityGroupIDs sets the SecurityGroupIDs field's value.
func (s *PrivateLinkForQueryDataMigrateTaskOutput) SetSecurityGroupIDs(v []*string) *PrivateLinkForQueryDataMigrateTaskOutput {
	s.SecurityGroupIDs = v
	return s
}

// SetSubnetID sets the SubnetID field's value.
func (s *PrivateLinkForQueryDataMigrateTaskOutput) SetSubnetID(v string) *PrivateLinkForQueryDataMigrateTaskOutput {
	s.SubnetID = &v
	return s
}

// SetVpcID sets the VpcID field's value.
func (s *PrivateLinkForQueryDataMigrateTaskOutput) SetVpcID(v string) *PrivateLinkForQueryDataMigrateTaskOutput {
	s.VpcID = &v
	return s
}

type QueryDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// TaskID is a required field
	TaskID *int64 `type:"int64" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s QueryDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryDataMigrateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryDataMigrateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryDataMigrateTaskInput"}
	if s.TaskID == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskID sets the TaskID field's value.
func (s *QueryDataMigrateTaskInput) SetTaskID(v int64) *QueryDataMigrateTaskInput {
	s.TaskID = &v
	return s
}

type QueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	AdvanceConfig *AdvanceConfigForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	BasicConfig *BasicConfigForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Source *SourceForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	Target *TargetForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	TaskID *int64 `type:"int64" json:",omitempty"`

	TaskProgress *TaskProgressForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	TaskReport *TaskReportForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	TaskStatus *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s QueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetAdvanceConfig sets the AdvanceConfig field's value.
func (s *QueryDataMigrateTaskOutput) SetAdvanceConfig(v *AdvanceConfigForQueryDataMigrateTaskOutput) *QueryDataMigrateTaskOutput {
	s.AdvanceConfig = v
	return s
}

// SetBasicConfig sets the BasicConfig field's value.
func (s *QueryDataMigrateTaskOutput) SetBasicConfig(v *BasicConfigForQueryDataMigrateTaskOutput) *QueryDataMigrateTaskOutput {
	s.BasicConfig = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *QueryDataMigrateTaskOutput) SetCreateTime(v string) *QueryDataMigrateTaskOutput {
	s.CreateTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *QueryDataMigrateTaskOutput) SetSource(v *SourceForQueryDataMigrateTaskOutput) *QueryDataMigrateTaskOutput {
	s.Source = v
	return s
}

// SetTarget sets the Target field's value.
func (s *QueryDataMigrateTaskOutput) SetTarget(v *TargetForQueryDataMigrateTaskOutput) *QueryDataMigrateTaskOutput {
	s.Target = v
	return s
}

// SetTaskID sets the TaskID field's value.
func (s *QueryDataMigrateTaskOutput) SetTaskID(v int64) *QueryDataMigrateTaskOutput {
	s.TaskID = &v
	return s
}

// SetTaskProgress sets the TaskProgress field's value.
func (s *QueryDataMigrateTaskOutput) SetTaskProgress(v *TaskProgressForQueryDataMigrateTaskOutput) *QueryDataMigrateTaskOutput {
	s.TaskProgress = v
	return s
}

// SetTaskReport sets the TaskReport field's value.
func (s *QueryDataMigrateTaskOutput) SetTaskReport(v *TaskReportForQueryDataMigrateTaskOutput) *QueryDataMigrateTaskOutput {
	s.TaskReport = v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *QueryDataMigrateTaskOutput) SetTaskStatus(v string) *QueryDataMigrateTaskOutput {
	s.TaskStatus = &v
	return s
}

type RenameSettingForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Pattern *string `max:"696" type:"string" json:",omitempty"`

	ReplaceStr *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RenameSettingForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RenameSettingForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetPattern sets the Pattern field's value.
func (s *RenameSettingForQueryDataMigrateTaskOutput) SetPattern(v string) *RenameSettingForQueryDataMigrateTaskOutput {
	s.Pattern = &v
	return s
}

// SetReplaceStr sets the ReplaceStr field's value.
func (s *RenameSettingForQueryDataMigrateTaskOutput) SetReplaceStr(v string) *RenameSettingForQueryDataMigrateTaskOutput {
	s.ReplaceStr = &v
	return s
}

type SourceForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ObjectSourceConfig *ObjectSourceConfigForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	UrlSourceConfig *UrlSourceConfigForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SourceForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetObjectSourceConfig sets the ObjectSourceConfig field's value.
func (s *SourceForQueryDataMigrateTaskOutput) SetObjectSourceConfig(v *ObjectSourceConfigForQueryDataMigrateTaskOutput) *SourceForQueryDataMigrateTaskOutput {
	s.ObjectSourceConfig = v
	return s
}

// SetUrlSourceConfig sets the UrlSourceConfig field's value.
func (s *SourceForQueryDataMigrateTaskOutput) SetUrlSourceConfig(v *UrlSourceConfigForQueryDataMigrateTaskOutput) *SourceForQueryDataMigrateTaskOutput {
	s.UrlSourceConfig = v
	return s
}

type TargetForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AK *string `type:"string" json:",omitempty"`

	BucketName *string `type:"string" json:",omitempty"`

	Endpoint *string `type:"string" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	RoleTrn *string `type:"string" json:",omitempty"`

	SK *string `type:"string" json:",omitempty"`

	Vendor *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TargetForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetAK sets the AK field's value.
func (s *TargetForQueryDataMigrateTaskOutput) SetAK(v string) *TargetForQueryDataMigrateTaskOutput {
	s.AK = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *TargetForQueryDataMigrateTaskOutput) SetBucketName(v string) *TargetForQueryDataMigrateTaskOutput {
	s.BucketName = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *TargetForQueryDataMigrateTaskOutput) SetEndpoint(v string) *TargetForQueryDataMigrateTaskOutput {
	s.Endpoint = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *TargetForQueryDataMigrateTaskOutput) SetRegion(v string) *TargetForQueryDataMigrateTaskOutput {
	s.Region = &v
	return s
}

// SetRoleTrn sets the RoleTrn field's value.
func (s *TargetForQueryDataMigrateTaskOutput) SetRoleTrn(v string) *TargetForQueryDataMigrateTaskOutput {
	s.RoleTrn = &v
	return s
}

// SetSK sets the SK field's value.
func (s *TargetForQueryDataMigrateTaskOutput) SetSK(v string) *TargetForQueryDataMigrateTaskOutput {
	s.SK = &v
	return s
}

// SetVendor sets the Vendor field's value.
func (s *TargetForQueryDataMigrateTaskOutput) SetVendor(v string) *TargetForQueryDataMigrateTaskOutput {
	s.Vendor = &v
	return s
}

type TaskProgressForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FailedBytes *int64 `type:"int64" json:",omitempty"`

	FailedObjects *int64 `type:"int64" json:",omitempty"`

	NotExistBytes *int64 `type:"int64" json:",omitempty"`

	NotExistObjectCount *int64 `type:"int64" json:",omitempty"`

	RemainingBytes *int64 `type:"int64" json:",omitempty"`

	RemainingObjects *int64 `type:"int64" json:",omitempty"`

	SkipBytes *int64 `type:"int64" json:",omitempty"`

	SkipObjectCount *int64 `type:"int64" json:",omitempty"`

	TotalBytes *int64 `type:"int64" json:",omitempty"`

	TotalObjects *int64 `type:"int64" json:",omitempty"`

	TransferBytesSpeed *int64 `type:"int64" json:",omitempty"`

	TransferCountSpeed *int64 `type:"int64" json:",omitempty"`

	TransferredBytes *int64 `type:"int64" json:",omitempty"`

	TransferredObjects *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s TaskProgressForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskProgressForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetFailedBytes sets the FailedBytes field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetFailedBytes(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.FailedBytes = &v
	return s
}

// SetFailedObjects sets the FailedObjects field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetFailedObjects(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.FailedObjects = &v
	return s
}

// SetNotExistBytes sets the NotExistBytes field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetNotExistBytes(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.NotExistBytes = &v
	return s
}

// SetNotExistObjectCount sets the NotExistObjectCount field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetNotExistObjectCount(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.NotExistObjectCount = &v
	return s
}

// SetRemainingBytes sets the RemainingBytes field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetRemainingBytes(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.RemainingBytes = &v
	return s
}

// SetRemainingObjects sets the RemainingObjects field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetRemainingObjects(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.RemainingObjects = &v
	return s
}

// SetSkipBytes sets the SkipBytes field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetSkipBytes(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.SkipBytes = &v
	return s
}

// SetSkipObjectCount sets the SkipObjectCount field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetSkipObjectCount(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.SkipObjectCount = &v
	return s
}

// SetTotalBytes sets the TotalBytes field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetTotalBytes(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.TotalBytes = &v
	return s
}

// SetTotalObjects sets the TotalObjects field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetTotalObjects(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.TotalObjects = &v
	return s
}

// SetTransferBytesSpeed sets the TransferBytesSpeed field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetTransferBytesSpeed(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.TransferBytesSpeed = &v
	return s
}

// SetTransferCountSpeed sets the TransferCountSpeed field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetTransferCountSpeed(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.TransferCountSpeed = &v
	return s
}

// SetTransferredBytes sets the TransferredBytes field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetTransferredBytes(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.TransferredBytes = &v
	return s
}

// SetTransferredObjects sets the TransferredObjects field's value.
func (s *TaskProgressForQueryDataMigrateTaskOutput) SetTransferredObjects(v int64) *TaskProgressForQueryDataMigrateTaskOutput {
	s.TransferredObjects = &v
	return s
}

type TaskReportForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FailedListName *string `type:"string" json:",omitempty"`

	ReportName *string `type:"string" json:",omitempty"`

	SuccessListName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TaskReportForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskReportForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetFailedListName sets the FailedListName field's value.
func (s *TaskReportForQueryDataMigrateTaskOutput) SetFailedListName(v string) *TaskReportForQueryDataMigrateTaskOutput {
	s.FailedListName = &v
	return s
}

// SetReportName sets the ReportName field's value.
func (s *TaskReportForQueryDataMigrateTaskOutput) SetReportName(v string) *TaskReportForQueryDataMigrateTaskOutput {
	s.ReportName = &v
	return s
}

// SetSuccessListName sets the SuccessListName field's value.
func (s *TaskReportForQueryDataMigrateTaskOutput) SetSuccessListName(v string) *TaskReportForQueryDataMigrateTaskOutput {
	s.SuccessListName = &v
	return s
}

type TimeBandwidthSettingForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bandwidth *int64 `max:"1.073741824e+09" type:"int64" json:",omitempty"`

	End *int32 `min:"1" max:"24" type:"int32" json:",omitempty"`

	Start *int32 `max:"23" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s TimeBandwidthSettingForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeBandwidthSettingForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *TimeBandwidthSettingForQueryDataMigrateTaskOutput) SetBandwidth(v int64) *TimeBandwidthSettingForQueryDataMigrateTaskOutput {
	s.Bandwidth = &v
	return s
}

// SetEnd sets the End field's value.
func (s *TimeBandwidthSettingForQueryDataMigrateTaskOutput) SetEnd(v int32) *TimeBandwidthSettingForQueryDataMigrateTaskOutput {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *TimeBandwidthSettingForQueryDataMigrateTaskOutput) SetStart(v int32) *TimeBandwidthSettingForQueryDataMigrateTaskOutput {
	s.Start = &v
	return s
}

type UrlSourceConfigForQueryDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BucketAccessConfig *BucketAccessConfigForQueryDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	IsUrlTryRangeGet *bool `type:"boolean" json:",omitempty"`

	UrlListLink *string `type:"string" json:",omitempty"`

	UrlListName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UrlSourceConfigForQueryDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlSourceConfigForQueryDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetBucketAccessConfig sets the BucketAccessConfig field's value.
func (s *UrlSourceConfigForQueryDataMigrateTaskOutput) SetBucketAccessConfig(v *BucketAccessConfigForQueryDataMigrateTaskOutput) *UrlSourceConfigForQueryDataMigrateTaskOutput {
	s.BucketAccessConfig = v
	return s
}

// SetIsUrlTryRangeGet sets the IsUrlTryRangeGet field's value.
func (s *UrlSourceConfigForQueryDataMigrateTaskOutput) SetIsUrlTryRangeGet(v bool) *UrlSourceConfigForQueryDataMigrateTaskOutput {
	s.IsUrlTryRangeGet = &v
	return s
}

// SetUrlListLink sets the UrlListLink field's value.
func (s *UrlSourceConfigForQueryDataMigrateTaskOutput) SetUrlListLink(v string) *UrlSourceConfigForQueryDataMigrateTaskOutput {
	s.UrlListLink = &v
	return s
}

// SetUrlListName sets the UrlListName field's value.
func (s *UrlSourceConfigForQueryDataMigrateTaskOutput) SetUrlListName(v string) *UrlSourceConfigForQueryDataMigrateTaskOutput {
	s.UrlListName = &v
	return s
}

const (
	// EnumOfOverwritePolicyForQueryDataMigrateTaskOutputForce is a EnumOfOverwritePolicyForQueryDataMigrateTaskOutput enum value
	EnumOfOverwritePolicyForQueryDataMigrateTaskOutputForce = "Force"

	// EnumOfOverwritePolicyForQueryDataMigrateTaskOutputNone is a EnumOfOverwritePolicyForQueryDataMigrateTaskOutput enum value
	EnumOfOverwritePolicyForQueryDataMigrateTaskOutputNone = "None"

	// EnumOfOverwritePolicyForQueryDataMigrateTaskOutputLastModify is a EnumOfOverwritePolicyForQueryDataMigrateTaskOutput enum value
	EnumOfOverwritePolicyForQueryDataMigrateTaskOutputLastModify = "LastModify"
)

const (
	// EnumOfSourceTypeForQueryDataMigrateTaskOutputStorageTypeObject is a EnumOfSourceTypeForQueryDataMigrateTaskOutput enum value
	EnumOfSourceTypeForQueryDataMigrateTaskOutputStorageTypeObject = "StorageTypeObject"

	// EnumOfSourceTypeForQueryDataMigrateTaskOutputStorageTypeUrl is a EnumOfSourceTypeForQueryDataMigrateTaskOutput enum value
	EnumOfSourceTypeForQueryDataMigrateTaskOutputStorageTypeUrl = "StorageTypeUrl"
)

const (
	// EnumOfStorageClassForQueryDataMigrateTaskOutputStandard is a EnumOfStorageClassForQueryDataMigrateTaskOutput enum value
	EnumOfStorageClassForQueryDataMigrateTaskOutputStandard = "Standard"

	// EnumOfStorageClassForQueryDataMigrateTaskOutputInheritSource is a EnumOfStorageClassForQueryDataMigrateTaskOutput enum value
	EnumOfStorageClassForQueryDataMigrateTaskOutputInheritSource = "InheritSource"

	// EnumOfStorageClassForQueryDataMigrateTaskOutputIa is a EnumOfStorageClassForQueryDataMigrateTaskOutput enum value
	EnumOfStorageClassForQueryDataMigrateTaskOutputIa = "Ia"

	// EnumOfStorageClassForQueryDataMigrateTaskOutputArchiveFr is a EnumOfStorageClassForQueryDataMigrateTaskOutput enum value
	EnumOfStorageClassForQueryDataMigrateTaskOutputArchiveFr = "ArchiveFr"

	// EnumOfStorageClassForQueryDataMigrateTaskOutputIntelligentTiering is a EnumOfStorageClassForQueryDataMigrateTaskOutput enum value
	EnumOfStorageClassForQueryDataMigrateTaskOutputIntelligentTiering = "IntelligentTiering"

	// EnumOfStorageClassForQueryDataMigrateTaskOutputColdArchive is a EnumOfStorageClassForQueryDataMigrateTaskOutput enum value
	EnumOfStorageClassForQueryDataMigrateTaskOutputColdArchive = "ColdArchive"

	// EnumOfStorageClassForQueryDataMigrateTaskOutputArchive is a EnumOfStorageClassForQueryDataMigrateTaskOutput enum value
	EnumOfStorageClassForQueryDataMigrateTaskOutputArchive = "Archive"

	// EnumOfStorageClassForQueryDataMigrateTaskOutputDeepColdArchive is a EnumOfStorageClassForQueryDataMigrateTaskOutput enum value
	EnumOfStorageClassForQueryDataMigrateTaskOutputDeepColdArchive = "DeepColdArchive"
)
