// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package alb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCloneLoadBalancerCommon = "CloneLoadBalancer"

// CloneLoadBalancerCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CloneLoadBalancerCommon operation. The "output" return
// value will be populated with the CloneLoadBalancerCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CloneLoadBalancerCommon Request to send the API call to the service.
// the "output" return value is not valid until after CloneLoadBalancerCommon Send returns without error.
//
// See CloneLoadBalancerCommon for more information on using the CloneLoadBalancerCommon
// API call, and error handling.
//
//    // Example sending a request using the CloneLoadBalancerCommonRequest method.
//    req, resp := client.CloneLoadBalancerCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) CloneLoadBalancerCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCloneLoadBalancerCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CloneLoadBalancerCommon API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation CloneLoadBalancerCommon for usage and error information.
func (c *ALB) CloneLoadBalancerCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CloneLoadBalancerCommonRequest(input)
	return out, req.Send()
}

// CloneLoadBalancerCommonWithContext is the same as CloneLoadBalancerCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CloneLoadBalancerCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) CloneLoadBalancerCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CloneLoadBalancerCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCloneLoadBalancer = "CloneLoadBalancer"

// CloneLoadBalancerRequest generates a "volcengine/request.Request" representing the
// client's request for the CloneLoadBalancer operation. The "output" return
// value will be populated with the CloneLoadBalancerCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CloneLoadBalancerCommon Request to send the API call to the service.
// the "output" return value is not valid until after CloneLoadBalancerCommon Send returns without error.
//
// See CloneLoadBalancer for more information on using the CloneLoadBalancer
// API call, and error handling.
//
//    // Example sending a request using the CloneLoadBalancerRequest method.
//    req, resp := client.CloneLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) CloneLoadBalancerRequest(input *CloneLoadBalancerInput) (req *request.Request, output *CloneLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opCloneLoadBalancer,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloneLoadBalancerInput{}
	}

	output = &CloneLoadBalancerOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CloneLoadBalancer API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation CloneLoadBalancer for usage and error information.
func (c *ALB) CloneLoadBalancer(input *CloneLoadBalancerInput) (*CloneLoadBalancerOutput, error) {
	req, out := c.CloneLoadBalancerRequest(input)
	return out, req.Send()
}

// CloneLoadBalancerWithContext is the same as CloneLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See CloneLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) CloneLoadBalancerWithContext(ctx volcengine.Context, input *CloneLoadBalancerInput, opts ...request.Option) (*CloneLoadBalancerOutput, error) {
	req, out := c.CloneLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CloneLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	BandwidthPackageId *string `type:"string"`

	DeleteProtection *string `type:"string"`

	Description *string `type:"string"`

	EipBillingConfig *EipBillingConfigForCloneLoadBalancerInput `type:"structure"`

	Ipv6EipBillingConfig *Ipv6EipBillingConfigForCloneLoadBalancerInput `type:"structure"`

	// LoadBalancerID is a required field
	LoadBalancerID *string `type:"string" required:"true"`

	LoadBalancerName *string `type:"string"`

	ProjectName *string `type:"string"`

	// RegionId is a required field
	RegionId *string `type:"string" required:"true"`

	ZoneMappings []*ZoneMappingForCloneLoadBalancerInput `type:"list"`
}

// String returns the string representation
func (s CloneLoadBalancerInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CloneLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloneLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloneLoadBalancerInput"}
	if s.LoadBalancerID == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerID"))
	}
	if s.RegionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidthPackageId sets the BandwidthPackageId field's value.
func (s *CloneLoadBalancerInput) SetBandwidthPackageId(v string) *CloneLoadBalancerInput {
	s.BandwidthPackageId = &v
	return s
}

// SetDeleteProtection sets the DeleteProtection field's value.
func (s *CloneLoadBalancerInput) SetDeleteProtection(v string) *CloneLoadBalancerInput {
	s.DeleteProtection = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CloneLoadBalancerInput) SetDescription(v string) *CloneLoadBalancerInput {
	s.Description = &v
	return s
}

// SetEipBillingConfig sets the EipBillingConfig field's value.
func (s *CloneLoadBalancerInput) SetEipBillingConfig(v *EipBillingConfigForCloneLoadBalancerInput) *CloneLoadBalancerInput {
	s.EipBillingConfig = v
	return s
}

// SetIpv6EipBillingConfig sets the Ipv6EipBillingConfig field's value.
func (s *CloneLoadBalancerInput) SetIpv6EipBillingConfig(v *Ipv6EipBillingConfigForCloneLoadBalancerInput) *CloneLoadBalancerInput {
	s.Ipv6EipBillingConfig = v
	return s
}

// SetLoadBalancerID sets the LoadBalancerID field's value.
func (s *CloneLoadBalancerInput) SetLoadBalancerID(v string) *CloneLoadBalancerInput {
	s.LoadBalancerID = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *CloneLoadBalancerInput) SetLoadBalancerName(v string) *CloneLoadBalancerInput {
	s.LoadBalancerName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CloneLoadBalancerInput) SetProjectName(v string) *CloneLoadBalancerInput {
	s.ProjectName = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *CloneLoadBalancerInput) SetRegionId(v string) *CloneLoadBalancerInput {
	s.RegionId = &v
	return s
}

// SetZoneMappings sets the ZoneMappings field's value.
func (s *CloneLoadBalancerInput) SetZoneMappings(v []*ZoneMappingForCloneLoadBalancerInput) *CloneLoadBalancerInput {
	s.ZoneMappings = v
	return s
}

type CloneLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	LoadBalancerId *string `type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CloneLoadBalancerOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CloneLoadBalancerOutput) GoString() string {
	return s.String()
}

// SetLoadBalancerId sets the LoadBalancerId field's value.
func (s *CloneLoadBalancerOutput) SetLoadBalancerId(v string) *CloneLoadBalancerOutput {
	s.LoadBalancerId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CloneLoadBalancerOutput) SetRequestId(v string) *CloneLoadBalancerOutput {
	s.RequestId = &v
	return s
}

type EipBillingConfigForCloneLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	Bandwidth *int64 `type:"integer"`

	EipBillingType *int64 `type:"integer"`

	ISP *string `type:"string"`
}

// String returns the string representation
func (s EipBillingConfigForCloneLoadBalancerInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EipBillingConfigForCloneLoadBalancerInput) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *EipBillingConfigForCloneLoadBalancerInput) SetBandwidth(v int64) *EipBillingConfigForCloneLoadBalancerInput {
	s.Bandwidth = &v
	return s
}

// SetEipBillingType sets the EipBillingType field's value.
func (s *EipBillingConfigForCloneLoadBalancerInput) SetEipBillingType(v int64) *EipBillingConfigForCloneLoadBalancerInput {
	s.EipBillingType = &v
	return s
}

// SetISP sets the ISP field's value.
func (s *EipBillingConfigForCloneLoadBalancerInput) SetISP(v string) *EipBillingConfigForCloneLoadBalancerInput {
	s.ISP = &v
	return s
}

type Ipv6EipBillingConfigForCloneLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	Bandwidth *int64 `type:"integer"`

	BillingType *int64 `type:"integer"`

	ISP *string `type:"string"`
}

// String returns the string representation
func (s Ipv6EipBillingConfigForCloneLoadBalancerInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s Ipv6EipBillingConfigForCloneLoadBalancerInput) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *Ipv6EipBillingConfigForCloneLoadBalancerInput) SetBandwidth(v int64) *Ipv6EipBillingConfigForCloneLoadBalancerInput {
	s.Bandwidth = &v
	return s
}

// SetBillingType sets the BillingType field's value.
func (s *Ipv6EipBillingConfigForCloneLoadBalancerInput) SetBillingType(v int64) *Ipv6EipBillingConfigForCloneLoadBalancerInput {
	s.BillingType = &v
	return s
}

// SetISP sets the ISP field's value.
func (s *Ipv6EipBillingConfigForCloneLoadBalancerInput) SetISP(v string) *Ipv6EipBillingConfigForCloneLoadBalancerInput {
	s.ISP = &v
	return s
}

type ZoneMappingForCloneLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	SubnetId *string `type:"string"`

	ZoneId *string `type:"string"`
}

// String returns the string representation
func (s ZoneMappingForCloneLoadBalancerInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ZoneMappingForCloneLoadBalancerInput) GoString() string {
	return s.String()
}

// SetSubnetId sets the SubnetId field's value.
func (s *ZoneMappingForCloneLoadBalancerInput) SetSubnetId(v string) *ZoneMappingForCloneLoadBalancerInput {
	s.SubnetId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ZoneMappingForCloneLoadBalancerInput) SetZoneId(v string) *ZoneMappingForCloneLoadBalancerInput {
	s.ZoneId = &v
	return s
}
