// Copyright Project Harbor Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Package store is only used in the internal implement of manager, not a public api.
package store

import "context"

// Driver the interface to save/load config
type Driver interface {
	// Load - load config item from config driver
	Load(ctx context.Context) (map[string]any, error)
	// Save - save config item into config driver
	Save(ctx context.Context, cfg map[string]any) error
	// Get - get config item from config driver
	Get(ctx context.Context, key string) (map[string]any, error)
}
