// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateSecurityGroupCommon = "CreateSecurityGroup"

// CreateSecurityGroupCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateSecurityGroupCommon operation. The "output" return
// value will be populated with the CreateSecurityGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateSecurityGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateSecurityGroupCommon Send returns without error.
//
// See CreateSecurityGroupCommon for more information on using the CreateSecurityGroupCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateSecurityGroupCommonRequest method.
//    req, resp := client.CreateSecurityGroupCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) CreateSecurityGroupCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateSecurityGroupCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateSecurityGroupCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation CreateSecurityGroupCommon for usage and error information.
func (c *VPC) CreateSecurityGroupCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateSecurityGroupCommonRequest(input)
	return out, req.Send()
}

// CreateSecurityGroupCommonWithContext is the same as CreateSecurityGroupCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecurityGroupCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) CreateSecurityGroupCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateSecurityGroupCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecurityGroup = "CreateSecurityGroup"

// CreateSecurityGroupRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateSecurityGroup operation. The "output" return
// value will be populated with the CreateSecurityGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateSecurityGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateSecurityGroupCommon Send returns without error.
//
// See CreateSecurityGroup for more information on using the CreateSecurityGroup
// API call, and error handling.
//
//    // Example sending a request using the CreateSecurityGroupRequest method.
//    req, resp := client.CreateSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) CreateSecurityGroupRequest(input *CreateSecurityGroupInput) (req *request.Request, output *CreateSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecurityGroupInput{}
	}

	output = &CreateSecurityGroupOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateSecurityGroup API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation CreateSecurityGroup for usage and error information.
func (c *VPC) CreateSecurityGroup(input *CreateSecurityGroupInput) (*CreateSecurityGroupOutput, error) {
	req, out := c.CreateSecurityGroupRequest(input)
	return out, req.Send()
}

// CreateSecurityGroupWithContext is the same as CreateSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) CreateSecurityGroupWithContext(ctx volcengine.Context, input *CreateSecurityGroupInput, opts ...request.Option) (*CreateSecurityGroupOutput, error) {
	req, out := c.CreateSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `type:"string"`

	Description *string `type:"string"`

	ProjectName *string `type:"string"`

	SecurityGroupName *string `type:"string"`

	Tags []*TagForCreateSecurityGroupInput `type:"list"`

	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSecurityGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecurityGroupInput"}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSecurityGroupInput) SetClientToken(v string) *CreateSecurityGroupInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSecurityGroupInput) SetDescription(v string) *CreateSecurityGroupInput {
	s.Description = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateSecurityGroupInput) SetProjectName(v string) *CreateSecurityGroupInput {
	s.ProjectName = &v
	return s
}

// SetSecurityGroupName sets the SecurityGroupName field's value.
func (s *CreateSecurityGroupInput) SetSecurityGroupName(v string) *CreateSecurityGroupInput {
	s.SecurityGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSecurityGroupInput) SetTags(v []*TagForCreateSecurityGroupInput) *CreateSecurityGroupInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateSecurityGroupInput) SetVpcId(v string) *CreateSecurityGroupInput {
	s.VpcId = &v
	return s
}

type CreateSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`

	SecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s CreateSecurityGroupOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *CreateSecurityGroupOutput) SetRequestId(v string) *CreateSecurityGroupOutput {
	s.RequestId = &v
	return s
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *CreateSecurityGroupOutput) SetSecurityGroupId(v string) *CreateSecurityGroupOutput {
	s.SecurityGroupId = &v
	return s
}

type TagForCreateSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateSecurityGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateSecurityGroupInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateSecurityGroupInput) SetKey(v string) *TagForCreateSecurityGroupInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateSecurityGroupInput) SetValue(v string) *TagForCreateSecurityGroupInput {
	s.Value = &v
	return s
}
