// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opSelectNumberAndBindAXNCommon = "SelectNumberAndBindAXN"

// SelectNumberAndBindAXNCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the SelectNumberAndBindAXNCommon operation. The "output" return
// value will be populated with the SelectNumberAndBindAXNCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned SelectNumberAndBindAXNCommon Request to send the API call to the service.
// the "output" return value is not valid until after SelectNumberAndBindAXNCommon Send returns without error.
//
// See SelectNumberAndBindAXNCommon for more information on using the SelectNumberAndBindAXNCommon
// API call, and error handling.
//
//    // Example sending a request using the SelectNumberAndBindAXNCommonRequest method.
//    req, resp := client.SelectNumberAndBindAXNCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) SelectNumberAndBindAXNCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opSelectNumberAndBindAXNCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// SelectNumberAndBindAXNCommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation SelectNumberAndBindAXNCommon for usage and error information.
func (c *VMS) SelectNumberAndBindAXNCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.SelectNumberAndBindAXNCommonRequest(input)
	return out, req.Send()
}

// SelectNumberAndBindAXNCommonWithContext is the same as SelectNumberAndBindAXNCommon with the addition of
// the ability to pass a context and additional request options.
//
// See SelectNumberAndBindAXNCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) SelectNumberAndBindAXNCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.SelectNumberAndBindAXNCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSelectNumberAndBindAXN = "SelectNumberAndBindAXN"

// SelectNumberAndBindAXNRequest generates a "volcengine/request.Request" representing the
// client's request for the SelectNumberAndBindAXN operation. The "output" return
// value will be populated with the SelectNumberAndBindAXNCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned SelectNumberAndBindAXNCommon Request to send the API call to the service.
// the "output" return value is not valid until after SelectNumberAndBindAXNCommon Send returns without error.
//
// See SelectNumberAndBindAXN for more information on using the SelectNumberAndBindAXN
// API call, and error handling.
//
//    // Example sending a request using the SelectNumberAndBindAXNRequest method.
//    req, resp := client.SelectNumberAndBindAXNRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) SelectNumberAndBindAXNRequest(input *SelectNumberAndBindAXNInput) (req *request.Request, output *SelectNumberAndBindAXNOutput) {
	op := &request.Operation{
		Name:       opSelectNumberAndBindAXN,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SelectNumberAndBindAXNInput{}
	}

	output = &SelectNumberAndBindAXNOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// SelectNumberAndBindAXN API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation SelectNumberAndBindAXN for usage and error information.
func (c *VMS) SelectNumberAndBindAXN(input *SelectNumberAndBindAXNInput) (*SelectNumberAndBindAXNOutput, error) {
	req, out := c.SelectNumberAndBindAXNRequest(input)
	return out, req.Send()
}

// SelectNumberAndBindAXNWithContext is the same as SelectNumberAndBindAXN with the addition of
// the ability to pass a context and additional request options.
//
// See SelectNumberAndBindAXN for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) SelectNumberAndBindAXNWithContext(ctx volcengine.Context, input *SelectNumberAndBindAXNInput, opts ...request.Option) (*SelectNumberAndBindAXNOutput, error) {
	req, out := c.SelectNumberAndBindAXNRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type SelectNumberAndBindAXNInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AudioRecordFlag *int32 `type:"int32" json:",omitempty"`

	CityCode *string `type:"string" json:",omitempty"`

	CityCodeByPhoneNo *string `type:"string" json:",omitempty" enum:"EnumOfCityCodeByPhoneNoForSelectNumberAndBindAXNInput"`

	DegradeCityList []*string `type:"list" json:",omitempty"`

	// ExpireTime is a required field
	ExpireTime *int64 `type:"int64" json:",omitempty" required:"true"`

	// NumberPoolNo is a required field
	NumberPoolNo *string `type:"string" json:",omitempty" required:"true"`

	// PhoneNoA is a required field
	PhoneNoA *string `type:"string" json:",omitempty" required:"true"`

	PhoneNoB *string `type:"string" json:",omitempty"`

	RandomFlag *int32 `type:"int32" json:",omitempty"`

	UserData *string `max:"2048" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SelectNumberAndBindAXNInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectNumberAndBindAXNInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectNumberAndBindAXNInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelectNumberAndBindAXNInput"}
	if s.ExpireTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpireTime"))
	}
	if s.NumberPoolNo == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberPoolNo"))
	}
	if s.PhoneNoA == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNoA"))
	}
	if s.UserData != nil && len(*s.UserData) > 2048 {
		invalidParams.Add(request.NewErrParamMaxLen("UserData", 2048, *s.UserData))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioRecordFlag sets the AudioRecordFlag field's value.
func (s *SelectNumberAndBindAXNInput) SetAudioRecordFlag(v int32) *SelectNumberAndBindAXNInput {
	s.AudioRecordFlag = &v
	return s
}

// SetCityCode sets the CityCode field's value.
func (s *SelectNumberAndBindAXNInput) SetCityCode(v string) *SelectNumberAndBindAXNInput {
	s.CityCode = &v
	return s
}

// SetCityCodeByPhoneNo sets the CityCodeByPhoneNo field's value.
func (s *SelectNumberAndBindAXNInput) SetCityCodeByPhoneNo(v string) *SelectNumberAndBindAXNInput {
	s.CityCodeByPhoneNo = &v
	return s
}

// SetDegradeCityList sets the DegradeCityList field's value.
func (s *SelectNumberAndBindAXNInput) SetDegradeCityList(v []*string) *SelectNumberAndBindAXNInput {
	s.DegradeCityList = v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *SelectNumberAndBindAXNInput) SetExpireTime(v int64) *SelectNumberAndBindAXNInput {
	s.ExpireTime = &v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *SelectNumberAndBindAXNInput) SetNumberPoolNo(v string) *SelectNumberAndBindAXNInput {
	s.NumberPoolNo = &v
	return s
}

// SetPhoneNoA sets the PhoneNoA field's value.
func (s *SelectNumberAndBindAXNInput) SetPhoneNoA(v string) *SelectNumberAndBindAXNInput {
	s.PhoneNoA = &v
	return s
}

// SetPhoneNoB sets the PhoneNoB field's value.
func (s *SelectNumberAndBindAXNInput) SetPhoneNoB(v string) *SelectNumberAndBindAXNInput {
	s.PhoneNoB = &v
	return s
}

// SetRandomFlag sets the RandomFlag field's value.
func (s *SelectNumberAndBindAXNInput) SetRandomFlag(v int32) *SelectNumberAndBindAXNInput {
	s.RandomFlag = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *SelectNumberAndBindAXNInput) SetUserData(v string) *SelectNumberAndBindAXNInput {
	s.UserData = &v
	return s
}

type SelectNumberAndBindAXNOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PhoneNoA *string `type:"string" json:",omitempty"`

	PhoneNoACityCode *string `type:"string" json:",omitempty"`

	PhoneNoB *string `type:"string" json:",omitempty"`

	PhoneNoBCityCode *string `type:"string" json:",omitempty"`

	PhoneNoX *string `type:"string" json:",omitempty"`

	PhoneNoXCityCode *string `type:"string" json:",omitempty"`

	Status *int32 `type:"int32" json:",omitempty"`

	SubId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SelectNumberAndBindAXNOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectNumberAndBindAXNOutput) GoString() string {
	return s.String()
}

// SetPhoneNoA sets the PhoneNoA field's value.
func (s *SelectNumberAndBindAXNOutput) SetPhoneNoA(v string) *SelectNumberAndBindAXNOutput {
	s.PhoneNoA = &v
	return s
}

// SetPhoneNoACityCode sets the PhoneNoACityCode field's value.
func (s *SelectNumberAndBindAXNOutput) SetPhoneNoACityCode(v string) *SelectNumberAndBindAXNOutput {
	s.PhoneNoACityCode = &v
	return s
}

// SetPhoneNoB sets the PhoneNoB field's value.
func (s *SelectNumberAndBindAXNOutput) SetPhoneNoB(v string) *SelectNumberAndBindAXNOutput {
	s.PhoneNoB = &v
	return s
}

// SetPhoneNoBCityCode sets the PhoneNoBCityCode field's value.
func (s *SelectNumberAndBindAXNOutput) SetPhoneNoBCityCode(v string) *SelectNumberAndBindAXNOutput {
	s.PhoneNoBCityCode = &v
	return s
}

// SetPhoneNoX sets the PhoneNoX field's value.
func (s *SelectNumberAndBindAXNOutput) SetPhoneNoX(v string) *SelectNumberAndBindAXNOutput {
	s.PhoneNoX = &v
	return s
}

// SetPhoneNoXCityCode sets the PhoneNoXCityCode field's value.
func (s *SelectNumberAndBindAXNOutput) SetPhoneNoXCityCode(v string) *SelectNumberAndBindAXNOutput {
	s.PhoneNoXCityCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SelectNumberAndBindAXNOutput) SetStatus(v int32) *SelectNumberAndBindAXNOutput {
	s.Status = &v
	return s
}

// SetSubId sets the SubId field's value.
func (s *SelectNumberAndBindAXNOutput) SetSubId(v string) *SelectNumberAndBindAXNOutput {
	s.SubId = &v
	return s
}

const (
	// EnumOfCityCodeByPhoneNoForSelectNumberAndBindAXNInputA is a EnumOfCityCodeByPhoneNoForSelectNumberAndBindAXNInput enum value
	EnumOfCityCodeByPhoneNoForSelectNumberAndBindAXNInputA = "A"

	// EnumOfCityCodeByPhoneNoForSelectNumberAndBindAXNInputB is a EnumOfCityCodeByPhoneNoForSelectNumberAndBindAXNInput enum value
	EnumOfCityCodeByPhoneNoForSelectNumberAndBindAXNInputB = "B"
)
