// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vke

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGrantPermissionCommon = "GrantPermission"

// GrantPermissionCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GrantPermissionCommon operation. The "output" return
// value will be populated with the GrantPermissionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GrantPermissionCommon Request to send the API call to the service.
// the "output" return value is not valid until after GrantPermissionCommon Send returns without error.
//
// See GrantPermissionCommon for more information on using the GrantPermissionCommon
// API call, and error handling.
//
//    // Example sending a request using the GrantPermissionCommonRequest method.
//    req, resp := client.GrantPermissionCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) GrantPermissionCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGrantPermissionCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GrantPermissionCommon API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation GrantPermissionCommon for usage and error information.
func (c *VKE) GrantPermissionCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GrantPermissionCommonRequest(input)
	return out, req.Send()
}

// GrantPermissionCommonWithContext is the same as GrantPermissionCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GrantPermissionCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) GrantPermissionCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GrantPermissionCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGrantPermission = "GrantPermission"

// GrantPermissionRequest generates a "volcengine/request.Request" representing the
// client's request for the GrantPermission operation. The "output" return
// value will be populated with the GrantPermissionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GrantPermissionCommon Request to send the API call to the service.
// the "output" return value is not valid until after GrantPermissionCommon Send returns without error.
//
// See GrantPermission for more information on using the GrantPermission
// API call, and error handling.
//
//    // Example sending a request using the GrantPermissionRequest method.
//    req, resp := client.GrantPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) GrantPermissionRequest(input *GrantPermissionInput) (req *request.Request, output *GrantPermissionOutput) {
	op := &request.Operation{
		Name:       opGrantPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GrantPermissionInput{}
	}

	output = &GrantPermissionOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GrantPermission API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation GrantPermission for usage and error information.
func (c *VKE) GrantPermission(input *GrantPermissionInput) (*GrantPermissionOutput, error) {
	req, out := c.GrantPermissionRequest(input)
	return out, req.Send()
}

// GrantPermissionWithContext is the same as GrantPermission with the addition of
// the ability to pass a context and additional request options.
//
// See GrantPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) GrantPermissionWithContext(ctx volcengine.Context, input *GrantPermissionInput, opts ...request.Option) (*GrantPermissionOutput, error) {
	req, out := c.GrantPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type GrantPermissionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClusterId *string `type:"string" json:",omitempty"`

	GranteeId *int64 `type:"int64" json:",omitempty"`

	GranteeType *string `type:"string" json:",omitempty" enum:"EnumOfGranteeTypeForGrantPermissionInput"`

	IsCustomRole *bool `type:"boolean" json:",omitempty"`

	Namespace *string `type:"string" json:",omitempty"`

	RoleDomain *string `type:"string" json:",omitempty"`

	RoleName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GrantPermissionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantPermissionInput) GoString() string {
	return s.String()
}

// SetClusterId sets the ClusterId field's value.
func (s *GrantPermissionInput) SetClusterId(v string) *GrantPermissionInput {
	s.ClusterId = &v
	return s
}

// SetGranteeId sets the GranteeId field's value.
func (s *GrantPermissionInput) SetGranteeId(v int64) *GrantPermissionInput {
	s.GranteeId = &v
	return s
}

// SetGranteeType sets the GranteeType field's value.
func (s *GrantPermissionInput) SetGranteeType(v string) *GrantPermissionInput {
	s.GranteeType = &v
	return s
}

// SetIsCustomRole sets the IsCustomRole field's value.
func (s *GrantPermissionInput) SetIsCustomRole(v bool) *GrantPermissionInput {
	s.IsCustomRole = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GrantPermissionInput) SetNamespace(v string) *GrantPermissionInput {
	s.Namespace = &v
	return s
}

// SetRoleDomain sets the RoleDomain field's value.
func (s *GrantPermissionInput) SetRoleDomain(v string) *GrantPermissionInput {
	s.RoleDomain = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *GrantPermissionInput) SetRoleName(v string) *GrantPermissionInput {
	s.RoleName = &v
	return s
}

type GrantPermissionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GrantPermissionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantPermissionOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *GrantPermissionOutput) SetId(v string) *GrantPermissionOutput {
	s.Id = &v
	return s
}

const (
	// EnumOfGranteeTypeForGrantPermissionInputUser is a EnumOfGranteeTypeForGrantPermissionInput enum value
	EnumOfGranteeTypeForGrantPermissionInputUser = "User"

	// EnumOfGranteeTypeForGrantPermissionInputRole is a EnumOfGranteeTypeForGrantPermissionInput enum value
	EnumOfGranteeTypeForGrantPermissionInputRole = "Role"

	// EnumOfGranteeTypeForGrantPermissionInputAccount is a EnumOfGranteeTypeForGrantPermissionInput enum value
	EnumOfGranteeTypeForGrantPermissionInputAccount = "Account"
)
