// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vepfs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeFileSystemsCommon = "DescribeFileSystems"

// DescribeFileSystemsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeFileSystemsCommon operation. The "output" return
// value will be populated with the DescribeFileSystemsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeFileSystemsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeFileSystemsCommon Send returns without error.
//
// See DescribeFileSystemsCommon for more information on using the DescribeFileSystemsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeFileSystemsCommonRequest method.
//    req, resp := client.DescribeFileSystemsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) DescribeFileSystemsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeFileSystemsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeFileSystemsCommon API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation DescribeFileSystemsCommon for usage and error information.
func (c *VEPFS) DescribeFileSystemsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeFileSystemsCommonRequest(input)
	return out, req.Send()
}

// DescribeFileSystemsCommonWithContext is the same as DescribeFileSystemsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFileSystemsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) DescribeFileSystemsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeFileSystemsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFileSystems = "DescribeFileSystems"

// DescribeFileSystemsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeFileSystems operation. The "output" return
// value will be populated with the DescribeFileSystemsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeFileSystemsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeFileSystemsCommon Send returns without error.
//
// See DescribeFileSystems for more information on using the DescribeFileSystems
// API call, and error handling.
//
//    // Example sending a request using the DescribeFileSystemsRequest method.
//    req, resp := client.DescribeFileSystemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) DescribeFileSystemsRequest(input *DescribeFileSystemsInput) (req *request.Request, output *DescribeFileSystemsOutput) {
	op := &request.Operation{
		Name:       opDescribeFileSystems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFileSystemsInput{}
	}

	output = &DescribeFileSystemsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeFileSystems API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation DescribeFileSystems for usage and error information.
func (c *VEPFS) DescribeFileSystems(input *DescribeFileSystemsInput) (*DescribeFileSystemsOutput, error) {
	req, out := c.DescribeFileSystemsRequest(input)
	return out, req.Send()
}

// DescribeFileSystemsWithContext is the same as DescribeFileSystems with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFileSystems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) DescribeFileSystemsWithContext(ctx volcengine.Context, input *DescribeFileSystemsInput, opts ...request.Option) (*DescribeFileSystemsOutput, error) {
	req, out := c.DescribeFileSystemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CapacityInfoForDescribeFileSystemsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	TotalTiB *int32 `type:"int32" json:",omitempty"`

	UsedGiB *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s CapacityInfoForDescribeFileSystemsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CapacityInfoForDescribeFileSystemsOutput) GoString() string {
	return s.String()
}

// SetTotalTiB sets the TotalTiB field's value.
func (s *CapacityInfoForDescribeFileSystemsOutput) SetTotalTiB(v int32) *CapacityInfoForDescribeFileSystemsOutput {
	s.TotalTiB = &v
	return s
}

// SetUsedGiB sets the UsedGiB field's value.
func (s *CapacityInfoForDescribeFileSystemsOutput) SetUsedGiB(v int32) *CapacityInfoForDescribeFileSystemsOutput {
	s.UsedGiB = &v
	return s
}

type DescribeFileSystemsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemIds *string `type:"string" json:",omitempty"`

	Filters []*FilterForDescribeFileSystemsInput `type:"list" json:",omitempty"`

	LanguageCode *string `type:"string" json:",omitempty" enum:"EnumOfLanguageCodeForDescribeFileSystemsInput"`

	OrderBy *string `type:"string" json:",omitempty" enum:"EnumOfOrderByForDescribeFileSystemsInput"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	Project *string `type:"string" json:",omitempty"`

	TagFilters []*TagFilterForDescribeFileSystemsInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DescribeFileSystemsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFileSystemsInput) GoString() string {
	return s.String()
}

// SetFileSystemIds sets the FileSystemIds field's value.
func (s *DescribeFileSystemsInput) SetFileSystemIds(v string) *DescribeFileSystemsInput {
	s.FileSystemIds = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeFileSystemsInput) SetFilters(v []*FilterForDescribeFileSystemsInput) *DescribeFileSystemsInput {
	s.Filters = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DescribeFileSystemsInput) SetLanguageCode(v string) *DescribeFileSystemsInput {
	s.LanguageCode = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *DescribeFileSystemsInput) SetOrderBy(v string) *DescribeFileSystemsInput {
	s.OrderBy = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeFileSystemsInput) SetPageNumber(v int32) *DescribeFileSystemsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeFileSystemsInput) SetPageSize(v int32) *DescribeFileSystemsInput {
	s.PageSize = &v
	return s
}

// SetProject sets the Project field's value.
func (s *DescribeFileSystemsInput) SetProject(v string) *DescribeFileSystemsInput {
	s.Project = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *DescribeFileSystemsInput) SetTagFilters(v []*TagFilterForDescribeFileSystemsInput) *DescribeFileSystemsInput {
	s.TagFilters = v
	return s
}

type DescribeFileSystemsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	FileSystems []*FileSystemForDescribeFileSystemsOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeFileSystemsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFileSystemsOutput) GoString() string {
	return s.String()
}

// SetFileSystems sets the FileSystems field's value.
func (s *DescribeFileSystemsOutput) SetFileSystems(v []*FileSystemForDescribeFileSystemsOutput) *DescribeFileSystemsOutput {
	s.FileSystems = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeFileSystemsOutput) SetPageNumber(v int32) *DescribeFileSystemsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeFileSystemsOutput) SetPageSize(v int32) *DescribeFileSystemsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DescribeFileSystemsOutput) SetTotalCount(v int32) *DescribeFileSystemsOutput {
	s.TotalCount = &v
	return s
}

type FileSystemForDescribeFileSystemsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccountId *string `type:"string" json:",omitempty"`

	Bandwidth *int32 `type:"int32" json:",omitempty"`

	CapacityInfo *CapacityInfoForDescribeFileSystemsOutput `type:"structure" json:",omitempty"`

	ChargeStatus *string `type:"string" json:",omitempty" enum:"EnumOfChargeStatusForDescribeFileSystemsOutput"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForDescribeFileSystemsOutput"`

	CreateTime *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	ExpireTime *string `type:"string" json:",omitempty"`

	FileSystemId *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	FileSystemType *string `type:"string" json:",omitempty" enum:"EnumOfFileSystemTypeForDescribeFileSystemsOutput"`

	FreeTime *string `type:"string" json:",omitempty"`

	LastModifyTime *string `type:"string" json:",omitempty"`

	Project *string `type:"string" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	ProtocolType *string `type:"string" json:",omitempty" enum:"EnumOfProtocolTypeForDescribeFileSystemsOutput"`

	ReadBandwidth *int32 `type:"int32" json:",omitempty"`

	RegionId *string `type:"string" json:",omitempty"`

	SecurityGroupId *string `type:"string" json:",omitempty"`

	Status *string `type:"string" json:",omitempty" enum:"EnumOfStatusForDescribeFileSystemsOutput"`

	StopServiceTime *string `type:"string" json:",omitempty"`

	StoreType *string `type:"string" json:",omitempty"`

	StoreTypeCN *string `type:"string" json:",omitempty"`

	StoreTypeEN *string `type:"string" json:",omitempty"`

	SubnetId *string `type:"string" json:",omitempty"`

	Tags []*TagForDescribeFileSystemsOutput `type:"list" json:",omitempty"`

	VersionNumber *string `type:"string" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	WriteBandwidth *int32 `type:"int32" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`

	ZoneName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FileSystemForDescribeFileSystemsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FileSystemForDescribeFileSystemsOutput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetAccountId(v string) *FileSystemForDescribeFileSystemsOutput {
	s.AccountId = &v
	return s
}

// SetBandwidth sets the Bandwidth field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetBandwidth(v int32) *FileSystemForDescribeFileSystemsOutput {
	s.Bandwidth = &v
	return s
}

// SetCapacityInfo sets the CapacityInfo field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetCapacityInfo(v *CapacityInfoForDescribeFileSystemsOutput) *FileSystemForDescribeFileSystemsOutput {
	s.CapacityInfo = v
	return s
}

// SetChargeStatus sets the ChargeStatus field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetChargeStatus(v string) *FileSystemForDescribeFileSystemsOutput {
	s.ChargeStatus = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetChargeType(v string) *FileSystemForDescribeFileSystemsOutput {
	s.ChargeType = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetCreateTime(v string) *FileSystemForDescribeFileSystemsOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetDescription(v string) *FileSystemForDescribeFileSystemsOutput {
	s.Description = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetExpireTime(v string) *FileSystemForDescribeFileSystemsOutput {
	s.ExpireTime = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetFileSystemId(v string) *FileSystemForDescribeFileSystemsOutput {
	s.FileSystemId = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetFileSystemName(v string) *FileSystemForDescribeFileSystemsOutput {
	s.FileSystemName = &v
	return s
}

// SetFileSystemType sets the FileSystemType field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetFileSystemType(v string) *FileSystemForDescribeFileSystemsOutput {
	s.FileSystemType = &v
	return s
}

// SetFreeTime sets the FreeTime field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetFreeTime(v string) *FileSystemForDescribeFileSystemsOutput {
	s.FreeTime = &v
	return s
}

// SetLastModifyTime sets the LastModifyTime field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetLastModifyTime(v string) *FileSystemForDescribeFileSystemsOutput {
	s.LastModifyTime = &v
	return s
}

// SetProject sets the Project field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetProject(v string) *FileSystemForDescribeFileSystemsOutput {
	s.Project = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetProjectName(v string) *FileSystemForDescribeFileSystemsOutput {
	s.ProjectName = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetProtocolType(v string) *FileSystemForDescribeFileSystemsOutput {
	s.ProtocolType = &v
	return s
}

// SetReadBandwidth sets the ReadBandwidth field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetReadBandwidth(v int32) *FileSystemForDescribeFileSystemsOutput {
	s.ReadBandwidth = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetRegionId(v string) *FileSystemForDescribeFileSystemsOutput {
	s.RegionId = &v
	return s
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetSecurityGroupId(v string) *FileSystemForDescribeFileSystemsOutput {
	s.SecurityGroupId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetStatus(v string) *FileSystemForDescribeFileSystemsOutput {
	s.Status = &v
	return s
}

// SetStopServiceTime sets the StopServiceTime field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetStopServiceTime(v string) *FileSystemForDescribeFileSystemsOutput {
	s.StopServiceTime = &v
	return s
}

// SetStoreType sets the StoreType field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetStoreType(v string) *FileSystemForDescribeFileSystemsOutput {
	s.StoreType = &v
	return s
}

// SetStoreTypeCN sets the StoreTypeCN field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetStoreTypeCN(v string) *FileSystemForDescribeFileSystemsOutput {
	s.StoreTypeCN = &v
	return s
}

// SetStoreTypeEN sets the StoreTypeEN field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetStoreTypeEN(v string) *FileSystemForDescribeFileSystemsOutput {
	s.StoreTypeEN = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetSubnetId(v string) *FileSystemForDescribeFileSystemsOutput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetTags(v []*TagForDescribeFileSystemsOutput) *FileSystemForDescribeFileSystemsOutput {
	s.Tags = v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetVersionNumber(v string) *FileSystemForDescribeFileSystemsOutput {
	s.VersionNumber = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetVpcId(v string) *FileSystemForDescribeFileSystemsOutput {
	s.VpcId = &v
	return s
}

// SetWriteBandwidth sets the WriteBandwidth field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetWriteBandwidth(v int32) *FileSystemForDescribeFileSystemsOutput {
	s.WriteBandwidth = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetZoneId(v string) *FileSystemForDescribeFileSystemsOutput {
	s.ZoneId = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *FileSystemForDescribeFileSystemsOutput) SetZoneName(v string) *FileSystemForDescribeFileSystemsOutput {
	s.ZoneName = &v
	return s
}

type FilterForDescribeFileSystemsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty" enum:"EnumOfKeyForDescribeFileSystemsInput"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FilterForDescribeFileSystemsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForDescribeFileSystemsInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *FilterForDescribeFileSystemsInput) SetKey(v string) *FilterForDescribeFileSystemsInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FilterForDescribeFileSystemsInput) SetValue(v string) *FilterForDescribeFileSystemsInput {
	s.Value = &v
	return s
}

type TagFilterForDescribeFileSystemsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TagFilterForDescribeFileSystemsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilterForDescribeFileSystemsInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagFilterForDescribeFileSystemsInput) SetKey(v string) *TagFilterForDescribeFileSystemsInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagFilterForDescribeFileSystemsInput) SetValue(v string) *TagFilterForDescribeFileSystemsInput {
	s.Value = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilterForDescribeFileSystemsInput) SetValues(v []*string) *TagFilterForDescribeFileSystemsInput {
	s.Values = v
	return s
}

type TagForDescribeFileSystemsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForDescribeFileSystemsOutput"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForDescribeFileSystemsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeFileSystemsOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeFileSystemsOutput) SetKey(v string) *TagForDescribeFileSystemsOutput {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *TagForDescribeFileSystemsOutput) SetType(v string) *TagForDescribeFileSystemsOutput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeFileSystemsOutput) SetValue(v string) *TagForDescribeFileSystemsOutput {
	s.Value = &v
	return s
}

const (
	// EnumOfChargeStatusForDescribeFileSystemsOutputInit is a EnumOfChargeStatusForDescribeFileSystemsOutput enum value
	EnumOfChargeStatusForDescribeFileSystemsOutputInit = "Init"

	// EnumOfChargeStatusForDescribeFileSystemsOutputNormal is a EnumOfChargeStatusForDescribeFileSystemsOutput enum value
	EnumOfChargeStatusForDescribeFileSystemsOutputNormal = "Normal"

	// EnumOfChargeStatusForDescribeFileSystemsOutputOverdue is a EnumOfChargeStatusForDescribeFileSystemsOutput enum value
	EnumOfChargeStatusForDescribeFileSystemsOutputOverdue = "Overdue"

	// EnumOfChargeStatusForDescribeFileSystemsOutputUnpaid is a EnumOfChargeStatusForDescribeFileSystemsOutput enum value
	EnumOfChargeStatusForDescribeFileSystemsOutputUnpaid = "Unpaid"

	// EnumOfChargeStatusForDescribeFileSystemsOutputNeedNotCharge is a EnumOfChargeStatusForDescribeFileSystemsOutput enum value
	EnumOfChargeStatusForDescribeFileSystemsOutputNeedNotCharge = "NeedNotCharge"

	// EnumOfChargeStatusForDescribeFileSystemsOutputChargeFailed is a EnumOfChargeStatusForDescribeFileSystemsOutput enum value
	EnumOfChargeStatusForDescribeFileSystemsOutputChargeFailed = "ChargeFailed"
)

const (
	// EnumOfChargeTypeForDescribeFileSystemsOutputPayAsYouGo is a EnumOfChargeTypeForDescribeFileSystemsOutput enum value
	EnumOfChargeTypeForDescribeFileSystemsOutputPayAsYouGo = "PayAsYouGo"
)

const (
	// EnumOfFileSystemTypeForDescribeFileSystemsOutputVePfs is a EnumOfFileSystemTypeForDescribeFileSystemsOutput enum value
	EnumOfFileSystemTypeForDescribeFileSystemsOutputVePfs = "VePFS"
)

const (
	// EnumOfKeyForDescribeFileSystemsInputChargeType is a EnumOfKeyForDescribeFileSystemsInput enum value
	EnumOfKeyForDescribeFileSystemsInputChargeType = "ChargeType"

	// EnumOfKeyForDescribeFileSystemsInputFileSystemType is a EnumOfKeyForDescribeFileSystemsInput enum value
	EnumOfKeyForDescribeFileSystemsInputFileSystemType = "FileSystemType"

	// EnumOfKeyForDescribeFileSystemsInputStoreType is a EnumOfKeyForDescribeFileSystemsInput enum value
	EnumOfKeyForDescribeFileSystemsInputStoreType = "StoreType"

	// EnumOfKeyForDescribeFileSystemsInputFileSystemName is a EnumOfKeyForDescribeFileSystemsInput enum value
	EnumOfKeyForDescribeFileSystemsInputFileSystemName = "FileSystemName"

	// EnumOfKeyForDescribeFileSystemsInputStatus is a EnumOfKeyForDescribeFileSystemsInput enum value
	EnumOfKeyForDescribeFileSystemsInputStatus = "Status"

	// EnumOfKeyForDescribeFileSystemsInputZoneId is a EnumOfKeyForDescribeFileSystemsInput enum value
	EnumOfKeyForDescribeFileSystemsInputZoneId = "ZoneId"

	// EnumOfKeyForDescribeFileSystemsInputProtocol is a EnumOfKeyForDescribeFileSystemsInput enum value
	EnumOfKeyForDescribeFileSystemsInputProtocol = "Protocol"

	// EnumOfKeyForDescribeFileSystemsInputAccountId is a EnumOfKeyForDescribeFileSystemsInput enum value
	EnumOfKeyForDescribeFileSystemsInputAccountId = "AccountId"
)

const (
	// EnumOfLanguageCodeForDescribeFileSystemsInputZh is a EnumOfLanguageCodeForDescribeFileSystemsInput enum value
	EnumOfLanguageCodeForDescribeFileSystemsInputZh = "zh"

	// EnumOfLanguageCodeForDescribeFileSystemsInputEn is a EnumOfLanguageCodeForDescribeFileSystemsInput enum value
	EnumOfLanguageCodeForDescribeFileSystemsInputEn = "en"
)

const (
	// EnumOfOrderByForDescribeFileSystemsInputCreateTimeDesc is a EnumOfOrderByForDescribeFileSystemsInput enum value
	EnumOfOrderByForDescribeFileSystemsInputCreateTimeDesc = "CreateTimeDesc"

	// EnumOfOrderByForDescribeFileSystemsInputCreateTimeAsc is a EnumOfOrderByForDescribeFileSystemsInput enum value
	EnumOfOrderByForDescribeFileSystemsInputCreateTimeAsc = "CreateTimeAsc"

	// EnumOfOrderByForDescribeFileSystemsInputCapacityDesc is a EnumOfOrderByForDescribeFileSystemsInput enum value
	EnumOfOrderByForDescribeFileSystemsInputCapacityDesc = "CapacityDesc"

	// EnumOfOrderByForDescribeFileSystemsInputCapacityAsc is a EnumOfOrderByForDescribeFileSystemsInput enum value
	EnumOfOrderByForDescribeFileSystemsInputCapacityAsc = "CapacityAsc"

	// EnumOfOrderByForDescribeFileSystemsInputIdDesc is a EnumOfOrderByForDescribeFileSystemsInput enum value
	EnumOfOrderByForDescribeFileSystemsInputIdDesc = "IdDesc"

	// EnumOfOrderByForDescribeFileSystemsInputIdAsc is a EnumOfOrderByForDescribeFileSystemsInput enum value
	EnumOfOrderByForDescribeFileSystemsInputIdAsc = "IdAsc"

	// EnumOfOrderByForDescribeFileSystemsInputVersionNumberDesc is a EnumOfOrderByForDescribeFileSystemsInput enum value
	EnumOfOrderByForDescribeFileSystemsInputVersionNumberDesc = "VersionNumberDesc"

	// EnumOfOrderByForDescribeFileSystemsInputVersionNumberAsc is a EnumOfOrderByForDescribeFileSystemsInput enum value
	EnumOfOrderByForDescribeFileSystemsInputVersionNumberAsc = "VersionNumberAsc"
)

const (
	// EnumOfProtocolTypeForDescribeFileSystemsOutputNfs is a EnumOfProtocolTypeForDescribeFileSystemsOutput enum value
	EnumOfProtocolTypeForDescribeFileSystemsOutputNfs = "NFS"

	// EnumOfProtocolTypeForDescribeFileSystemsOutputSmb is a EnumOfProtocolTypeForDescribeFileSystemsOutput enum value
	EnumOfProtocolTypeForDescribeFileSystemsOutputSmb = "SMB"

	// EnumOfProtocolTypeForDescribeFileSystemsOutputVePfs is a EnumOfProtocolTypeForDescribeFileSystemsOutput enum value
	EnumOfProtocolTypeForDescribeFileSystemsOutputVePfs = "VePFS"

	// EnumOfProtocolTypeForDescribeFileSystemsOutputFsx is a EnumOfProtocolTypeForDescribeFileSystemsOutput enum value
	EnumOfProtocolTypeForDescribeFileSystemsOutputFsx = "FSX"
)

const (
	// EnumOfStatusForDescribeFileSystemsOutputCreating is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputCreating = "Creating"

	// EnumOfStatusForDescribeFileSystemsOutputCreateError is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputCreateError = "CreateError"

	// EnumOfStatusForDescribeFileSystemsOutputRunning is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputRunning = "Running"

	// EnumOfStatusForDescribeFileSystemsOutputUpdating is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputUpdating = "Updating"

	// EnumOfStatusForDescribeFileSystemsOutputUpdateError is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputUpdateError = "UpdateError"

	// EnumOfStatusForDescribeFileSystemsOutputUpgrading is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputUpgrading = "Upgrading"

	// EnumOfStatusForDescribeFileSystemsOutputUpgradeError is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputUpgradeError = "UpgradeError"

	// EnumOfStatusForDescribeFileSystemsOutputExpanding is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputExpanding = "Expanding"

	// EnumOfStatusForDescribeFileSystemsOutputExpandError is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputExpandError = "ExpandError"

	// EnumOfStatusForDescribeFileSystemsOutputDeleting is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputDeleting = "Deleting"

	// EnumOfStatusForDescribeFileSystemsOutputDeleteError is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputDeleteError = "DeleteError"

	// EnumOfStatusForDescribeFileSystemsOutputDeleted is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputDeleted = "Deleted"

	// EnumOfStatusForDescribeFileSystemsOutputAttaching is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputAttaching = "Attaching"

	// EnumOfStatusForDescribeFileSystemsOutputAttachError is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputAttachError = "AttachError"

	// EnumOfStatusForDescribeFileSystemsOutputDetaching is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputDetaching = "Detaching"

	// EnumOfStatusForDescribeFileSystemsOutputDetachError is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputDetachError = "DetachError"

	// EnumOfStatusForDescribeFileSystemsOutputStopped is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputStopped = "Stopped"

	// EnumOfStatusForDescribeFileSystemsOutputError is a EnumOfStatusForDescribeFileSystemsOutput enum value
	EnumOfStatusForDescribeFileSystemsOutputError = "Error"
)

const (
	// EnumOfTypeForDescribeFileSystemsOutputSystem is a EnumOfTypeForDescribeFileSystemsOutput enum value
	EnumOfTypeForDescribeFileSystemsOutputSystem = "System"

	// EnumOfTypeForDescribeFileSystemsOutputCustom is a EnumOfTypeForDescribeFileSystemsOutput enum value
	EnumOfTypeForDescribeFileSystemsOutputCustom = "Custom"
)
