// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opReplicateKeyCommon = "ReplicateKey"

// ReplicateKeyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ReplicateKeyCommon operation. The "output" return
// value will be populated with the ReplicateKeyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ReplicateKeyCommon Request to send the API call to the service.
// the "output" return value is not valid until after ReplicateKeyCommon Send returns without error.
//
// See ReplicateKeyCommon for more information on using the ReplicateKeyCommon
// API call, and error handling.
//
//    // Example sending a request using the ReplicateKeyCommonRequest method.
//    req, resp := client.ReplicateKeyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ReplicateKeyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opReplicateKeyCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ReplicateKeyCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ReplicateKeyCommon for usage and error information.
func (c *KMS) ReplicateKeyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ReplicateKeyCommonRequest(input)
	return out, req.Send()
}

// ReplicateKeyCommonWithContext is the same as ReplicateKeyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ReplicateKeyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ReplicateKeyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ReplicateKeyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReplicateKey = "ReplicateKey"

// ReplicateKeyRequest generates a "volcengine/request.Request" representing the
// client's request for the ReplicateKey operation. The "output" return
// value will be populated with the ReplicateKeyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ReplicateKeyCommon Request to send the API call to the service.
// the "output" return value is not valid until after ReplicateKeyCommon Send returns without error.
//
// See ReplicateKey for more information on using the ReplicateKey
// API call, and error handling.
//
//    // Example sending a request using the ReplicateKeyRequest method.
//    req, resp := client.ReplicateKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ReplicateKeyRequest(input *ReplicateKeyInput) (req *request.Request, output *ReplicateKeyOutput) {
	op := &request.Operation{
		Name:       opReplicateKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplicateKeyInput{}
	}

	output = &ReplicateKeyOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ReplicateKey API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ReplicateKey for usage and error information.
func (c *KMS) ReplicateKey(input *ReplicateKeyInput) (*ReplicateKeyOutput, error) {
	req, out := c.ReplicateKeyRequest(input)
	return out, req.Send()
}

// ReplicateKeyWithContext is the same as ReplicateKey with the addition of
// the ability to pass a context and additional request options.
//
// See ReplicateKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ReplicateKeyWithContext(ctx volcengine.Context, input *ReplicateKeyInput, opts ...request.Option) (*ReplicateKeyOutput, error) {
	req, out := c.ReplicateKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ConvertReplicaKeyForReplicateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreationDate *int64 `type:"int64" json:",omitempty"`

	CustomKeyStoreID *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	KeyMaterialExpireTime *string `type:"string" json:",omitempty"`

	KeyName *string `type:"string" json:",omitempty"`

	KeySpec *string `type:"string" json:",omitempty"`

	KeyState *string `type:"string" json:",omitempty"`

	KeyUsage *string `type:"string" json:",omitempty"`

	LastRotationTime *string `type:"string" json:",omitempty"`

	MultiRegion *bool `type:"boolean" json:",omitempty"`

	MultiRegionConfiguration *MultiRegionConfigurationForReplicateKeyOutput `type:"structure" json:",omitempty"`

	Origin *string `type:"string" json:",omitempty"`

	ProtectionLevel *string `type:"string" json:",omitempty"`

	RotationState *string `type:"string" json:",omitempty"`

	ScheduleDeleteTime *string `type:"string" json:",omitempty"`

	ScheduleRotationTime *string `type:"string" json:",omitempty"`

	Tags []*TagForReplicateKeyOutput `type:"list" json:",omitempty"`

	Trn *string `type:"string" json:",omitempty"`

	UpdateDate *int64 `type:"int64" json:",omitempty"`

	XksKeyConfiguration *XksKeyConfigurationForReplicateKeyOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ConvertReplicaKeyForReplicateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertReplicaKeyForReplicateKeyOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetCreationDate(v int64) *ConvertReplicaKeyForReplicateKeyOutput {
	s.CreationDate = &v
	return s
}

// SetCustomKeyStoreID sets the CustomKeyStoreID field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetCustomKeyStoreID(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.CustomKeyStoreID = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetDescription(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.Description = &v
	return s
}

// SetID sets the ID field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetID(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.ID = &v
	return s
}

// SetKeyMaterialExpireTime sets the KeyMaterialExpireTime field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetKeyMaterialExpireTime(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.KeyMaterialExpireTime = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetKeyName(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.KeyName = &v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetKeySpec(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.KeySpec = &v
	return s
}

// SetKeyState sets the KeyState field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetKeyState(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.KeyState = &v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetKeyUsage(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.KeyUsage = &v
	return s
}

// SetLastRotationTime sets the LastRotationTime field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetLastRotationTime(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.LastRotationTime = &v
	return s
}

// SetMultiRegion sets the MultiRegion field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetMultiRegion(v bool) *ConvertReplicaKeyForReplicateKeyOutput {
	s.MultiRegion = &v
	return s
}

// SetMultiRegionConfiguration sets the MultiRegionConfiguration field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetMultiRegionConfiguration(v *MultiRegionConfigurationForReplicateKeyOutput) *ConvertReplicaKeyForReplicateKeyOutput {
	s.MultiRegionConfiguration = v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetOrigin(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.Origin = &v
	return s
}

// SetProtectionLevel sets the ProtectionLevel field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetProtectionLevel(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.ProtectionLevel = &v
	return s
}

// SetRotationState sets the RotationState field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetRotationState(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.RotationState = &v
	return s
}

// SetScheduleDeleteTime sets the ScheduleDeleteTime field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetScheduleDeleteTime(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.ScheduleDeleteTime = &v
	return s
}

// SetScheduleRotationTime sets the ScheduleRotationTime field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetScheduleRotationTime(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.ScheduleRotationTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetTags(v []*TagForReplicateKeyOutput) *ConvertReplicaKeyForReplicateKeyOutput {
	s.Tags = v
	return s
}

// SetTrn sets the Trn field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetTrn(v string) *ConvertReplicaKeyForReplicateKeyOutput {
	s.Trn = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetUpdateDate(v int64) *ConvertReplicaKeyForReplicateKeyOutput {
	s.UpdateDate = &v
	return s
}

// SetXksKeyConfiguration sets the XksKeyConfiguration field's value.
func (s *ConvertReplicaKeyForReplicateKeyOutput) SetXksKeyConfiguration(v *XksKeyConfigurationForReplicateKeyOutput) *ConvertReplicaKeyForReplicateKeyOutput {
	s.XksKeyConfiguration = v
	return s
}

type MultiRegionConfigurationForReplicateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MultiRegionKeyType *string `type:"string" json:",omitempty" enum:"EnumOfMultiRegionKeyTypeForReplicateKeyOutput"`

	PrimaryKey *PrimaryKeyForReplicateKeyOutput `type:"structure" json:",omitempty"`

	ReplicaKeys []*ReplicaKeyForReplicateKeyOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s MultiRegionConfigurationForReplicateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiRegionConfigurationForReplicateKeyOutput) GoString() string {
	return s.String()
}

// SetMultiRegionKeyType sets the MultiRegionKeyType field's value.
func (s *MultiRegionConfigurationForReplicateKeyOutput) SetMultiRegionKeyType(v string) *MultiRegionConfigurationForReplicateKeyOutput {
	s.MultiRegionKeyType = &v
	return s
}

// SetPrimaryKey sets the PrimaryKey field's value.
func (s *MultiRegionConfigurationForReplicateKeyOutput) SetPrimaryKey(v *PrimaryKeyForReplicateKeyOutput) *MultiRegionConfigurationForReplicateKeyOutput {
	s.PrimaryKey = v
	return s
}

// SetReplicaKeys sets the ReplicaKeys field's value.
func (s *MultiRegionConfigurationForReplicateKeyOutput) SetReplicaKeys(v []*ReplicaKeyForReplicateKeyOutput) *MultiRegionConfigurationForReplicateKeyOutput {
	s.ReplicaKeys = v
	return s
}

type PrimaryKeyForReplicateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	Trn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PrimaryKeyForReplicateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PrimaryKeyForReplicateKeyOutput) GoString() string {
	return s.String()
}

// SetRegion sets the Region field's value.
func (s *PrimaryKeyForReplicateKeyOutput) SetRegion(v string) *PrimaryKeyForReplicateKeyOutput {
	s.Region = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *PrimaryKeyForReplicateKeyOutput) SetTrn(v string) *PrimaryKeyForReplicateKeyOutput {
	s.Trn = &v
	return s
}

type ReplicaKeyForReplicateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	Trn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ReplicaKeyForReplicateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicaKeyForReplicateKeyOutput) GoString() string {
	return s.String()
}

// SetRegion sets the Region field's value.
func (s *ReplicaKeyForReplicateKeyOutput) SetRegion(v string) *ReplicaKeyForReplicateKeyOutput {
	s.Region = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *ReplicaKeyForReplicateKeyOutput) SetTrn(v string) *ReplicaKeyForReplicateKeyOutput {
	s.Trn = &v
	return s
}

type ReplicateKeyInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `max:"8192" type:"string" json:",omitempty"`

	KeyID *string `type:"string" json:",omitempty"`

	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	// ReplicaRegion is a required field
	ReplicaRegion *string `max:"64" type:"string" json:",omitempty" required:"true"`

	Tags []*TagForReplicateKeyInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ReplicateKeyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicateKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicateKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicateKeyInput"}
	if s.Description != nil && len(*s.Description) > 8192 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 8192, *s.Description))
	}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}
	if s.ReplicaRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicaRegion"))
	}
	if s.ReplicaRegion != nil && len(*s.ReplicaRegion) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("ReplicaRegion", 64, *s.ReplicaRegion))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ReplicateKeyInput) SetDescription(v string) *ReplicateKeyInput {
	s.Description = &v
	return s
}

// SetKeyID sets the KeyID field's value.
func (s *ReplicateKeyInput) SetKeyID(v string) *ReplicateKeyInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *ReplicateKeyInput) SetKeyName(v string) *ReplicateKeyInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *ReplicateKeyInput) SetKeyringName(v string) *ReplicateKeyInput {
	s.KeyringName = &v
	return s
}

// SetReplicaRegion sets the ReplicaRegion field's value.
func (s *ReplicateKeyInput) SetReplicaRegion(v string) *ReplicateKeyInput {
	s.ReplicaRegion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ReplicateKeyInput) SetTags(v []*TagForReplicateKeyInput) *ReplicateKeyInput {
	s.Tags = v
	return s
}

type ReplicateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ReplicaKey *ConvertReplicaKeyForReplicateKeyOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ReplicateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicateKeyOutput) GoString() string {
	return s.String()
}

// SetReplicaKey sets the ReplicaKey field's value.
func (s *ReplicateKeyOutput) SetReplicaKey(v *ConvertReplicaKeyForReplicateKeyOutput) *ReplicateKeyOutput {
	s.ReplicaKey = v
	return s
}

type TagForReplicateKeyInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForReplicateKeyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForReplicateKeyInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForReplicateKeyInput) SetKey(v string) *TagForReplicateKeyInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForReplicateKeyInput) SetValue(v string) *TagForReplicateKeyInput {
	s.Value = &v
	return s
}

type TagForReplicateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForReplicateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForReplicateKeyOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForReplicateKeyOutput) SetKey(v string) *TagForReplicateKeyOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForReplicateKeyOutput) SetValue(v string) *TagForReplicateKeyOutput {
	s.Value = &v
	return s
}

type XksKeyConfigurationForReplicateKeyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s XksKeyConfigurationForReplicateKeyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s XksKeyConfigurationForReplicateKeyOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *XksKeyConfigurationForReplicateKeyOutput) SetID(v string) *XksKeyConfigurationForReplicateKeyOutput {
	s.ID = &v
	return s
}

const (
	// EnumOfMultiRegionKeyTypeForReplicateKeyOutputPrimary is a EnumOfMultiRegionKeyTypeForReplicateKeyOutput enum value
	EnumOfMultiRegionKeyTypeForReplicateKeyOutputPrimary = "PRIMARY"

	// EnumOfMultiRegionKeyTypeForReplicateKeyOutputReplica is a EnumOfMultiRegionKeyTypeForReplicateKeyOutput enum value
	EnumOfMultiRegionKeyTypeForReplicateKeyOutputReplica = "REPLICA"
)
