// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListComponentsCommon = "ListComponents"

// ListComponentsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListComponentsCommon operation. The "output" return
// value will be populated with the ListComponentsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListComponentsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListComponentsCommon Send returns without error.
//
// See ListComponentsCommon for more information on using the ListComponentsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListComponentsCommonRequest method.
//    req, resp := client.ListComponentsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) ListComponentsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListComponentsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListComponentsCommon API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation ListComponentsCommon for usage and error information.
func (c *EMR) ListComponentsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListComponentsCommonRequest(input)
	return out, req.Send()
}

// ListComponentsCommonWithContext is the same as ListComponentsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponentsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListComponentsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListComponentsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListComponents = "ListComponents"

// ListComponentsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListComponents operation. The "output" return
// value will be populated with the ListComponentsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListComponentsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListComponentsCommon Send returns without error.
//
// See ListComponents for more information on using the ListComponents
// API call, and error handling.
//
//    // Example sending a request using the ListComponentsRequest method.
//    req, resp := client.ListComponentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) ListComponentsRequest(input *ListComponentsInput) (req *request.Request, output *ListComponentsOutput) {
	op := &request.Operation{
		Name:       opListComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListComponentsInput{}
	}

	output = &ListComponentsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListComponents API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation ListComponents for usage and error information.
func (c *EMR) ListComponents(input *ListComponentsInput) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	return out, req.Send()
}

// ListComponentsWithContext is the same as ListComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListComponentsWithContext(ctx volcengine.Context, input *ListComponentsInput, opts ...request.Option) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ItemForListComponentsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApplicationName *string `type:"string" json:",omitempty"`

	ClusterId *string `type:"string" json:",omitempty"`

	ComponentName *string `type:"string" json:",omitempty"`

	ComponentState *string `type:"string" json:",omitempty"`

	ComponentType *string `type:"string" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	StartTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListComponentsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListComponentsOutput) GoString() string {
	return s.String()
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ItemForListComponentsOutput) SetApplicationName(v string) *ItemForListComponentsOutput {
	s.ApplicationName = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *ItemForListComponentsOutput) SetClusterId(v string) *ItemForListComponentsOutput {
	s.ClusterId = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *ItemForListComponentsOutput) SetComponentName(v string) *ItemForListComponentsOutput {
	s.ComponentName = &v
	return s
}

// SetComponentState sets the ComponentState field's value.
func (s *ItemForListComponentsOutput) SetComponentState(v string) *ItemForListComponentsOutput {
	s.ComponentState = &v
	return s
}

// SetComponentType sets the ComponentType field's value.
func (s *ItemForListComponentsOutput) SetComponentType(v string) *ItemForListComponentsOutput {
	s.ComponentType = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ItemForListComponentsOutput) SetCreateTime(v string) *ItemForListComponentsOutput {
	s.CreateTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ItemForListComponentsOutput) SetStartTime(v string) *ItemForListComponentsOutput {
	s.StartTime = &v
	return s
}

type ListComponentsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApplicationNames []*string `type:"list" json:",omitempty"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	ComponentNames []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ListComponentsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationNames sets the ApplicationNames field's value.
func (s *ListComponentsInput) SetApplicationNames(v []*string) *ListComponentsInput {
	s.ApplicationNames = v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *ListComponentsInput) SetClusterId(v string) *ListComponentsInput {
	s.ClusterId = &v
	return s
}

// SetComponentNames sets the ComponentNames field's value.
func (s *ListComponentsInput) SetComponentNames(v []*string) *ListComponentsInput {
	s.ComponentNames = v
	return s
}

type ListComponentsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListComponentsOutput `type:"list" json:",omitempty"`

	MaxResults *int32 `type:"int32" json:",omitempty"`

	NextToken *string `type:"string" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListComponentsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComponentsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListComponentsOutput) SetItems(v []*ItemForListComponentsOutput) *ListComponentsOutput {
	s.Items = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentsOutput) SetMaxResults(v int32) *ListComponentsOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsOutput) SetNextToken(v string) *ListComponentsOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListComponentsOutput) SetTotalCount(v int32) *ListComponentsOutput {
	s.TotalCount = &v
	return s
}
