// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateCommandCommon = "CreateCommand"

// CreateCommandCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateCommandCommon operation. The "output" return
// value will be populated with the CreateCommandCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateCommandCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateCommandCommon Send returns without error.
//
// See CreateCommandCommon for more information on using the CreateCommandCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateCommandCommonRequest method.
//    req, resp := client.CreateCommandCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ECS) CreateCommandCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateCommandCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateCommandCommon API operation for ECS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ECS's
// API operation CreateCommandCommon for usage and error information.
func (c *ECS) CreateCommandCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateCommandCommonRequest(input)
	return out, req.Send()
}

// CreateCommandCommonWithContext is the same as CreateCommandCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCommandCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) CreateCommandCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateCommandCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCommand = "CreateCommand"

// CreateCommandRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateCommand operation. The "output" return
// value will be populated with the CreateCommandCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateCommandCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateCommandCommon Send returns without error.
//
// See CreateCommand for more information on using the CreateCommand
// API call, and error handling.
//
//    // Example sending a request using the CreateCommandRequest method.
//    req, resp := client.CreateCommandRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ECS) CreateCommandRequest(input *CreateCommandInput) (req *request.Request, output *CreateCommandOutput) {
	op := &request.Operation{
		Name:       opCreateCommand,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCommandInput{}
	}

	output = &CreateCommandOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateCommand API operation for ECS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ECS's
// API operation CreateCommand for usage and error information.
func (c *ECS) CreateCommand(input *CreateCommandInput) (*CreateCommandOutput, error) {
	req, out := c.CreateCommandRequest(input)
	return out, req.Send()
}

// CreateCommandWithContext is the same as CreateCommand with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCommand for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) CreateCommandWithContext(ctx volcengine.Context, input *CreateCommandInput, opts ...request.Option) (*CreateCommandOutput, error) {
	req, out := c.CreateCommandRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateCommandInput struct {
	_ struct{} `type:"structure"`

	// CommandContent is a required field
	CommandContent *string `type:"string" required:"true"`

	ContentEncoding *string `type:"string"`

	Description *string `type:"string"`

	EnableParameter *bool `type:"boolean"`

	// Name is a required field
	Name *string `type:"string" required:"true"`

	ParameterDefinitions []*ParameterDefinitionForCreateCommandInput `type:"list"`

	ProjectName *string `type:"string"`

	Tags []*TagForCreateCommandInput `type:"list"`

	Timeout *int32 `type:"int32"`

	// Type is a required field
	Type *string `type:"string" required:"true"`

	Username *string `type:"string"`

	WorkingDir *string `type:"string"`
}

// String returns the string representation
func (s CreateCommandInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCommandInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCommandInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCommandInput"}
	if s.CommandContent == nil {
		invalidParams.Add(request.NewErrParamRequired("CommandContent"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommandContent sets the CommandContent field's value.
func (s *CreateCommandInput) SetCommandContent(v string) *CreateCommandInput {
	s.CommandContent = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *CreateCommandInput) SetContentEncoding(v string) *CreateCommandInput {
	s.ContentEncoding = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCommandInput) SetDescription(v string) *CreateCommandInput {
	s.Description = &v
	return s
}

// SetEnableParameter sets the EnableParameter field's value.
func (s *CreateCommandInput) SetEnableParameter(v bool) *CreateCommandInput {
	s.EnableParameter = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCommandInput) SetName(v string) *CreateCommandInput {
	s.Name = &v
	return s
}

// SetParameterDefinitions sets the ParameterDefinitions field's value.
func (s *CreateCommandInput) SetParameterDefinitions(v []*ParameterDefinitionForCreateCommandInput) *CreateCommandInput {
	s.ParameterDefinitions = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateCommandInput) SetProjectName(v string) *CreateCommandInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCommandInput) SetTags(v []*TagForCreateCommandInput) *CreateCommandInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *CreateCommandInput) SetTimeout(v int32) *CreateCommandInput {
	s.Timeout = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateCommandInput) SetType(v string) *CreateCommandInput {
	s.Type = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateCommandInput) SetUsername(v string) *CreateCommandInput {
	s.Username = &v
	return s
}

// SetWorkingDir sets the WorkingDir field's value.
func (s *CreateCommandInput) SetWorkingDir(v string) *CreateCommandInput {
	s.WorkingDir = &v
	return s
}

type CreateCommandOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	CommandId *string `type:"string"`
}

// String returns the string representation
func (s CreateCommandOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCommandOutput) GoString() string {
	return s.String()
}

// SetCommandId sets the CommandId field's value.
func (s *CreateCommandOutput) SetCommandId(v string) *CreateCommandOutput {
	s.CommandId = &v
	return s
}

type ParameterDefinitionForCreateCommandInput struct {
	_ struct{} `type:"structure"`

	DecimalPrecision *int32 `type:"int32"`

	DefaultValue *string `type:"string"`

	MaxLength *int32 `type:"int32"`

	MaxValue *string `type:"string"`

	MinLength *int32 `type:"int32"`

	MinValue *string `type:"string"`

	Name *string `type:"string"`

	Required *bool `type:"boolean"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s ParameterDefinitionForCreateCommandInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterDefinitionForCreateCommandInput) GoString() string {
	return s.String()
}

// SetDecimalPrecision sets the DecimalPrecision field's value.
func (s *ParameterDefinitionForCreateCommandInput) SetDecimalPrecision(v int32) *ParameterDefinitionForCreateCommandInput {
	s.DecimalPrecision = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ParameterDefinitionForCreateCommandInput) SetDefaultValue(v string) *ParameterDefinitionForCreateCommandInput {
	s.DefaultValue = &v
	return s
}

// SetMaxLength sets the MaxLength field's value.
func (s *ParameterDefinitionForCreateCommandInput) SetMaxLength(v int32) *ParameterDefinitionForCreateCommandInput {
	s.MaxLength = &v
	return s
}

// SetMaxValue sets the MaxValue field's value.
func (s *ParameterDefinitionForCreateCommandInput) SetMaxValue(v string) *ParameterDefinitionForCreateCommandInput {
	s.MaxValue = &v
	return s
}

// SetMinLength sets the MinLength field's value.
func (s *ParameterDefinitionForCreateCommandInput) SetMinLength(v int32) *ParameterDefinitionForCreateCommandInput {
	s.MinLength = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *ParameterDefinitionForCreateCommandInput) SetMinValue(v string) *ParameterDefinitionForCreateCommandInput {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *ParameterDefinitionForCreateCommandInput) SetName(v string) *ParameterDefinitionForCreateCommandInput {
	s.Name = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *ParameterDefinitionForCreateCommandInput) SetRequired(v bool) *ParameterDefinitionForCreateCommandInput {
	s.Required = &v
	return s
}

// SetType sets the Type field's value.
func (s *ParameterDefinitionForCreateCommandInput) SetType(v string) *ParameterDefinitionForCreateCommandInput {
	s.Type = &v
	return s
}

type TagForCreateCommandInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateCommandInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateCommandInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateCommandInput) SetKey(v string) *TagForCreateCommandInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateCommandInput) SetValue(v string) *TagForCreateCommandInput {
	s.Value = &v
	return s
}
