// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudidentity

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListTasksCommon = "ListTasks"

// ListTasksCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTasksCommon operation. The "output" return
// value will be populated with the ListTasksCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTasksCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTasksCommon Send returns without error.
//
// See ListTasksCommon for more information on using the ListTasksCommon
// API call, and error handling.
//
//    // Example sending a request using the ListTasksCommonRequest method.
//    req, resp := client.ListTasksCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ListTasksCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListTasksCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTasksCommon API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ListTasksCommon for usage and error information.
func (c *CLOUDIDENTITY) ListTasksCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListTasksCommonRequest(input)
	return out, req.Send()
}

// ListTasksCommonWithContext is the same as ListTasksCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListTasksCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ListTasksCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListTasksCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTasks = "ListTasks"

// ListTasksRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTasks operation. The "output" return
// value will be populated with the ListTasksCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTasksCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTasksCommon Send returns without error.
//
// See ListTasks for more information on using the ListTasks
// API call, and error handling.
//
//    // Example sending a request using the ListTasksRequest method.
//    req, resp := client.ListTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ListTasksRequest(input *ListTasksInput) (req *request.Request, output *ListTasksOutput) {
	op := &request.Operation{
		Name:       opListTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTasksInput{}
	}

	output = &ListTasksOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTasks API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ListTasks for usage and error information.
func (c *CLOUDIDENTITY) ListTasks(input *ListTasksInput) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	return out, req.Send()
}

// ListTasksWithContext is the same as ListTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ListTasksWithContext(ctx volcengine.Context, input *ListTasksInput, opts ...request.Option) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListTasksInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *string `type:"string" json:",omitempty"`

	PageNumber *int32 `min:"1" type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	PrincipalType *string `type:"string" json:",omitempty" enum:"EnumOfPrincipalTypeForListTasksInput"`

	TaskStatus *string `type:"string" json:",omitempty" enum:"EnumOfTaskStatusForListTasksInput"`

	TaskType *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListTasksInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTasksInput"}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListTasksInput) SetFilter(v string) *ListTasksInput {
	s.Filter = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListTasksInput) SetPageNumber(v int32) *ListTasksInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTasksInput) SetPageSize(v int32) *ListTasksInput {
	s.PageSize = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *ListTasksInput) SetPrincipalType(v string) *ListTasksInput {
	s.PrincipalType = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *ListTasksInput) SetTaskStatus(v string) *ListTasksInput {
	s.TaskStatus = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *ListTasksInput) SetTaskType(v int32) *ListTasksInput {
	s.TaskType = &v
	return s
}

type ListTasksOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	Tasks []*TaskForListTasksOutput `type:"list" json:",omitempty"`

	Total *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ListTasksOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTasksOutput) GoString() string {
	return s.String()
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListTasksOutput) SetPageNumber(v int32) *ListTasksOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTasksOutput) SetPageSize(v int32) *ListTasksOutput {
	s.PageSize = &v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *ListTasksOutput) SetTasks(v []*TaskForListTasksOutput) *ListTasksOutput {
	s.Tasks = v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListTasksOutput) SetTotal(v int64) *ListTasksOutput {
	s.Total = &v
	return s
}

type TaskForListTasksOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreatedTime *string `type:"string" json:",omitempty"`

	PermissionSetId *string `type:"string" json:",omitempty"`

	PermissionSetName *string `type:"string" json:",omitempty"`

	PrincipalId *string `type:"string" json:",omitempty"`

	PrincipalName *string `type:"string" json:",omitempty"`

	PrincipalType *string `type:"string" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`

	TargetId *string `type:"string" json:",omitempty"`

	TargetName *string `type:"string" json:",omitempty"`

	TaskId *string `type:"string" json:",omitempty"`

	TaskType *string `type:"string" json:",omitempty"`

	UpdatedTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TaskForListTasksOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskForListTasksOutput) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *TaskForListTasksOutput) SetCreatedTime(v string) *TaskForListTasksOutput {
	s.CreatedTime = &v
	return s
}

// SetPermissionSetId sets the PermissionSetId field's value.
func (s *TaskForListTasksOutput) SetPermissionSetId(v string) *TaskForListTasksOutput {
	s.PermissionSetId = &v
	return s
}

// SetPermissionSetName sets the PermissionSetName field's value.
func (s *TaskForListTasksOutput) SetPermissionSetName(v string) *TaskForListTasksOutput {
	s.PermissionSetName = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *TaskForListTasksOutput) SetPrincipalId(v string) *TaskForListTasksOutput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalName sets the PrincipalName field's value.
func (s *TaskForListTasksOutput) SetPrincipalName(v string) *TaskForListTasksOutput {
	s.PrincipalName = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *TaskForListTasksOutput) SetPrincipalType(v string) *TaskForListTasksOutput {
	s.PrincipalType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TaskForListTasksOutput) SetStatus(v string) *TaskForListTasksOutput {
	s.Status = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *TaskForListTasksOutput) SetTargetId(v string) *TaskForListTasksOutput {
	s.TargetId = &v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *TaskForListTasksOutput) SetTargetName(v string) *TaskForListTasksOutput {
	s.TargetName = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *TaskForListTasksOutput) SetTaskId(v string) *TaskForListTasksOutput {
	s.TaskId = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *TaskForListTasksOutput) SetTaskType(v string) *TaskForListTasksOutput {
	s.TaskType = &v
	return s
}

// SetUpdatedTime sets the UpdatedTime field's value.
func (s *TaskForListTasksOutput) SetUpdatedTime(v string) *TaskForListTasksOutput {
	s.UpdatedTime = &v
	return s
}

const (
	// EnumOfPrincipalTypeForListTasksInputUser is a EnumOfPrincipalTypeForListTasksInput enum value
	EnumOfPrincipalTypeForListTasksInputUser = "User"

	// EnumOfPrincipalTypeForListTasksInputGroup is a EnumOfPrincipalTypeForListTasksInput enum value
	EnumOfPrincipalTypeForListTasksInputGroup = "Group"
)

const (
	// EnumOfTaskStatusForListTasksInputInit is a EnumOfTaskStatusForListTasksInput enum value
	EnumOfTaskStatusForListTasksInputInit = "Init"

	// EnumOfTaskStatusForListTasksInputRunning is a EnumOfTaskStatusForListTasksInput enum value
	EnumOfTaskStatusForListTasksInputRunning = "Running"

	// EnumOfTaskStatusForListTasksInputSuccess is a EnumOfTaskStatusForListTasksInput enum value
	EnumOfTaskStatusForListTasksInputSuccess = "Success"

	// EnumOfTaskStatusForListTasksInputFailed is a EnumOfTaskStatusForListTasksInput enum value
	EnumOfTaskStatusForListTasksInputFailed = "Failed"
)
