// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package certificateservice

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/client"
	"github.com/volcengine/volcengine-go-sdk/volcengine/client/metadata"
	"github.com/volcengine/volcengine-go-sdk/volcengine/corehandlers"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/signer/volc"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcenginequery"
)

// CERTIFICATESERVICE provides the API operation methods for making requests to
// CERTIFICATE_SERVICE. See this package's package overview docs
// for details on the service.
//
// CERTIFICATESERVICE methods are safe to use concurrently. It is not safe to
// modify mutate any of the struct's properties though.
type CERTIFICATESERVICE struct {
	*client.Client
}

// Used for custom client initialization logic
var initClient func(*client.Client)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// Service information constants
const (
	ServiceName = "certificate_service" // Name of service.
	EndpointsID = ServiceName           // ID to lookup a service endpoint with.
	ServiceID   = "certificate_service" // ServiceID is a unique identifer of a specific service.
)

// New create int can support ssl or region locate set
func New(p client.ConfigProvider, cfgs ...*volcengine.Config) *CERTIFICATESERVICE {
	c := p.ClientConfig(EndpointsID, cfgs...)
	return newClient(*c.Config, c.Handlers, c.Endpoint, c.SigningRegion, c.SigningName)
}

// newClient creates, initializes and returns a new service client instance.
func newClient(cfg volcengine.Config, handlers request.Handlers, endpoint, signingRegion, signingName string) *CERTIFICATESERVICE {
	svc := &CERTIFICATESERVICE{
		Client: client.New(
			cfg,
			metadata.ClientInfo{
				ServiceName:   ServiceName,
				ServiceID:     ServiceID,
				SigningName:   signingName,
				SigningRegion: signingRegion,
				Endpoint:      endpoint,
				APIVersion:    "2024-10-01",
			},
			handlers,
		),
	}

	// Handlers
	svc.Handlers.Build.PushBackNamed(corehandlers.SDKVersionUserAgentHandler)
	svc.Handlers.Build.PushBackNamed(corehandlers.AddHostExecEnvUserAgentHandler)
	svc.Handlers.Sign.PushBackNamed(volc.SignRequestHandler)
	svc.Handlers.Build.PushBackNamed(volcenginequery.BuildHandler)
	svc.Handlers.Unmarshal.PushBackNamed(volcenginequery.UnmarshalHandler)
	svc.Handlers.UnmarshalMeta.PushBackNamed(volcenginequery.UnmarshalMetaHandler)
	svc.Handlers.UnmarshalError.PushBackNamed(volcenginequery.UnmarshalErrorHandler)

	// Run custom client initialization if present
	if initClient != nil {
		initClient(svc.Client)
	}

	return svc
}

// newRequest creates a new request for a CERTIFICATESERVICE operation and runs any
// custom request initialization.
func (c *CERTIFICATESERVICE) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
