// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateWorkflowCommon = "CreateWorkflow"

// CreateWorkflowCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateWorkflowCommon operation. The "output" return
// value will be populated with the CreateWorkflowCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateWorkflowCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateWorkflowCommon Send returns without error.
//
// See CreateWorkflowCommon for more information on using the CreateWorkflowCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateWorkflowCommonRequest method.
//    req, resp := client.CreateWorkflowCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) CreateWorkflowCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateWorkflowCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateWorkflowCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation CreateWorkflowCommon for usage and error information.
func (c *BIO) CreateWorkflowCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateWorkflowCommonRequest(input)
	return out, req.Send()
}

// CreateWorkflowCommonWithContext is the same as CreateWorkflowCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkflowCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) CreateWorkflowCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateWorkflowCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkflow = "CreateWorkflow"

// CreateWorkflowRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateWorkflow operation. The "output" return
// value will be populated with the CreateWorkflowCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateWorkflowCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateWorkflowCommon Send returns without error.
//
// See CreateWorkflow for more information on using the CreateWorkflow
// API call, and error handling.
//
//    // Example sending a request using the CreateWorkflowRequest method.
//    req, resp := client.CreateWorkflowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) CreateWorkflowRequest(input *CreateWorkflowInput) (req *request.Request, output *CreateWorkflowOutput) {
	op := &request.Operation{
		Name:       opCreateWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkflowInput{}
	}

	output = &CreateWorkflowOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateWorkflow API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation CreateWorkflow for usage and error information.
func (c *BIO) CreateWorkflow(input *CreateWorkflowInput) (*CreateWorkflowOutput, error) {
	req, out := c.CreateWorkflowRequest(input)
	return out, req.Send()
}

// CreateWorkflowWithContext is the same as CreateWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) CreateWorkflowWithContext(ctx volcengine.Context, input *CreateWorkflowInput, opts ...request.Option) (*CreateWorkflowOutput, error) {
	req, out := c.CreateWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateWorkflowInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Content *string `type:"string" json:",omitempty"`

	Description *string `max:"1000" type:"string" json:",omitempty"`

	// Language is a required field
	Language *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfLanguageForCreateWorkflowInput"`

	MainWorkflowPath *string `type:"string" json:",omitempty"`

	// Name is a required field
	Name *string `min:"1" max:"200" type:"string" json:",omitempty" required:"true"`

	Source *string `type:"string" json:",omitempty"`

	// SourceType is a required field
	SourceType *string `type:"string" json:",omitempty" required:"true"`

	Tag *string `type:"string" json:",omitempty"`

	Token *string `type:"string" json:",omitempty"`

	// WorkspaceID is a required field
	WorkspaceID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateWorkflowInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkflowInput"}
	if s.Description != nil && len(*s.Description) > 1000 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 1000, *s.Description))
	}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 200 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 200, *s.Name))
	}
	if s.SourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceType"))
	}
	if s.WorkspaceID == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *CreateWorkflowInput) SetContent(v string) *CreateWorkflowInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkflowInput) SetDescription(v string) *CreateWorkflowInput {
	s.Description = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *CreateWorkflowInput) SetLanguage(v string) *CreateWorkflowInput {
	s.Language = &v
	return s
}

// SetMainWorkflowPath sets the MainWorkflowPath field's value.
func (s *CreateWorkflowInput) SetMainWorkflowPath(v string) *CreateWorkflowInput {
	s.MainWorkflowPath = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkflowInput) SetName(v string) *CreateWorkflowInput {
	s.Name = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateWorkflowInput) SetSource(v string) *CreateWorkflowInput {
	s.Source = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateWorkflowInput) SetSourceType(v string) *CreateWorkflowInput {
	s.SourceType = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *CreateWorkflowInput) SetTag(v string) *CreateWorkflowInput {
	s.Tag = &v
	return s
}

// SetToken sets the Token field's value.
func (s *CreateWorkflowInput) SetToken(v string) *CreateWorkflowInput {
	s.Token = &v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *CreateWorkflowInput) SetWorkspaceID(v string) *CreateWorkflowInput {
	s.WorkspaceID = &v
	return s
}

type CreateWorkflowOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateWorkflowOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkflowOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *CreateWorkflowOutput) SetID(v string) *CreateWorkflowOutput {
	s.ID = &v
	return s
}

const (
	// EnumOfLanguageForCreateWorkflowInputWdl is a EnumOfLanguageForCreateWorkflowInput enum value
	EnumOfLanguageForCreateWorkflowInputWdl = "WDL"

	// EnumOfLanguageForCreateWorkflowInputCwl is a EnumOfLanguageForCreateWorkflowInput enum value
	EnumOfLanguageForCreateWorkflowInputCwl = "CWL"

	// EnumOfLanguageForCreateWorkflowInputNextflow is a EnumOfLanguageForCreateWorkflowInput enum value
	EnumOfLanguageForCreateWorkflowInputNextflow = "Nextflow"
)
