// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package aiotvideo

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opStatStreamCommon = "StatStream"

// StatStreamCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the StatStreamCommon operation. The "output" return
// value will be populated with the StatStreamCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned StatStreamCommon Request to send the API call to the service.
// the "output" return value is not valid until after StatStreamCommon Send returns without error.
//
// See StatStreamCommon for more information on using the StatStreamCommon
// API call, and error handling.
//
//    // Example sending a request using the StatStreamCommonRequest method.
//    req, resp := client.StatStreamCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AIOTVIDEO) StatStreamCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opStatStreamCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// StatStreamCommon API operation for AIOTVIDEO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AIOTVIDEO's
// API operation StatStreamCommon for usage and error information.
func (c *AIOTVIDEO) StatStreamCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.StatStreamCommonRequest(input)
	return out, req.Send()
}

// StatStreamCommonWithContext is the same as StatStreamCommon with the addition of
// the ability to pass a context and additional request options.
//
// See StatStreamCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AIOTVIDEO) StatStreamCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.StatStreamCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStatStream = "StatStream"

// StatStreamRequest generates a "volcengine/request.Request" representing the
// client's request for the StatStream operation. The "output" return
// value will be populated with the StatStreamCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned StatStreamCommon Request to send the API call to the service.
// the "output" return value is not valid until after StatStreamCommon Send returns without error.
//
// See StatStream for more information on using the StatStream
// API call, and error handling.
//
//    // Example sending a request using the StatStreamRequest method.
//    req, resp := client.StatStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AIOTVIDEO) StatStreamRequest(input *StatStreamInput) (req *request.Request, output *StatStreamOutput) {
	op := &request.Operation{
		Name:       opStatStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StatStreamInput{}
	}

	output = &StatStreamOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// StatStream API operation for AIOTVIDEO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AIOTVIDEO's
// API operation StatStream for usage and error information.
func (c *AIOTVIDEO) StatStream(input *StatStreamInput) (*StatStreamOutput, error) {
	req, out := c.StatStreamRequest(input)
	return out, req.Send()
}

// StatStreamWithContext is the same as StatStream with the addition of
// the ability to pass a context and additional request options.
//
// See StatStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AIOTVIDEO) StatStreamWithContext(ctx volcengine.Context, input *StatStreamInput, opts ...request.Option) (*StatStreamOutput, error) {
	req, out := c.StatStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type SessionDataForStatStreamOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	OnlineUser *int32 `type:"int32" json:",omitempty"`

	Request *int32 `type:"int32" json:",omitempty"`

	Timestamp *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s SessionDataForStatStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SessionDataForStatStreamOutput) GoString() string {
	return s.String()
}

// SetOnlineUser sets the OnlineUser field's value.
func (s *SessionDataForStatStreamOutput) SetOnlineUser(v int32) *SessionDataForStatStreamOutput {
	s.OnlineUser = &v
	return s
}

// SetRequest sets the Request field's value.
func (s *SessionDataForStatStreamOutput) SetRequest(v int32) *SessionDataForStatStreamOutput {
	s.Request = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *SessionDataForStatStreamOutput) SetTimestamp(v int32) *SessionDataForStatStreamOutput {
	s.Timestamp = &v
	return s
}

type StatStreamInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Aggregation is a required field
	Aggregation *int32 `type:"int32" json:",omitempty" required:"true"`

	// EndTime is a required field
	EndTime *int32 `type:"int32" json:",omitempty" required:"true"`

	SpaceID *string `type:"string" json:",omitempty"`

	// StartTime is a required field
	StartTime *int32 `type:"int32" json:",omitempty" required:"true"`

	// StreamID is a required field
	StreamID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s StatStreamInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatStreamInput"}
	if s.Aggregation == nil {
		invalidParams.Add(request.NewErrParamRequired("Aggregation"))
	}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.StreamID == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregation sets the Aggregation field's value.
func (s *StatStreamInput) SetAggregation(v int32) *StatStreamInput {
	s.Aggregation = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *StatStreamInput) SetEndTime(v int32) *StatStreamInput {
	s.EndTime = &v
	return s
}

// SetSpaceID sets the SpaceID field's value.
func (s *StatStreamInput) SetSpaceID(v string) *StatStreamInput {
	s.SpaceID = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StatStreamInput) SetStartTime(v int32) *StatStreamInput {
	s.StartTime = &v
	return s
}

// SetStreamID sets the StreamID field's value.
func (s *StatStreamInput) SetStreamID(v string) *StatStreamInput {
	s.StreamID = &v
	return s
}

type StatStreamOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	SessionData *SessionDataForStatStreamOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s StatStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatStreamOutput) GoString() string {
	return s.String()
}

// SetSessionData sets the SessionData field's value.
func (s *StatStreamOutput) SetSessionData(v *SessionDataForStatStreamOutput) *StatStreamOutput {
	s.SessionData = v
	return s
}
