// Copyright 2020-2024 the Pinniped contributors. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"

	v1alpha1 "go.pinniped.dev/generated/latest/apis/supervisor/idp/v1alpha1"
	scheme "go.pinniped.dev/generated/latest/client/supervisor/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// OIDCIdentityProvidersGetter has a method to return a OIDCIdentityProviderInterface.
// A group's client should implement this interface.
type OIDCIdentityProvidersGetter interface {
	OIDCIdentityProviders(namespace string) OIDCIdentityProviderInterface
}

// OIDCIdentityProviderInterface has methods to work with OIDCIdentityProvider resources.
type OIDCIdentityProviderInterface interface {
	Create(ctx context.Context, oIDCIdentityProvider *v1alpha1.OIDCIdentityProvider, opts v1.CreateOptions) (*v1alpha1.OIDCIdentityProvider, error)
	Update(ctx context.Context, oIDCIdentityProvider *v1alpha1.OIDCIdentityProvider, opts v1.UpdateOptions) (*v1alpha1.OIDCIdentityProvider, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, oIDCIdentityProvider *v1alpha1.OIDCIdentityProvider, opts v1.UpdateOptions) (*v1alpha1.OIDCIdentityProvider, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.OIDCIdentityProvider, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.OIDCIdentityProviderList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.OIDCIdentityProvider, err error)
	OIDCIdentityProviderExpansion
}

// oIDCIdentityProviders implements OIDCIdentityProviderInterface
type oIDCIdentityProviders struct {
	*gentype.ClientWithList[*v1alpha1.OIDCIdentityProvider, *v1alpha1.OIDCIdentityProviderList]
}

// newOIDCIdentityProviders returns a OIDCIdentityProviders
func newOIDCIdentityProviders(c *IDPV1alpha1Client, namespace string) *oIDCIdentityProviders {
	return &oIDCIdentityProviders{
		gentype.NewClientWithList[*v1alpha1.OIDCIdentityProvider, *v1alpha1.OIDCIdentityProviderList](
			"oidcidentityproviders",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1alpha1.OIDCIdentityProvider { return &v1alpha1.OIDCIdentityProvider{} },
			func() *v1alpha1.OIDCIdentityProviderList { return &v1alpha1.OIDCIdentityProviderList{} }),
	}
}
