package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTrafficMirrorFilterAttribute invokes the vpc.UpdateTrafficMirrorFilterAttribute API synchronously
func (client *Client) UpdateTrafficMirrorFilterAttribute(request *UpdateTrafficMirrorFilterAttributeRequest) (response *UpdateTrafficMirrorFilterAttributeResponse, err error) {
	response = CreateUpdateTrafficMirrorFilterAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTrafficMirrorFilterAttributeWithChan invokes the vpc.UpdateTrafficMirrorFilterAttribute API asynchronously
func (client *Client) UpdateTrafficMirrorFilterAttributeWithChan(request *UpdateTrafficMirrorFilterAttributeRequest) (<-chan *UpdateTrafficMirrorFilterAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateTrafficMirrorFilterAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTrafficMirrorFilterAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTrafficMirrorFilterAttributeWithCallback invokes the vpc.UpdateTrafficMirrorFilterAttribute API asynchronously
func (client *Client) UpdateTrafficMirrorFilterAttributeWithCallback(request *UpdateTrafficMirrorFilterAttributeRequest, callback func(response *UpdateTrafficMirrorFilterAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTrafficMirrorFilterAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateTrafficMirrorFilterAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTrafficMirrorFilterAttributeRequest is the request struct for api UpdateTrafficMirrorFilterAttribute
type UpdateTrafficMirrorFilterAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                    string           `position:"Query" name:"ClientToken"`
	TrafficMirrorFilterName        string           `position:"Query" name:"TrafficMirrorFilterName"`
	DryRun                         requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount           string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                   string           `position:"Query" name:"OwnerAccount"`
	OwnerId                        requests.Integer `position:"Query" name:"OwnerId"`
	TrafficMirrorFilterDescription string           `position:"Query" name:"TrafficMirrorFilterDescription"`
	TrafficMirrorFilterId          string           `position:"Query" name:"TrafficMirrorFilterId"`
}

// UpdateTrafficMirrorFilterAttributeResponse is the response struct for api UpdateTrafficMirrorFilterAttribute
type UpdateTrafficMirrorFilterAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTrafficMirrorFilterAttributeRequest creates a request to invoke UpdateTrafficMirrorFilterAttribute API
func CreateUpdateTrafficMirrorFilterAttributeRequest() (request *UpdateTrafficMirrorFilterAttributeRequest) {
	request = &UpdateTrafficMirrorFilterAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "UpdateTrafficMirrorFilterAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTrafficMirrorFilterAttributeResponse creates a response to parse from UpdateTrafficMirrorFilterAttribute response
func CreateUpdateTrafficMirrorFilterAttributeResponse() (response *UpdateTrafficMirrorFilterAttributeResponse) {
	response = &UpdateTrafficMirrorFilterAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
