package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRouterInterfaceAttribute invokes the vpc.DescribeRouterInterfaceAttribute API synchronously
func (client *Client) DescribeRouterInterfaceAttribute(request *DescribeRouterInterfaceAttributeRequest) (response *DescribeRouterInterfaceAttributeResponse, err error) {
	response = CreateDescribeRouterInterfaceAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRouterInterfaceAttributeWithChan invokes the vpc.DescribeRouterInterfaceAttribute API asynchronously
func (client *Client) DescribeRouterInterfaceAttributeWithChan(request *DescribeRouterInterfaceAttributeRequest) (<-chan *DescribeRouterInterfaceAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeRouterInterfaceAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRouterInterfaceAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRouterInterfaceAttributeWithCallback invokes the vpc.DescribeRouterInterfaceAttribute API asynchronously
func (client *Client) DescribeRouterInterfaceAttributeWithCallback(request *DescribeRouterInterfaceAttributeRequest, callback func(response *DescribeRouterInterfaceAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRouterInterfaceAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeRouterInterfaceAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRouterInterfaceAttributeRequest is the request struct for api DescribeRouterInterfaceAttribute
type DescribeRouterInterfaceAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// DescribeRouterInterfaceAttributeResponse is the response struct for api DescribeRouterInterfaceAttribute
type DescribeRouterInterfaceAttributeResponse struct {
	*responses.BaseResponse
	ReservationActiveTime           string                                 `json:"ReservationActiveTime" xml:"ReservationActiveTime"`
	HealthCheckTargetIp             string                                 `json:"HealthCheckTargetIp" xml:"HealthCheckTargetIp"`
	Status                          string                                 `json:"Status" xml:"Status"`
	CreationTime                    string                                 `json:"CreationTime" xml:"CreationTime"`
	ReservationOrderType            string                                 `json:"ReservationOrderType" xml:"ReservationOrderType"`
	OppositeInterfaceId             string                                 `json:"OppositeInterfaceId" xml:"OppositeInterfaceId"`
	Spec                            string                                 `json:"Spec" xml:"Spec"`
	ChargeType                      string                                 `json:"ChargeType" xml:"ChargeType"`
	RouterInterfaceId               string                                 `json:"RouterInterfaceId" xml:"RouterInterfaceId"`
	Message                         string                                 `json:"Message" xml:"Message"`
	HcThreshold                     int                                    `json:"HcThreshold" xml:"HcThreshold"`
	OppositeRouterType              string                                 `json:"OppositeRouterType" xml:"OppositeRouterType"`
	GmtModified                     string                                 `json:"GmtModified" xml:"GmtModified"`
	VpcInstanceId                   string                                 `json:"VpcInstanceId" xml:"VpcInstanceId"`
	OppositeInterfaceOwnerId        string                                 `json:"OppositeInterfaceOwnerId" xml:"OppositeInterfaceOwnerId"`
	OppositeVpcInstanceId           string                                 `json:"OppositeVpcInstanceId" xml:"OppositeVpcInstanceId"`
	ReservationInternetChargeType   string                                 `json:"ReservationInternetChargeType" xml:"ReservationInternetChargeType"`
	CrossBorder                     bool                                   `json:"CrossBorder" xml:"CrossBorder"`
	RequestId                       string                                 `json:"RequestId" xml:"RequestId"`
	Bandwidth                       int                                    `json:"Bandwidth" xml:"Bandwidth"`
	Description                     string                                 `json:"Description" xml:"Description"`
	HcRate                          int                                    `json:"HcRate" xml:"HcRate"`
	ReservationBandwidth            string                                 `json:"ReservationBandwidth" xml:"ReservationBandwidth"`
	Code                            string                                 `json:"Code" xml:"Code"`
	Name                            string                                 `json:"Name" xml:"Name"`
	OppositeRouterId                string                                 `json:"OppositeRouterId" xml:"OppositeRouterId"`
	OppositeInterfaceSpec           string                                 `json:"OppositeInterfaceSpec" xml:"OppositeInterfaceSpec"`
	RouterId                        string                                 `json:"RouterId" xml:"RouterId"`
	Success                         bool                                   `json:"Success" xml:"Success"`
	OppositeInterfaceBusinessStatus string                                 `json:"OppositeInterfaceBusinessStatus" xml:"OppositeInterfaceBusinessStatus"`
	ConnectedTime                   string                                 `json:"ConnectedTime" xml:"ConnectedTime"`
	HealthCheckSourceIp             string                                 `json:"HealthCheckSourceIp" xml:"HealthCheckSourceIp"`
	OppositeInterfaceStatus         string                                 `json:"OppositeInterfaceStatus" xml:"OppositeInterfaceStatus"`
	EndTime                         string                                 `json:"EndTime" xml:"EndTime"`
	OppositeRegionId                string                                 `json:"OppositeRegionId" xml:"OppositeRegionId"`
	OppositeAccessPointId           string                                 `json:"OppositeAccessPointId" xml:"OppositeAccessPointId"`
	BusinessStatus                  string                                 `json:"BusinessStatus" xml:"BusinessStatus"`
	HealthCheckStatus               string                                 `json:"HealthCheckStatus" xml:"HealthCheckStatus"`
	OppositeBandwidth               int                                    `json:"OppositeBandwidth" xml:"OppositeBandwidth"`
	RouterType                      string                                 `json:"RouterType" xml:"RouterType"`
	Role                            string                                 `json:"Role" xml:"Role"`
	HasReservationData              string                                 `json:"HasReservationData" xml:"HasReservationData"`
	AccessPointId                   string                                 `json:"AccessPointId" xml:"AccessPointId"`
	ResourceGroupId                 string                                 `json:"ResourceGroupId" xml:"ResourceGroupId"`
	FastLinkMode                    string                                 `json:"FastLinkMode" xml:"FastLinkMode"`
	Tags                            TagsInDescribeRouterInterfaceAttribute `json:"Tags" xml:"Tags"`
}

// CreateDescribeRouterInterfaceAttributeRequest creates a request to invoke DescribeRouterInterfaceAttribute API
func CreateDescribeRouterInterfaceAttributeRequest() (request *DescribeRouterInterfaceAttributeRequest) {
	request = &DescribeRouterInterfaceAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeRouterInterfaceAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRouterInterfaceAttributeResponse creates a response to parse from DescribeRouterInterfaceAttribute response
func CreateDescribeRouterInterfaceAttributeResponse() (response *DescribeRouterInterfaceAttributeResponse) {
	response = &DescribeRouterInterfaceAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
