package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateExpressConnectTrafficQosRule invokes the vpc.CreateExpressConnectTrafficQosRule API synchronously
func (client *Client) CreateExpressConnectTrafficQosRule(request *CreateExpressConnectTrafficQosRuleRequest) (response *CreateExpressConnectTrafficQosRuleResponse, err error) {
	response = CreateCreateExpressConnectTrafficQosRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateExpressConnectTrafficQosRuleWithChan invokes the vpc.CreateExpressConnectTrafficQosRule API asynchronously
func (client *Client) CreateExpressConnectTrafficQosRuleWithChan(request *CreateExpressConnectTrafficQosRuleRequest) (<-chan *CreateExpressConnectTrafficQosRuleResponse, <-chan error) {
	responseChan := make(chan *CreateExpressConnectTrafficQosRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateExpressConnectTrafficQosRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateExpressConnectTrafficQosRuleWithCallback invokes the vpc.CreateExpressConnectTrafficQosRule API asynchronously
func (client *Client) CreateExpressConnectTrafficQosRuleWithCallback(request *CreateExpressConnectTrafficQosRuleRequest, callback func(response *CreateExpressConnectTrafficQosRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateExpressConnectTrafficQosRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateExpressConnectTrafficQosRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateExpressConnectTrafficQosRuleRequest is the request struct for api CreateExpressConnectTrafficQosRule
type CreateExpressConnectTrafficQosRuleRequest struct {
	*requests.RpcRequest
	DstCidr              string           `position:"Query" name:"DstCidr"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	RuleName             string           `position:"Query" name:"RuleName"`
	SrcCidr              string           `position:"Query" name:"SrcCidr"`
	DstIPv6Cidr          string           `position:"Query" name:"DstIPv6Cidr"`
	DstPortRange         string           `position:"Query" name:"DstPortRange"`
	Protocol             string           `position:"Query" name:"Protocol"`
	QosId                string           `position:"Query" name:"QosId"`
	QueueId              string           `position:"Query" name:"QueueId"`
	MatchDscp            requests.Integer `position:"Query" name:"MatchDscp"`
	RuleDescription      string           `position:"Query" name:"RuleDescription"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	RemarkingDscp        requests.Integer `position:"Query" name:"RemarkingDscp"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Priority             requests.Integer `position:"Query" name:"Priority"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SrcPortRange         string           `position:"Query" name:"SrcPortRange"`
	SrcIPv6Cidr          string           `position:"Query" name:"SrcIPv6Cidr"`
}

// CreateExpressConnectTrafficQosRuleResponse is the response struct for api CreateExpressConnectTrafficQosRule
type CreateExpressConnectTrafficQosRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	QosId     string `json:"QosId" xml:"QosId"`
	QueueId   string `json:"QueueId" xml:"QueueId"`
	RuleId    string `json:"RuleId" xml:"RuleId"`
}

// CreateCreateExpressConnectTrafficQosRuleRequest creates a request to invoke CreateExpressConnectTrafficQosRule API
func CreateCreateExpressConnectTrafficQosRuleRequest() (request *CreateExpressConnectTrafficQosRuleRequest) {
	request = &CreateExpressConnectTrafficQosRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateExpressConnectTrafficQosRule", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateExpressConnectTrafficQosRuleResponse creates a response to parse from CreateExpressConnectTrafficQosRule response
func CreateCreateExpressConnectTrafficQosRuleResponse() (response *CreateExpressConnectTrafficQosRuleResponse) {
	response = &CreateExpressConnectTrafficQosRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
