package ros

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// WaitConditions invokes the ros.WaitConditions API synchronously
// api document: https://help.aliyun.com/api/ros/waitconditions.html
func (client *Client) WaitConditions(request *WaitConditionsRequest) (response *WaitConditionsResponse, err error) {
	response = CreateWaitConditionsResponse()
	err = client.DoAction(request, response)
	return
}

// WaitConditionsWithChan invokes the ros.WaitConditions API asynchronously
// api document: https://help.aliyun.com/api/ros/waitconditions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) WaitConditionsWithChan(request *WaitConditionsRequest) (<-chan *WaitConditionsResponse, <-chan error) {
	responseChan := make(chan *WaitConditionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.WaitConditions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// WaitConditionsWithCallback invokes the ros.WaitConditions API asynchronously
// api document: https://help.aliyun.com/api/ros/waitconditions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) WaitConditionsWithCallback(request *WaitConditionsRequest, callback func(response *WaitConditionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *WaitConditionsResponse
		var err error
		defer close(result)
		response, err = client.WaitConditions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// WaitConditionsRequest is the request struct for api WaitConditions
type WaitConditionsRequest struct {
	*requests.RoaRequest
	Resource  string `position:"Query" name:"resource"`
	Signature string `position:"Query" name:"signature"`
	Stackid   string `position:"Query" name:"stackid"`
	Expire    string `position:"Query" name:"expire"`
	Stackname string `position:"Query" name:"stackname"`
}

// WaitConditionsResponse is the response struct for api WaitConditions
type WaitConditionsResponse struct {
	*responses.BaseResponse
}

// CreateWaitConditionsRequest creates a request to invoke WaitConditions API
func CreateWaitConditionsRequest() (request *WaitConditionsRequest) {
	request = &WaitConditionsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ROS", "2015-09-01", "WaitConditions", "/waitcondition", "ROS", "openAPI")
	request.Method = requests.POST
	return
}

// CreateWaitConditionsResponse creates a response to parse from WaitConditions response
func CreateWaitConditionsResponse() (response *WaitConditionsResponse) {
	response = &WaitConditionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
