package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableAutoGrouping invokes the resourcemanager.DisableAutoGrouping API synchronously
func (client *Client) DisableAutoGrouping(request *DisableAutoGroupingRequest) (response *DisableAutoGroupingResponse, err error) {
	response = CreateDisableAutoGroupingResponse()
	err = client.DoAction(request, response)
	return
}

// DisableAutoGroupingWithChan invokes the resourcemanager.DisableAutoGrouping API asynchronously
func (client *Client) DisableAutoGroupingWithChan(request *DisableAutoGroupingRequest) (<-chan *DisableAutoGroupingResponse, <-chan error) {
	responseChan := make(chan *DisableAutoGroupingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableAutoGrouping(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableAutoGroupingWithCallback invokes the resourcemanager.DisableAutoGrouping API asynchronously
func (client *Client) DisableAutoGroupingWithCallback(request *DisableAutoGroupingRequest, callback func(response *DisableAutoGroupingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableAutoGroupingResponse
		var err error
		defer close(result)
		response, err = client.DisableAutoGrouping(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableAutoGroupingRequest is the request struct for api DisableAutoGrouping
type DisableAutoGroupingRequest struct {
	*requests.RpcRequest
}

// DisableAutoGroupingResponse is the response struct for api DisableAutoGrouping
type DisableAutoGroupingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableAutoGroupingRequest creates a request to invoke DisableAutoGrouping API
func CreateDisableAutoGroupingRequest() (request *DisableAutoGroupingRequest) {
	request = &DisableAutoGroupingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "DisableAutoGrouping", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableAutoGroupingResponse creates a response to parse from DisableAutoGrouping response
func CreateDisableAutoGroupingResponse() (response *DisableAutoGroupingResponse) {
	response = &DisableAutoGroupingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
