package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWhitelistTemplateLinkedInstance invokes the rds.DescribeWhitelistTemplateLinkedInstance API synchronously
func (client *Client) DescribeWhitelistTemplateLinkedInstance(request *DescribeWhitelistTemplateLinkedInstanceRequest) (response *DescribeWhitelistTemplateLinkedInstanceResponse, err error) {
	response = CreateDescribeWhitelistTemplateLinkedInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWhitelistTemplateLinkedInstanceWithChan invokes the rds.DescribeWhitelistTemplateLinkedInstance API asynchronously
func (client *Client) DescribeWhitelistTemplateLinkedInstanceWithChan(request *DescribeWhitelistTemplateLinkedInstanceRequest) (<-chan *DescribeWhitelistTemplateLinkedInstanceResponse, <-chan error) {
	responseChan := make(chan *DescribeWhitelistTemplateLinkedInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWhitelistTemplateLinkedInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWhitelistTemplateLinkedInstanceWithCallback invokes the rds.DescribeWhitelistTemplateLinkedInstance API asynchronously
func (client *Client) DescribeWhitelistTemplateLinkedInstanceWithCallback(request *DescribeWhitelistTemplateLinkedInstanceRequest, callback func(response *DescribeWhitelistTemplateLinkedInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWhitelistTemplateLinkedInstanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeWhitelistTemplateLinkedInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWhitelistTemplateLinkedInstanceRequest is the request struct for api DescribeWhitelistTemplateLinkedInstance
type DescribeWhitelistTemplateLinkedInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	TemplateId           requests.Integer `position:"Body" name:"TemplateId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
}

// DescribeWhitelistTemplateLinkedInstanceResponse is the response struct for api DescribeWhitelistTemplateLinkedInstance
type DescribeWhitelistTemplateLinkedInstanceResponse struct {
	*responses.BaseResponse
	RequestId      string                                        `json:"RequestId" xml:"RequestId"`
	Success        bool                                          `json:"Success" xml:"Success"`
	Code           string                                        `json:"Code" xml:"Code"`
	Message        string                                        `json:"Message" xml:"Message"`
	HttpStatusCode int                                           `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           DataInDescribeWhitelistTemplateLinkedInstance `json:"Data" xml:"Data"`
}

// CreateDescribeWhitelistTemplateLinkedInstanceRequest creates a request to invoke DescribeWhitelistTemplateLinkedInstance API
func CreateDescribeWhitelistTemplateLinkedInstanceRequest() (request *DescribeWhitelistTemplateLinkedInstanceRequest) {
	request = &DescribeWhitelistTemplateLinkedInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeWhitelistTemplateLinkedInstance", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeWhitelistTemplateLinkedInstanceResponse creates a response to parse from DescribeWhitelistTemplateLinkedInstance response
func CreateDescribeWhitelistTemplateLinkedInstanceResponse() (response *DescribeWhitelistTemplateLinkedInstanceResponse) {
	response = &DescribeWhitelistTemplateLinkedInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
