package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePostgresExtensions invokes the rds.DeletePostgresExtensions API synchronously
func (client *Client) DeletePostgresExtensions(request *DeletePostgresExtensionsRequest) (response *DeletePostgresExtensionsResponse, err error) {
	response = CreateDeletePostgresExtensionsResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePostgresExtensionsWithChan invokes the rds.DeletePostgresExtensions API asynchronously
func (client *Client) DeletePostgresExtensionsWithChan(request *DeletePostgresExtensionsRequest) (<-chan *DeletePostgresExtensionsResponse, <-chan error) {
	responseChan := make(chan *DeletePostgresExtensionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePostgresExtensions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePostgresExtensionsWithCallback invokes the rds.DeletePostgresExtensions API asynchronously
func (client *Client) DeletePostgresExtensionsWithCallback(request *DeletePostgresExtensionsRequest, callback func(response *DeletePostgresExtensionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePostgresExtensionsResponse
		var err error
		defer close(result)
		response, err = client.DeletePostgresExtensions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePostgresExtensionsRequest is the request struct for api DeletePostgresExtensions
type DeletePostgresExtensionsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBNames              string           `position:"Query" name:"DBNames"`
	Extensions           string           `position:"Query" name:"Extensions"`
}

// DeletePostgresExtensionsResponse is the response struct for api DeletePostgresExtensions
type DeletePostgresExtensionsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePostgresExtensionsRequest creates a request to invoke DeletePostgresExtensions API
func CreateDeletePostgresExtensionsRequest() (request *DeletePostgresExtensionsRequest) {
	request = &DeletePostgresExtensionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DeletePostgresExtensions", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeletePostgresExtensionsResponse creates a response to parse from DeletePostgresExtensions response
func CreateDeletePostgresExtensionsResponse() (response *DeletePostgresExtensionsResponse) {
	response = &DeletePostgresExtensionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
