package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// NotifyResourceAddressFamily invokes the privatelink.NotifyResourceAddressFamily API synchronously
func (client *Client) NotifyResourceAddressFamily(request *NotifyResourceAddressFamilyRequest) (response *NotifyResourceAddressFamilyResponse, err error) {
	response = CreateNotifyResourceAddressFamilyResponse()
	err = client.DoAction(request, response)
	return
}

// NotifyResourceAddressFamilyWithChan invokes the privatelink.NotifyResourceAddressFamily API asynchronously
func (client *Client) NotifyResourceAddressFamilyWithChan(request *NotifyResourceAddressFamilyRequest) (<-chan *NotifyResourceAddressFamilyResponse, <-chan error) {
	responseChan := make(chan *NotifyResourceAddressFamilyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.NotifyResourceAddressFamily(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// NotifyResourceAddressFamilyWithCallback invokes the privatelink.NotifyResourceAddressFamily API asynchronously
func (client *Client) NotifyResourceAddressFamilyWithCallback(request *NotifyResourceAddressFamilyRequest, callback func(response *NotifyResourceAddressFamilyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *NotifyResourceAddressFamilyResponse
		var err error
		defer close(result)
		response, err = client.NotifyResourceAddressFamily(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// NotifyResourceAddressFamilyRequest is the request struct for api NotifyResourceAddressFamily
type NotifyResourceAddressFamilyRequest struct {
	*requests.RpcRequest
	ResourceId    string `position:"Query" name:"ResourceId"`
	ResourceType  string `position:"Query" name:"ResourceType"`
	AddressFamily string `position:"Query" name:"AddressFamily"`
	Ipv6Address   string `position:"Query" name:"Ipv6Address"`
}

// NotifyResourceAddressFamilyResponse is the response struct for api NotifyResourceAddressFamily
type NotifyResourceAddressFamilyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateNotifyResourceAddressFamilyRequest creates a request to invoke NotifyResourceAddressFamily API
func CreateNotifyResourceAddressFamilyRequest() (request *NotifyResourceAddressFamilyRequest) {
	request = &NotifyResourceAddressFamilyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "NotifyResourceAddressFamily", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateNotifyResourceAddressFamilyResponse creates a response to parse from NotifyResourceAddressFamily response
func CreateNotifyResourceAddressFamilyResponse() (response *NotifyResourceAddressFamilyResponse) {
	response = &NotifyResourceAddressFamilyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
