package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReportSampleConsistencyJob invokes the pairecservice.ReportSampleConsistencyJob API synchronously
func (client *Client) ReportSampleConsistencyJob(request *ReportSampleConsistencyJobRequest) (response *ReportSampleConsistencyJobResponse, err error) {
	response = CreateReportSampleConsistencyJobResponse()
	err = client.DoAction(request, response)
	return
}

// ReportSampleConsistencyJobWithChan invokes the pairecservice.ReportSampleConsistencyJob API asynchronously
func (client *Client) ReportSampleConsistencyJobWithChan(request *ReportSampleConsistencyJobRequest) (<-chan *ReportSampleConsistencyJobResponse, <-chan error) {
	responseChan := make(chan *ReportSampleConsistencyJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReportSampleConsistencyJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReportSampleConsistencyJobWithCallback invokes the pairecservice.ReportSampleConsistencyJob API asynchronously
func (client *Client) ReportSampleConsistencyJobWithCallback(request *ReportSampleConsistencyJobRequest, callback func(response *ReportSampleConsistencyJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReportSampleConsistencyJobResponse
		var err error
		defer close(result)
		response, err = client.ReportSampleConsistencyJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReportSampleConsistencyJobRequest is the request struct for api ReportSampleConsistencyJob
type ReportSampleConsistencyJobRequest struct {
	*requests.RoaRequest
	SampleConsistencyJobId string `position:"Path" name:"SampleConsistencyJobId"`
	InstanceId             string `position:"Query" name:"InstanceId"`
}

// ReportSampleConsistencyJobResponse is the response struct for api ReportSampleConsistencyJob
type ReportSampleConsistencyJobResponse struct {
	*responses.BaseResponse
	RequestId               int64                    `json:"RequestId" xml:"RequestId"`
	SampleTableFeatures     int64                    `json:"SampleTableFeatures" xml:"SampleTableFeatures"`
	SampleTableLostFeatures int64                    `json:"SampleTableLostFeatures" xml:"SampleTableLostFeatures"`
	ReplyTableFeatures      int64                    `json:"ReplyTableFeatures" xml:"ReplyTableFeatures"`
	ReplyTableLostFeatures  int64                    `json:"ReplyTableLostFeatures" xml:"ReplyTableLostFeatures"`
	FeaturesDifference      []FeaturesDifferenceItem `json:"FeaturesDifference" xml:"FeaturesDifference"`
}

// CreateReportSampleConsistencyJobRequest creates a request to invoke ReportSampleConsistencyJob API
func CreateReportSampleConsistencyJobRequest() (request *ReportSampleConsistencyJobRequest) {
	request = &ReportSampleConsistencyJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ReportSampleConsistencyJob", "/api/v1/sampleconsistencyjobs/[SampleConsistencyJobId]/action/report", "", "")
	request.Method = requests.GET
	return
}

// CreateReportSampleConsistencyJobResponse creates a response to parse from ReportSampleConsistencyJob response
func CreateReportSampleConsistencyJobResponse() (response *ReportSampleConsistencyJobResponse) {
	response = &ReportSampleConsistencyJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
