package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFunctionInstance invokes the opensearch.GetFunctionInstance API synchronously
func (client *Client) GetFunctionInstance(request *GetFunctionInstanceRequest) (response *GetFunctionInstanceResponse, err error) {
	response = CreateGetFunctionInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// GetFunctionInstanceWithChan invokes the opensearch.GetFunctionInstance API asynchronously
func (client *Client) GetFunctionInstanceWithChan(request *GetFunctionInstanceRequest) (<-chan *GetFunctionInstanceResponse, <-chan error) {
	responseChan := make(chan *GetFunctionInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFunctionInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFunctionInstanceWithCallback invokes the opensearch.GetFunctionInstance API asynchronously
func (client *Client) GetFunctionInstanceWithCallback(request *GetFunctionInstanceRequest, callback func(response *GetFunctionInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFunctionInstanceResponse
		var err error
		defer close(result)
		response, err = client.GetFunctionInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFunctionInstanceRequest is the request struct for api GetFunctionInstance
type GetFunctionInstanceRequest struct {
	*requests.RoaRequest
	Output           string `position:"Query" name:"output"`
	InstanceName     string `position:"Path" name:"instanceName"`
	FunctionName     string `position:"Path" name:"functionName"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// GetFunctionInstanceResponse is the response struct for api GetFunctionInstance
type GetFunctionInstanceResponse struct {
	*responses.BaseResponse
	Status    string                      `json:"Status" xml:"Status"`
	HttpCode  int64                       `json:"HttpCode" xml:"HttpCode"`
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Message   string                      `json:"Message" xml:"Message"`
	Code      string                      `json:"Code" xml:"Code"`
	Latency   int64                       `json:"Latency" xml:"Latency"`
	Result    ResultInGetFunctionInstance `json:"Result" xml:"Result"`
}

// CreateGetFunctionInstanceRequest creates a request to invoke GetFunctionInstance API
func CreateGetFunctionInstanceRequest() (request *GetFunctionInstanceRequest) {
	request = &GetFunctionInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "GetFunctionInstance", "/v4/openapi/app-groups/[appGroupIdentity]/functions/[functionName]/instances/[instanceName]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetFunctionInstanceResponse creates a response to parse from GetFunctionInstance response
func CreateGetFunctionInstanceResponse() (response *GetFunctionInstanceResponse) {
	response = &GetFunctionInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
