package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSecondRank invokes the opensearch.CreateSecondRank API synchronously
func (client *Client) CreateSecondRank(request *CreateSecondRankRequest) (response *CreateSecondRankResponse, err error) {
	response = CreateCreateSecondRankResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSecondRankWithChan invokes the opensearch.CreateSecondRank API asynchronously
func (client *Client) CreateSecondRankWithChan(request *CreateSecondRankRequest) (<-chan *CreateSecondRankResponse, <-chan error) {
	responseChan := make(chan *CreateSecondRankResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSecondRank(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSecondRankWithCallback invokes the opensearch.CreateSecondRank API asynchronously
func (client *Client) CreateSecondRankWithCallback(request *CreateSecondRankRequest, callback func(response *CreateSecondRankResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSecondRankResponse
		var err error
		defer close(result)
		response, err = client.CreateSecondRank(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSecondRankRequest is the request struct for api CreateSecondRank
type CreateSecondRankRequest struct {
	*requests.RoaRequest
	DryRun           requests.Boolean `position:"Query" name:"dryRun"`
	AppId            requests.Integer `position:"Path" name:"appId"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// CreateSecondRankResponse is the response struct for api CreateSecondRank
type CreateSecondRankResponse struct {
	*responses.BaseResponse
	Result    map[string]interface{} `json:"result" xml:"result"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
}

// CreateCreateSecondRankRequest creates a request to invoke CreateSecondRank API
func CreateCreateSecondRankRequest() (request *CreateSecondRankRequest) {
	request = &CreateSecondRankRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "CreateSecondRank", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]/second-ranks", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSecondRankResponse creates a response to parse from CreateSecondRank response
func CreateCreateSecondRankResponse() (response *CreateSecondRankResponse) {
	response = &CreateSecondRankResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
