package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLifecyclePolicy invokes the nas.DeleteLifecyclePolicy API synchronously
func (client *Client) DeleteLifecyclePolicy(request *DeleteLifecyclePolicyRequest) (response *DeleteLifecyclePolicyResponse, err error) {
	response = CreateDeleteLifecyclePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLifecyclePolicyWithChan invokes the nas.DeleteLifecyclePolicy API asynchronously
func (client *Client) DeleteLifecyclePolicyWithChan(request *DeleteLifecyclePolicyRequest) (<-chan *DeleteLifecyclePolicyResponse, <-chan error) {
	responseChan := make(chan *DeleteLifecyclePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLifecyclePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLifecyclePolicyWithCallback invokes the nas.DeleteLifecyclePolicy API asynchronously
func (client *Client) DeleteLifecyclePolicyWithCallback(request *DeleteLifecyclePolicyRequest, callback func(response *DeleteLifecyclePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLifecyclePolicyResponse
		var err error
		defer close(result)
		response, err = client.DeleteLifecyclePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLifecyclePolicyRequest is the request struct for api DeleteLifecyclePolicy
type DeleteLifecyclePolicyRequest struct {
	*requests.RpcRequest
	LifecyclePolicyName string `position:"Query" name:"LifecyclePolicyName"`
	FileSystemId        string `position:"Query" name:"FileSystemId"`
}

// DeleteLifecyclePolicyResponse is the response struct for api DeleteLifecyclePolicy
type DeleteLifecyclePolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteLifecyclePolicyRequest creates a request to invoke DeleteLifecyclePolicy API
func CreateDeleteLifecyclePolicyRequest() (request *DeleteLifecyclePolicyRequest) {
	request = &DeleteLifecyclePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DeleteLifecyclePolicy", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLifecyclePolicyResponse creates a response to parse from DeleteLifecyclePolicy response
func CreateDeleteLifecyclePolicyResponse() (response *DeleteLifecyclePolicyResponse) {
	response = &DeleteLifecyclePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
