package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveApplication invokes the mse.RemoveApplication API synchronously
func (client *Client) RemoveApplication(request *RemoveApplicationRequest) (response *RemoveApplicationResponse, err error) {
	response = CreateRemoveApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveApplicationWithChan invokes the mse.RemoveApplication API asynchronously
func (client *Client) RemoveApplicationWithChan(request *RemoveApplicationRequest) (<-chan *RemoveApplicationResponse, <-chan error) {
	responseChan := make(chan *RemoveApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveApplicationWithCallback invokes the mse.RemoveApplication API asynchronously
func (client *Client) RemoveApplicationWithCallback(request *RemoveApplicationRequest, callback func(response *RemoveApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveApplicationResponse
		var err error
		defer close(result)
		response, err = client.RemoveApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveApplicationRequest is the request struct for api RemoveApplication
type RemoveApplicationRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	AppName        string `position:"Query" name:"AppName"`
	AppId          string `position:"Query" name:"AppId"`
	Namespace      string `position:"Query" name:"Namespace"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
	Region         string `position:"Query" name:"Region"`
}

// RemoveApplicationResponse is the response struct for api RemoveApplication
type RemoveApplicationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateRemoveApplicationRequest creates a request to invoke RemoveApplication API
func CreateRemoveApplicationRequest() (request *RemoveApplicationRequest) {
	request = &RemoveApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "RemoveApplication", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveApplicationResponse creates a response to parse from RemoveApplication response
func CreateRemoveApplicationResponse() (response *RemoveApplicationResponse) {
	response = &RemoveApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
