package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryInstancesInfo invokes the mse.QueryInstancesInfo API synchronously
func (client *Client) QueryInstancesInfo(request *QueryInstancesInfoRequest) (response *QueryInstancesInfoResponse, err error) {
	response = CreateQueryInstancesInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryInstancesInfoWithChan invokes the mse.QueryInstancesInfo API asynchronously
func (client *Client) QueryInstancesInfoWithChan(request *QueryInstancesInfoRequest) (<-chan *QueryInstancesInfoResponse, <-chan error) {
	responseChan := make(chan *QueryInstancesInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryInstancesInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryInstancesInfoWithCallback invokes the mse.QueryInstancesInfo API asynchronously
func (client *Client) QueryInstancesInfoWithCallback(request *QueryInstancesInfoRequest, callback func(response *QueryInstancesInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryInstancesInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryInstancesInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryInstancesInfoRequest is the request struct for api QueryInstancesInfo
type QueryInstancesInfoRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	RequestPars    string `position:"Query" name:"RequestPars"`
	OrderId        string `position:"Query" name:"OrderId"`
	ClusterId      string `position:"Query" name:"ClusterId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// QueryInstancesInfoResponse is the response struct for api QueryInstancesInfo
type QueryInstancesInfoResponse struct {
	*responses.BaseResponse
	Success   bool             `json:"Success" xml:"Success"`
	Message   string           `json:"Message" xml:"Message"`
	RequestId string           `json:"RequestId" xml:"RequestId"`
	ErrorCode string           `json:"ErrorCode" xml:"ErrorCode"`
	HttpCode  string           `json:"HttpCode" xml:"HttpCode"`
	Data      []InstanceModels `json:"Data" xml:"Data"`
}

// CreateQueryInstancesInfoRequest creates a request to invoke QueryInstancesInfo API
func CreateQueryInstancesInfoRequest() (request *QueryInstancesInfoRequest) {
	request = &QueryInstancesInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "QueryInstancesInfo", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryInstancesInfoResponse creates a response to parse from QueryInstancesInfo response
func CreateQueryInstancesInfoResponse() (response *QueryInstancesInfoResponse) {
	response = &QueryInstancesInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
