package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAuthPolicy invokes the mse.ListAuthPolicy API synchronously
func (client *Client) ListAuthPolicy(request *ListAuthPolicyRequest) (response *ListAuthPolicyResponse, err error) {
	response = CreateListAuthPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ListAuthPolicyWithChan invokes the mse.ListAuthPolicy API asynchronously
func (client *Client) ListAuthPolicyWithChan(request *ListAuthPolicyRequest) (<-chan *ListAuthPolicyResponse, <-chan error) {
	responseChan := make(chan *ListAuthPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAuthPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAuthPolicyWithCallback invokes the mse.ListAuthPolicy API asynchronously
func (client *Client) ListAuthPolicyWithCallback(request *ListAuthPolicyRequest, callback func(response *ListAuthPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAuthPolicyResponse
		var err error
		defer close(result)
		response, err = client.ListAuthPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAuthPolicyRequest is the request struct for api ListAuthPolicy
type ListAuthPolicyRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	Source         string `position:"Query" name:"Source"`
	PageNumber     string `position:"Query" name:"PageNumber"`
	Protocol       string `position:"Query" name:"Protocol"`
	PageSize       string `position:"Query" name:"PageSize"`
	AppId          string `position:"Query" name:"AppId"`
	Name           string `position:"Query" name:"Name"`
	Namespace      string `position:"Query" name:"Namespace"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
	Region         string `position:"Query" name:"Region"`
}

// ListAuthPolicyResponse is the response struct for api ListAuthPolicy
type ListAuthPolicyResponse struct {
	*responses.BaseResponse
	HttpStatusCode int                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string               `json:"Message" xml:"Message"`
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	Code           int                  `json:"Code" xml:"Code"`
	Success        bool                 `json:"Success" xml:"Success"`
	Data           DataInListAuthPolicy `json:"Data" xml:"Data"`
}

// CreateListAuthPolicyRequest creates a request to invoke ListAuthPolicy API
func CreateListAuthPolicyRequest() (request *ListAuthPolicyRequest) {
	request = &ListAuthPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListAuthPolicy", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAuthPolicyResponse creates a response to parse from ListAuthPolicy response
func CreateListAuthPolicyResponse() (response *ListAuthPolicyResponse) {
	response = &ListAuthPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
