package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GatewayBlackWhiteList invokes the mse.GatewayBlackWhiteList API synchronously
func (client *Client) GatewayBlackWhiteList(request *GatewayBlackWhiteListRequest) (response *GatewayBlackWhiteListResponse, err error) {
	response = CreateGatewayBlackWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// GatewayBlackWhiteListWithChan invokes the mse.GatewayBlackWhiteList API asynchronously
func (client *Client) GatewayBlackWhiteListWithChan(request *GatewayBlackWhiteListRequest) (<-chan *GatewayBlackWhiteListResponse, <-chan error) {
	responseChan := make(chan *GatewayBlackWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GatewayBlackWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GatewayBlackWhiteListWithCallback invokes the mse.GatewayBlackWhiteList API asynchronously
func (client *Client) GatewayBlackWhiteListWithCallback(request *GatewayBlackWhiteListRequest, callback func(response *GatewayBlackWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GatewayBlackWhiteListResponse
		var err error
		defer close(result)
		response, err = client.GatewayBlackWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GatewayBlackWhiteListRequest is the request struct for api GatewayBlackWhiteList
type GatewayBlackWhiteListRequest struct {
	*requests.RpcRequest
	MseSessionId   string                            `position:"Query" name:"MseSessionId"`
	PageNumber     requests.Integer                  `position:"Query" name:"PageNumber"`
	OrderItem      string                            `position:"Query" name:"OrderItem"`
	PageSize       requests.Integer                  `position:"Query" name:"PageSize"`
	DescSort       requests.Boolean                  `position:"Query" name:"DescSort"`
	FilterParams   GatewayBlackWhiteListFilterParams `position:"Query" name:"FilterParams"  type:"Struct"`
	AcceptLanguage string                            `position:"Query" name:"AcceptLanguage"`
}

// GatewayBlackWhiteListFilterParams is a repeated param struct in GatewayBlackWhiteListRequest
type GatewayBlackWhiteListFilterParams struct {
	GatewayUniqueId string `name:"GatewayUniqueId"`
	IsWhite         string `name:"IsWhite"`
	SearchType      string `name:"SearchType"`
	SearchContent   string `name:"SearchContent"`
	Type            string `name:"Type"`
	ResourceType    string `name:"ResourceType"`
	GatewayId       string `name:"GatewayId"`
}

// GatewayBlackWhiteListResponse is the response struct for api GatewayBlackWhiteList
type GatewayBlackWhiteListResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGatewayBlackWhiteListRequest creates a request to invoke GatewayBlackWhiteList API
func CreateGatewayBlackWhiteListRequest() (request *GatewayBlackWhiteListRequest) {
	request = &GatewayBlackWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GatewayBlackWhiteList", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGatewayBlackWhiteListResponse creates a response to parse from GatewayBlackWhiteList response
func CreateGatewayBlackWhiteListResponse() (response *GatewayBlackWhiteListResponse) {
	response = &GatewayBlackWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
