package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushMultiple invokes the mpaas.PushMultiple API synchronously
func (client *Client) PushMultiple(request *PushMultipleRequest) (response *PushMultipleResponse, err error) {
	response = CreatePushMultipleResponse()
	err = client.DoAction(request, response)
	return
}

// PushMultipleWithChan invokes the mpaas.PushMultiple API asynchronously
func (client *Client) PushMultipleWithChan(request *PushMultipleRequest) (<-chan *PushMultipleResponse, <-chan error) {
	responseChan := make(chan *PushMultipleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushMultiple(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushMultipleWithCallback invokes the mpaas.PushMultiple API asynchronously
func (client *Client) PushMultipleWithCallback(request *PushMultipleRequest, callback func(response *PushMultipleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushMultipleResponse
		var err error
		defer close(result)
		response, err = client.PushMultiple(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushMultipleRequest is the request struct for api PushMultiple
type PushMultipleRequest struct {
	*requests.RpcRequest
	TaskName        string                   `position:"Body" name:"TaskName"`
	PushAction      requests.Integer         `position:"Body" name:"PushAction"`
	DeliveryType    requests.Integer         `position:"Body" name:"DeliveryType"`
	TemplateName    string                   `position:"Body" name:"TemplateName"`
	NotifyType      string                   `position:"Body" name:"NotifyType"`
	ExtendedParams  string                   `position:"Body" name:"ExtendedParams"`
	Silent          requests.Integer         `position:"Body" name:"Silent"`
	StrategyContent string                   `position:"Body" name:"StrategyContent"`
	Classification  string                   `position:"Body" name:"Classification"`
	ExpiredSeconds  requests.Integer         `position:"Body" name:"ExpiredSeconds"`
	TargetMsg       *[]PushMultipleTargetMsg `position:"Body" name:"TargetMsg"  type:"Repeated"`
	AppId           string                   `position:"Body" name:"AppId"`
	StrategyType    requests.Integer         `position:"Body" name:"StrategyType"`
	WorkspaceId     string                   `position:"Body" name:"WorkspaceId"`
}

// PushMultipleTargetMsg is a repeated param struct in PushMultipleRequest
type PushMultipleTargetMsg struct {
	ExtendedParams   string `name:"ExtendedParams"`
	TemplateKeyValue string `name:"TemplateKeyValue"`
	MsgKey           string `name:"MsgKey"`
	Target           string `name:"Target"`
}

// PushMultipleResponse is the response struct for api PushMultiple
type PushMultipleResponse struct {
	*responses.BaseResponse
	ResultMessage string     `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string     `json:"ResultCode" xml:"ResultCode"`
	RequestId     string     `json:"RequestId" xml:"RequestId"`
	PushResult    PushResult `json:"PushResult" xml:"PushResult"`
}

// CreatePushMultipleRequest creates a request to invoke PushMultiple API
func CreatePushMultipleRequest() (request *PushMultipleRequest) {
	request = &PushMultipleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "PushMultiple", "", "")
	request.Method = requests.POST
	return
}

// CreatePushMultipleResponse creates a response to parse from PushMultiple response
func CreatePushMultipleResponse() (response *PushMultipleResponse) {
	response = &PushMultipleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
