package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMdsMiniConfig invokes the mpaas.GetMdsMiniConfig API synchronously
func (client *Client) GetMdsMiniConfig(request *GetMdsMiniConfigRequest) (response *GetMdsMiniConfigResponse, err error) {
	response = CreateGetMdsMiniConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetMdsMiniConfigWithChan invokes the mpaas.GetMdsMiniConfig API asynchronously
func (client *Client) GetMdsMiniConfigWithChan(request *GetMdsMiniConfigRequest) (<-chan *GetMdsMiniConfigResponse, <-chan error) {
	responseChan := make(chan *GetMdsMiniConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMdsMiniConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMdsMiniConfigWithCallback invokes the mpaas.GetMdsMiniConfig API asynchronously
func (client *Client) GetMdsMiniConfigWithCallback(request *GetMdsMiniConfigRequest, callback func(response *GetMdsMiniConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMdsMiniConfigResponse
		var err error
		defer close(result)
		response, err = client.GetMdsMiniConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMdsMiniConfigRequest is the request struct for api GetMdsMiniConfig
type GetMdsMiniConfigRequest struct {
	*requests.RpcRequest
	H5Id        string `position:"Body" name:"H5Id"`
	TenantId    string `position:"Body" name:"TenantId"`
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// GetMdsMiniConfigResponse is the response struct for api GetMdsMiniConfig
type GetMdsMiniConfigResponse struct {
	*responses.BaseResponse
	ResultMessage string        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string        `json:"ResultCode" xml:"ResultCode"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContent `json:"ResultContent" xml:"ResultContent"`
}

// CreateGetMdsMiniConfigRequest creates a request to invoke GetMdsMiniConfig API
func CreateGetMdsMiniConfigRequest() (request *GetMdsMiniConfigRequest) {
	request = &GetMdsMiniConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetMdsMiniConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMdsMiniConfigResponse creates a response to parse from GetMdsMiniConfig response
func CreateGetMdsMiniConfigResponse() (response *GetMdsMiniConfigResponse) {
	response = &GetMdsMiniConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
