package mns_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListQueue invokes the mns_open.ListQueue API synchronously
func (client *Client) ListQueue(request *ListQueueRequest) (response *ListQueueResponse, err error) {
	response = CreateListQueueResponse()
	err = client.DoAction(request, response)
	return
}

// ListQueueWithChan invokes the mns_open.ListQueue API asynchronously
func (client *Client) ListQueueWithChan(request *ListQueueRequest) (<-chan *ListQueueResponse, <-chan error) {
	responseChan := make(chan *ListQueueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListQueue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListQueueWithCallback invokes the mns_open.ListQueue API asynchronously
func (client *Client) ListQueueWithCallback(request *ListQueueRequest, callback func(response *ListQueueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListQueueResponse
		var err error
		defer close(result)
		response, err = client.ListQueue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListQueueRequest is the request struct for api ListQueue
type ListQueueRequest struct {
	*requests.RpcRequest
	QueueName string           `position:"Query" name:"QueueName"`
	PageNum   requests.Integer `position:"Query" name:"PageNum"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
}

// ListQueueResponse is the response struct for api ListQueue
type ListQueueResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int64  `json:"Code" xml:"Code"`
	Status    string `json:"Status" xml:"Status"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListQueueRequest creates a request to invoke ListQueue API
func CreateListQueueRequest() (request *ListQueueRequest) {
	request = &ListQueueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mns-open", "2022-01-19", "ListQueue", "mns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListQueueResponse creates a response to parse from ListQueue response
func CreateListQueueResponse() (response *ListQueueResponse) {
	response = &ListQueueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
