package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryVoiceIntercom invokes the linkvisual.QueryVoiceIntercom API synchronously
func (client *Client) QueryVoiceIntercom(request *QueryVoiceIntercomRequest) (response *QueryVoiceIntercomResponse, err error) {
	response = CreateQueryVoiceIntercomResponse()
	err = client.DoAction(request, response)
	return
}

// QueryVoiceIntercomWithChan invokes the linkvisual.QueryVoiceIntercom API asynchronously
func (client *Client) QueryVoiceIntercomWithChan(request *QueryVoiceIntercomRequest) (<-chan *QueryVoiceIntercomResponse, <-chan error) {
	responseChan := make(chan *QueryVoiceIntercomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryVoiceIntercom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryVoiceIntercomWithCallback invokes the linkvisual.QueryVoiceIntercom API asynchronously
func (client *Client) QueryVoiceIntercomWithCallback(request *QueryVoiceIntercomRequest, callback func(response *QueryVoiceIntercomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryVoiceIntercomResponse
		var err error
		defer close(result)
		response, err = client.QueryVoiceIntercom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryVoiceIntercomRequest is the request struct for api QueryVoiceIntercom
type QueryVoiceIntercomRequest struct {
	*requests.RpcRequest
	Scheme        string `position:"Query" name:"Scheme"`
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// QueryVoiceIntercomResponse is the response struct for api QueryVoiceIntercom
type QueryVoiceIntercomResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryVoiceIntercomRequest creates a request to invoke QueryVoiceIntercom API
func CreateQueryVoiceIntercomRequest() (request *QueryVoiceIntercomRequest) {
	request = &QueryVoiceIntercomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryVoiceIntercom", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryVoiceIntercomResponse creates a response to parse from QueryVoiceIntercom response
func CreateQueryVoiceIntercomResponse() (response *QueryVoiceIntercomResponse) {
	response = &QueryVoiceIntercomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
