package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDeviceDistributeJob invokes the iot.DeleteDeviceDistributeJob API synchronously
func (client *Client) DeleteDeviceDistributeJob(request *DeleteDeviceDistributeJobRequest) (response *DeleteDeviceDistributeJobResponse, err error) {
	response = CreateDeleteDeviceDistributeJobResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDeviceDistributeJobWithChan invokes the iot.DeleteDeviceDistributeJob API asynchronously
func (client *Client) DeleteDeviceDistributeJobWithChan(request *DeleteDeviceDistributeJobRequest) (<-chan *DeleteDeviceDistributeJobResponse, <-chan error) {
	responseChan := make(chan *DeleteDeviceDistributeJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDeviceDistributeJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDeviceDistributeJobWithCallback invokes the iot.DeleteDeviceDistributeJob API asynchronously
func (client *Client) DeleteDeviceDistributeJobWithCallback(request *DeleteDeviceDistributeJobRequest, callback func(response *DeleteDeviceDistributeJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDeviceDistributeJobResponse
		var err error
		defer close(result)
		response, err = client.DeleteDeviceDistributeJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDeviceDistributeJobRequest is the request struct for api DeleteDeviceDistributeJob
type DeleteDeviceDistributeJobRequest struct {
	*requests.RpcRequest
	JobId       string `position:"Query" name:"JobId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// DeleteDeviceDistributeJobResponse is the response struct for api DeleteDeviceDistributeJob
type DeleteDeviceDistributeJobResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteDeviceDistributeJobRequest creates a request to invoke DeleteDeviceDistributeJob API
func CreateDeleteDeviceDistributeJobRequest() (request *DeleteDeviceDistributeJobRequest) {
	request = &DeleteDeviceDistributeJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteDeviceDistributeJob", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDeviceDistributeJobResponse creates a response to parse from DeleteDeviceDistributeJob response
func CreateDeleteDeviceDistributeJobResponse() (response *DeleteDeviceDistributeJobResponse) {
	response = &DeleteDeviceDistributeJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
