package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseEdgeInstanceDeployment invokes the iot.CloseEdgeInstanceDeployment API synchronously
func (client *Client) CloseEdgeInstanceDeployment(request *CloseEdgeInstanceDeploymentRequest) (response *CloseEdgeInstanceDeploymentResponse, err error) {
	response = CreateCloseEdgeInstanceDeploymentResponse()
	err = client.DoAction(request, response)
	return
}

// CloseEdgeInstanceDeploymentWithChan invokes the iot.CloseEdgeInstanceDeployment API asynchronously
func (client *Client) CloseEdgeInstanceDeploymentWithChan(request *CloseEdgeInstanceDeploymentRequest) (<-chan *CloseEdgeInstanceDeploymentResponse, <-chan error) {
	responseChan := make(chan *CloseEdgeInstanceDeploymentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseEdgeInstanceDeployment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseEdgeInstanceDeploymentWithCallback invokes the iot.CloseEdgeInstanceDeployment API asynchronously
func (client *Client) CloseEdgeInstanceDeploymentWithCallback(request *CloseEdgeInstanceDeploymentRequest, callback func(response *CloseEdgeInstanceDeploymentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseEdgeInstanceDeploymentResponse
		var err error
		defer close(result)
		response, err = client.CloseEdgeInstanceDeployment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseEdgeInstanceDeploymentRequest is the request struct for api CloseEdgeInstanceDeployment
type CloseEdgeInstanceDeploymentRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// CloseEdgeInstanceDeploymentResponse is the response struct for api CloseEdgeInstanceDeployment
type CloseEdgeInstanceDeploymentResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateCloseEdgeInstanceDeploymentRequest creates a request to invoke CloseEdgeInstanceDeployment API
func CreateCloseEdgeInstanceDeploymentRequest() (request *CloseEdgeInstanceDeploymentRequest) {
	request = &CloseEdgeInstanceDeploymentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CloseEdgeInstanceDeployment", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloseEdgeInstanceDeploymentResponse creates a response to parse from CloseEdgeInstanceDeployment response
func CreateCloseEdgeInstanceDeploymentResponse() (response *CloseEdgeInstanceDeploymentResponse) {
	response = &CloseEdgeInstanceDeploymentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
