package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLoginProfile invokes the ims.CreateLoginProfile API synchronously
func (client *Client) CreateLoginProfile(request *CreateLoginProfileRequest) (response *CreateLoginProfileResponse, err error) {
	response = CreateCreateLoginProfileResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLoginProfileWithChan invokes the ims.CreateLoginProfile API asynchronously
func (client *Client) CreateLoginProfileWithChan(request *CreateLoginProfileRequest) (<-chan *CreateLoginProfileResponse, <-chan error) {
	responseChan := make(chan *CreateLoginProfileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLoginProfile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLoginProfileWithCallback invokes the ims.CreateLoginProfile API asynchronously
func (client *Client) CreateLoginProfileWithCallback(request *CreateLoginProfileRequest, callback func(response *CreateLoginProfileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLoginProfileResponse
		var err error
		defer close(result)
		response, err = client.CreateLoginProfile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLoginProfileRequest is the request struct for api CreateLoginProfile
type CreateLoginProfileRequest struct {
	*requests.RpcRequest
	AkProxySuffix          string           `position:"Query" name:"AkProxySuffix"`
	Password               string           `position:"Query" name:"Password"`
	GenerateRandomPassword requests.Boolean `position:"Query" name:"GenerateRandomPassword"`
	MFABindRequired        requests.Boolean `position:"Query" name:"MFABindRequired"`
	PasswordResetRequired  requests.Boolean `position:"Query" name:"PasswordResetRequired"`
	UserPrincipalName      string           `position:"Query" name:"UserPrincipalName"`
	Status                 string           `position:"Query" name:"Status"`
}

// CreateLoginProfileResponse is the response struct for api CreateLoginProfile
type CreateLoginProfileResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	LoginProfile LoginProfile `json:"LoginProfile" xml:"LoginProfile"`
}

// CreateCreateLoginProfileRequest creates a request to invoke CreateLoginProfile API
func CreateCreateLoginProfileRequest() (request *CreateLoginProfileRequest) {
	request = &CreateLoginProfileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "CreateLoginProfile", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLoginProfileResponse creates a response to parse from CreateLoginProfile response
func CreateCreateLoginProfileResponse() (response *CreateLoginProfileResponse) {
	response = &CreateLoginProfileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
