package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentLymphNode invokes the imageprocess.SegmentLymphNode API synchronously
func (client *Client) SegmentLymphNode(request *SegmentLymphNodeRequest) (response *SegmentLymphNodeResponse, err error) {
	response = CreateSegmentLymphNodeResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentLymphNodeWithChan invokes the imageprocess.SegmentLymphNode API asynchronously
func (client *Client) SegmentLymphNodeWithChan(request *SegmentLymphNodeRequest) (<-chan *SegmentLymphNodeResponse, <-chan error) {
	responseChan := make(chan *SegmentLymphNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentLymphNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentLymphNodeWithCallback invokes the imageprocess.SegmentLymphNode API asynchronously
func (client *Client) SegmentLymphNodeWithCallback(request *SegmentLymphNodeRequest, callback func(response *SegmentLymphNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentLymphNodeResponse
		var err error
		defer close(result)
		response, err = client.SegmentLymphNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentLymphNodeRequest is the request struct for api SegmentLymphNode
type SegmentLymphNodeRequest struct {
	*requests.RpcRequest
	OrgName    string                     `position:"Body" name:"OrgName"`
	BodyPart   string                     `position:"Body" name:"BodyPart"`
	DataFormat string                     `position:"Body" name:"DataFormat"`
	URLList    *[]SegmentLymphNodeURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId      string                     `position:"Body" name:"OrgId"`
	Async      requests.Boolean           `position:"Body" name:"Async"`
}

// SegmentLymphNodeURLList is a repeated param struct in SegmentLymphNodeRequest
type SegmentLymphNodeURLList struct {
	URL string `name:"URL"`
}

// SegmentLymphNodeResponse is the response struct for api SegmentLymphNode
type SegmentLymphNodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentLymphNodeRequest creates a request to invoke SegmentLymphNode API
func CreateSegmentLymphNodeRequest() (request *SegmentLymphNodeRequest) {
	request = &SegmentLymphNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "SegmentLymphNode", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSegmentLymphNodeResponse creates a response to parse from SegmentLymphNode response
func CreateSegmentLymphNodeResponse() (response *SegmentLymphNodeResponse) {
	response = &SegmentLymphNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
